/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import io.quarkiverse.cxf.CXFClientInfo;
import io.quarkiverse.cxf.CXFRecorder;
import io.quarkiverse.cxf.CXFRuntimeUtils;
import io.quarkiverse.cxf.CxfClientConfig;
import io.quarkiverse.cxf.CxfFixedConfig;
import io.quarkiverse.cxf.vertx.http.client.HttpClientPool;
import io.quarkiverse.cxf.vertx.http.client.VertxHttpClientHTTPConduit;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.configuration.security.ProxyAuthorizationPolicy;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HTTPConduitFactory;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.cxf.transport.http.HttpClientHTTPConduit;
import org.apache.cxf.transport.http.URLConnectionHTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.jboss.logging.Logger;

public class QuarkusHTTPConduitFactory
implements HTTPConduitFactory {
    private static final Logger log = Logger.getLogger(QuarkusHTTPConduitFactory.class);
    public static final String QUARKUS_CXF_DEFAULT_HTTP_CONDUIT_FACTORY = "QUARKUS_CXF_DEFAULT_HTTP_CONDUIT_FACTORY";
    static CxfClientConfig.HTTPConduitImpl defaultHTTPConduitImpl;
    private final HttpClientPool httpClientPool;
    private final CxfFixedConfig cxFixedConfig;
    private final CXFClientInfo cxfClientInfo;
    private final HTTPConduitFactory busHTTPConduitFactory;
    private final AuthorizationPolicy authorizationPolicy;
    private final CxfClientConfig.HTTPConduitImpl defaultHTTPConduitFactory;

    public QuarkusHTTPConduitFactory(HttpClientPool httpClientPool, CxfFixedConfig cxFixedConfig, CXFClientInfo cxfClientInfo, HTTPConduitFactory busHTTPConduitFactory, AuthorizationPolicy authorizationPolicy) {
        this.httpClientPool = httpClientPool;
        this.cxFixedConfig = cxFixedConfig;
        this.cxfClientInfo = cxfClientInfo;
        this.busHTTPConduitFactory = busHTTPConduitFactory;
        this.authorizationPolicy = authorizationPolicy;
        this.defaultHTTPConduitFactory = CxfClientConfig.HTTPConduitImpl.findDefaultHTTPConduitImpl();
    }

    public HTTPConduit createConduit(HTTPTransportFactory f, Bus b, EndpointInfo localInfo, EndpointReferenceType target) throws IOException {
        CxfClientConfig.HTTPConduitImpl httpConduitImpl = this.cxfClientInfo.getHttpConduitImpl();
        if (httpConduitImpl == null) {
            httpConduitImpl = this.cxFixedConfig.httpConduitFactory().orElse(null);
        }
        if (httpConduitImpl == null && CXFRecorder.isHc5Present() && this.busHTTPConduitFactory != null) {
            return this.configure(this.busHTTPConduitFactory.createConduit(f, b, localInfo, target), this.cxfClientInfo);
        }
        if (httpConduitImpl == null) {
            httpConduitImpl = CxfClientConfig.HTTPConduitImpl.QuarkusCXFDefault;
        }
        return this.configure((HTTPConduit)(switch (httpConduitImpl) {
            case CxfClientConfig.HTTPConduitImpl.CXFDefault -> {
                if (Boolean.getBoolean("org.apache.cxf.transport.http.forceURLConnection")) {
                    yield new URLConnectionHTTPConduit(b, localInfo, target);
                }
                yield new HttpClientHTTPConduit(b, localInfo, target);
            }
            case CxfClientConfig.HTTPConduitImpl.QuarkusCXFDefault -> {
                switch (this.defaultHTTPConduitFactory) {
                    case VertxHttpClientHTTPConduitFactory: {
                        yield new VertxHttpClientHTTPConduit(b, localInfo, target, this.httpClientPool);
                    }
                    case URLConnectionHTTPConduitFactory: {
                        yield new URLConnectionHTTPConduit(b, localInfo, target);
                    }
                    case HttpClientHTTPConduitFactory: {
                        yield new HttpClientHTTPConduit(b, localInfo, target);
                    }
                }
                throw new IllegalStateException("Unexpected " + CxfClientConfig.HTTPConduitImpl.class.getSimpleName() + " value: " + this.defaultHTTPConduitFactory);
            }
            case CxfClientConfig.HTTPConduitImpl.VertxHttpClientHTTPConduitFactory -> new VertxHttpClientHTTPConduit(b, localInfo, target, this.httpClientPool);
            case CxfClientConfig.HTTPConduitImpl.URLConnectionHTTPConduitFactory -> new URLConnectionHTTPConduit(b, localInfo, target);
            case CxfClientConfig.HTTPConduitImpl.HttpClientHTTPConduitFactory -> new HttpClientHTTPConduit(b, localInfo, target);
            default -> throw new IllegalStateException("Unexpected " + CxfClientConfig.HTTPConduitImpl.class.getSimpleName() + " value: " + httpConduitImpl);
        }), this.cxfClientInfo);
    }

    private HTTPConduit configure(HTTPConduit httpConduit, CXFClientInfo cxfClientInfo) throws IOException {
        String hostnameVerifierName = cxfClientInfo.getHostnameVerifier();
        String keyStorePath = cxfClientInfo.getKeyStore();
        String trustStorePath = cxfClientInfo.getTrustStore();
        if (hostnameVerifierName != null || keyStorePath != null || trustStorePath != null) {
            String pwd;
            InputStream is;
            TLSClientParameters tlsCP = new TLSClientParameters();
            if (hostnameVerifierName != null) {
                Optional<CxfClientConfig.WellKnownHostnameVerifier> wellKnownHostNameVerifierName = CxfClientConfig.WellKnownHostnameVerifier.of(hostnameVerifierName);
                if (wellKnownHostNameVerifierName.isPresent()) {
                    wellKnownHostNameVerifierName.get().configure(tlsCP);
                } else {
                    HostnameVerifier hostnameVerifier = (HostnameVerifier)CXFRuntimeUtils.getInstance(hostnameVerifierName, true);
                    if (hostnameVerifier == null) {
                        throw new RuntimeException("Could not find or instantiate " + hostnameVerifierName);
                    }
                    tlsCP.setHostnameVerifier(hostnameVerifier);
                }
            }
            if (keyStorePath != null) {
                KeyManagerFactory kmf;
                try {
                    is = this.openStream(keyStorePath);
                    try {
                        KeyStore keyStore = KeyStore.getInstance(cxfClientInfo.getKeyStoreType());
                        pwd = cxfClientInfo.getKeyStorePassword();
                        keyStore.load(is, pwd == null ? null : pwd.toCharArray());
                        kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                        String keyPassword = cxfClientInfo.getKeyPassword();
                        kmf.init(keyStore, keyPassword != null ? keyPassword.toCharArray() : null);
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                    throw new RuntimeException("Could not load " + keyStorePath + " from class path or filesystem", e);
                }
                tlsCP.setKeyManagers(kmf.getKeyManagers());
            }
            if (trustStorePath != null) {
                TrustManagerFactory tmf;
                try {
                    is = this.openStream(trustStorePath);
                    try {
                        KeyStore trustStore = KeyStore.getInstance(cxfClientInfo.getTrustStoreType());
                        pwd = cxfClientInfo.getTrustStorePassword();
                        trustStore.load(is, pwd == null ? null : pwd.toCharArray());
                        tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        tmf.init(trustStore);
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                    throw new RuntimeException("Could not load " + trustStorePath + " from class path or filesystem", e);
                }
                tlsCP.setTrustManagers(tmf.getTrustManagers());
            }
            httpConduit.setTlsClientParameters(tlsCP);
        }
        HTTPClientPolicy policy = new HTTPClientPolicy();
        httpConduit.setClient(policy);
        policy.setConnectionTimeout(cxfClientInfo.getConnectionTimeout().longValue());
        policy.setReceiveTimeout(cxfClientInfo.getReceiveTimeout().longValue());
        policy.setConnectionRequestTimeout(cxfClientInfo.getConnectionRequestTimeout().longValue());
        policy.setAutoRedirect(cxfClientInfo.isAutoRedirect());
        policy.setMaxRetransmits(cxfClientInfo.getMaxRetransmits());
        policy.setAllowChunking(cxfClientInfo.isAllowChunking());
        policy.setChunkingThreshold(cxfClientInfo.getChunkingThreshold());
        policy.setChunkLength(cxfClientInfo.getChunkLength());
        Object value = cxfClientInfo.getAccept();
        if (value != null) {
            policy.setAccept((String)value);
        }
        if ((value = cxfClientInfo.getAcceptLanguage()) != null) {
            policy.setAcceptLanguage((String)value);
        }
        if ((value = cxfClientInfo.getAcceptEncoding()) != null) {
            policy.setAcceptEncoding((String)value);
        }
        if ((value = cxfClientInfo.getContentType()) != null) {
            policy.setContentType((String)value);
        }
        if ((value = cxfClientInfo.getHost()) != null) {
            policy.setHost((String)value);
        }
        policy.setConnection(cxfClientInfo.getConnection());
        value = cxfClientInfo.getCacheControl();
        if (value != null) {
            policy.setCacheControl((String)value);
        }
        policy.setVersion(cxfClientInfo.getVersion());
        value = cxfClientInfo.getBrowserType();
        if (value != null) {
            policy.setBrowserType((String)value);
        }
        if ((value = cxfClientInfo.getDecoupledEndpoint()) != null) {
            policy.setDecoupledEndpoint((String)value);
        }
        if ((value = cxfClientInfo.getProxyServer()) != null) {
            policy.setProxyServer((String)value);
        }
        if ((value = cxfClientInfo.getProxyServerPort()) != null) {
            policy.setProxyServerPort((Integer)value);
        }
        if ((value = cxfClientInfo.getNonProxyHosts()) != null) {
            policy.setNonProxyHosts((String)value);
        }
        policy.setProxyServerType(cxfClientInfo.getProxyServerType());
        String proxyUsername = cxfClientInfo.getProxyUsername();
        if (proxyUsername != null) {
            String proxyPassword = cxfClientInfo.getProxyPassword();
            ProxyAuthorizationPolicy proxyAuth = new ProxyAuthorizationPolicy();
            proxyAuth.setUserName(proxyUsername);
            proxyAuth.setPassword(proxyPassword);
            httpConduit.setProxyAuthorization(proxyAuth);
        }
        if (this.authorizationPolicy != null && cxfClientInfo.isSecureWsdlAccess()) {
            httpConduit.setAuthorization(this.authorizationPolicy);
        }
        return httpConduit;
    }

    private InputStream openStream(String keystorePath) throws IOException {
        URL url = Thread.currentThread().getContextClassLoader().getResource(keystorePath);
        if (url != null) {
            try {
                return url.openStream();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not open " + keystorePath + " from the class path", e);
            }
        }
        Path path = Path.of(keystorePath, new String[0]);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                return Files.newInputStream(path, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not open " + keystorePath + " from the filesystem", e);
            }
        }
        String msg = "Resource " + keystorePath + " exists neither in class path nor in the filesystem";
        log.error((Object)msg);
        throw new IllegalStateException(msg);
    }
}

