/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import io.quarkiverse.cxf.CXFClientData;
import io.quarkiverse.cxf.CXFRuntimeUtils;
import io.quarkiverse.cxf.CxfClientConfig;
import io.quarkiverse.cxf.CxfConfig;
import io.quarkiverse.cxf.CxfTlsConfiguration;
import io.quarkiverse.cxf.HTTPConduitImpl;
import io.quarkus.arc.Arc;
import io.quarkus.arc.Unremovable;
import io.quarkus.tls.TlsConfiguration;
import io.quarkus.tls.TlsConfigurationRegistry;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.KeyStoreOptionsBase;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.TrustOptions;
import java.lang.annotation.Annotation;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.cxf.annotations.SchemaValidation;
import org.apache.cxf.transports.http.configuration.ConnectionType;
import org.apache.cxf.transports.http.configuration.ProxyServerType;

@Unremovable
public class CXFClientInfo {
    private static final String DEFAULT_EP_ADDR = "http://localhost:8080";
    private final String sei;
    private final String endpointAddress;
    private final String wsdlUrl;
    private final String soapBinding;
    private final String wsNamespace;
    private final String wsName;
    private final String epNamespace;
    private final String epName;
    private final String username;
    private final String password;
    private final boolean proxyClassRuntimeInitialized;
    private final List<String> inInterceptors = new ArrayList<String>();
    private final List<String> outInterceptors = new ArrayList<String>();
    private final List<String> outFaultInterceptors = new ArrayList<String>();
    private final List<String> inFaultInterceptors = new ArrayList<String>();
    private final List<String> features = new ArrayList<String>();
    private final List<String> handlers = new ArrayList<String>();
    private final long connectionTimeout;
    private final long receiveTimeout;
    private final long connectionRequestTimeout;
    private final boolean autoRedirect;
    private final boolean redirectRelativeUri;
    private final int maxRetransmits;
    private final boolean allowChunking;
    private final int chunkingThreshold;
    private final int chunkLength;
    private final String accept;
    private final String acceptLanguage;
    private final String acceptEncoding;
    private final String contentType;
    private final String host;
    private final ConnectionType connection;
    private final String cacheControl;
    private final String version;
    private final String browserType;
    private final String decoupledEndpoint;
    private final String decoupledEndpointBase;
    private final String proxyServer;
    private final Integer proxyServerPort;
    private final String nonProxyHosts;
    private final ProxyServerType proxyServerType;
    private final String proxyUsername;
    private final String proxyPassword;
    private final String tlsConfigurationName;
    private final TlsConfiguration tlsConfiguration;
    private final String hostnameVerifier;
    private final HTTPConduitImpl httpConduitImpl;
    private final String configKey;
    private final SchemaValidation.SchemaValidationType schemaValidationEnabledFor;
    private final boolean secureWsdlAccess;

    public CXFClientInfo(CXFClientData other, CxfConfig cxfConfig, CxfClientConfig config, String configKey, Vertx vertx) {
        Objects.requireNonNull(config);
        this.sei = other.getSei();
        this.soapBinding = config.soapBinding().orElse(other.getSoapBinding());
        this.wsName = other.getWsName();
        this.wsNamespace = other.getWsNamespace();
        this.proxyClassRuntimeInitialized = other.isProxyClassRuntimeInitialized();
        this.epNamespace = config.endpointNamespace().orElse(null);
        this.epName = config.endpointName().orElse(null);
        this.username = config.username().orElse(null);
        this.password = config.password().orElse(null);
        this.secureWsdlAccess = config.secureWsdlAccess();
        this.endpointAddress = config.clientEndpointUrl().orElse("http://localhost:8080/" + this.sei.toLowerCase());
        this.wsdlUrl = config.wsdlPath().orElse(null);
        this.addFeatures(config);
        this.addHandlers(config);
        this.addInterceptors(config);
        this.connectionTimeout = config.connectionTimeout();
        this.receiveTimeout = config.receiveTimeout();
        this.connectionRequestTimeout = config.connectionRequestTimeout();
        this.autoRedirect = config.autoRedirect();
        this.redirectRelativeUri = config.redirectRelativeUri();
        this.maxRetransmits = config.maxRetransmits();
        this.allowChunking = config.allowChunking();
        this.chunkingThreshold = config.chunkingThreshold();
        this.chunkLength = config.chunkLength();
        this.accept = config.accept().orElse(null);
        this.acceptLanguage = config.acceptLanguage().orElse(null);
        this.acceptEncoding = config.acceptEncoding().orElse(null);
        this.contentType = config.contentType().orElse(null);
        this.host = config.host().orElse(null);
        this.connection = config.connection();
        this.cacheControl = config.cacheControl().orElse(null);
        this.version = config.version();
        this.browserType = config.browserType().orElse(null);
        this.decoupledEndpoint = config.decoupledEndpoint().orElse(null);
        this.decoupledEndpointBase = cxfConfig.decoupledEndpointBase().orElse(null);
        this.proxyServer = config.proxyServer().orElse(null);
        this.proxyServerPort = config.proxyServerPort().orElse(null);
        this.nonProxyHosts = config.nonProxyHosts().orElse(null);
        this.proxyServerType = config.proxyServerType();
        this.proxyUsername = config.proxyUsername().orElse(null);
        this.proxyPassword = config.proxyPassword().orElse(null);
        this.tlsConfigurationName = config.tlsConfigurationName().orElse(null);
        this.tlsConfiguration = CXFClientInfo.tlsConfiguration(vertx, config, configKey);
        this.hostnameVerifier = config.hostnameVerifier().orElse(null);
        this.schemaValidationEnabledFor = config.schemaValidationEnabledFor().orElse(null);
        this.httpConduitImpl = config.httpConduitFactory().orElse(null);
        this.configKey = configKey;
    }

    static TlsConfiguration tlsConfiguration(Vertx vertx, CxfClientConfig config, String configKey) {
        TlsConfigurationRegistry tlsRegistry = (TlsConfigurationRegistry)Arc.container().select(TlsConfigurationRegistry.class, new Annotation[0]).get();
        Optional<String> maybeTlsConfigName = config.tlsConfigurationName();
        if (maybeTlsConfigName.isEmpty()) {
            if (config.keyStore().isPresent() || config.trustStore().isPresent()) {
                KeyStore trustStore;
                KeyStoreOptionsBase trustOptions;
                KeyStore keyStore;
                KeyStoreOptionsBase keyStoreOptions;
                String registryKey = "quarkus-cxf-client-" + configKey;
                Optional cachedTlsConfiguration = tlsRegistry.get(registryKey);
                if (cachedTlsConfiguration.isPresent()) {
                    return (TlsConfiguration)cachedTlsConfiguration.get();
                }
                if (config.keyStore().isPresent()) {
                    keyStoreOptions = CXFClientInfo.keyStoreOptions(config.keyStoreType(), "quarkus.cxf.client." + configKey + ".key-store-type");
                    keyStoreOptions.setPassword((String)config.keyStorePassword().orElse(null)).setValue(Buffer.buffer((byte[])CXFRuntimeUtils.read(config.keyStore().get()))).setPath((String)config.keyStore().orElse(null));
                    if (config.keyPassword().isPresent()) {
                        keyStoreOptions.setAliasPassword(config.keyPassword().get());
                    }
                    try {
                        keyStore = keyStoreOptions.loadKeyStore(vertx);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not load key store from " + config.keyStore().get(), e);
                    }
                } else {
                    keyStore = null;
                    keyStoreOptions = null;
                }
                if (config.trustStore().isPresent()) {
                    trustOptions = CXFClientInfo.keyStoreOptions(config.trustStoreType(), "quarkus.cxf.client." + configKey + ".trust-store-type");
                    trustOptions.setPassword((String)config.trustStorePassword().orElse(null)).setValue(Buffer.buffer((byte[])CXFRuntimeUtils.read(config.trustStore().get()))).setPath((String)config.trustStore().orElse(null));
                    try {
                        trustStore = trustOptions.loadKeyStore(vertx);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Could not load trust store from " + config.trustStore().get(), e);
                    }
                } else {
                    trustOptions = null;
                    trustStore = null;
                }
                CxfTlsConfiguration cxfTlsConfiguration = new CxfTlsConfiguration((KeyCertOptions)keyStoreOptions, keyStore, (TrustOptions)trustOptions, trustStore);
                tlsRegistry.register(registryKey, (TlsConfiguration)cxfTlsConfiguration);
                return cxfTlsConfiguration;
            }
            return null;
        }
        if (config.keyStore().isPresent()) {
            throw new IllegalStateException("The configuration options quarkus.cxf.client." + configKey + ".tls-configuration-name and quarkus.cxf.client." + configKey + ".key-store cannot be both set at the same time. Use one or the other way to set the TLS options.");
        }
        if (config.trustStore().isPresent()) {
            throw new IllegalStateException("The configuration options quarkus.cxf.client." + configKey + ".tls-configuration-name and quarkus.cxf.client." + configKey + ".trust-store cannot be both set at the same time. Use one or the other way to set the TLS options.");
        }
        Optional maybeTlsConfig = tlsRegistry.get(maybeTlsConfigName.get());
        if (maybeTlsConfig.isPresent()) {
            return (TlsConfiguration)maybeTlsConfig.get();
        }
        throw new IllegalStateException("No such TLS configuration quarkus.tls." + maybeTlsConfigName.get());
    }

    private static KeyStoreOptionsBase keyStoreOptions(String type, String configKey) {
        return switch (type.toUpperCase(Locale.ROOT)) {
            case "JKS" -> new JksOptions();
            case "PKCS12" -> new PfxOptions();
            default -> throw new IllegalArgumentException("Unexpected key store type " + type + " for " + configKey);
        };
    }

    public String getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public String getSei() {
        return this.sei;
    }

    public String getEndpointAddress() {
        return this.endpointAddress;
    }

    public String getWsdlUrl() {
        return this.wsdlUrl;
    }

    public String getSoapBinding() {
        return this.soapBinding;
    }

    public String getWsNamespace() {
        return this.wsNamespace;
    }

    public String getWsName() {
        return this.wsName;
    }

    public String getEpNamespace() {
        return this.epNamespace;
    }

    public String getEpName() {
        return this.epName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isProxyClassRuntimeInitialized() {
        return this.proxyClassRuntimeInitialized;
    }

    public List<String> getFeatures() {
        return this.features;
    }

    public List<String> getHandlers() {
        return this.handlers;
    }

    public List<String> getInInterceptors() {
        return this.inInterceptors;
    }

    public List<String> getOutInterceptors() {
        return this.outInterceptors;
    }

    public List<String> getOutFaultInterceptors() {
        return this.outFaultInterceptors;
    }

    public List<String> getInFaultInterceptors() {
        return this.inFaultInterceptors;
    }

    private CXFClientInfo addInterceptors(CxfClientConfig cxfEndPointConfig) {
        if (cxfEndPointConfig.inInterceptors().isPresent()) {
            this.inInterceptors.addAll((Collection<String>)cxfEndPointConfig.inInterceptors().get());
        }
        if (cxfEndPointConfig.outInterceptors().isPresent()) {
            this.outInterceptors.addAll((Collection<String>)cxfEndPointConfig.outInterceptors().get());
        }
        if (cxfEndPointConfig.outFaultInterceptors().isPresent()) {
            this.outFaultInterceptors.addAll((Collection<String>)cxfEndPointConfig.outFaultInterceptors().get());
        }
        if (cxfEndPointConfig.inFaultInterceptors().isPresent()) {
            this.inFaultInterceptors.addAll((Collection<String>)cxfEndPointConfig.inFaultInterceptors().get());
        }
        return this;
    }

    private CXFClientInfo addFeatures(CxfClientConfig cxfEndPointConfig) {
        if (cxfEndPointConfig.features().isPresent()) {
            this.features.addAll((Collection<String>)cxfEndPointConfig.features().get());
        }
        return this;
    }

    private CXFClientInfo addHandlers(CxfClientConfig cxfEndPointConfig) {
        if (cxfEndPointConfig.handlers().isPresent()) {
            this.handlers.addAll((Collection<String>)cxfEndPointConfig.handlers().get());
        }
        return this;
    }

    public Long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Long getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public Long getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public boolean isAutoRedirect() {
        return this.autoRedirect;
    }

    public boolean isRedirectRelativeUri() {
        return this.redirectRelativeUri;
    }

    public int getMaxRetransmits() {
        return this.maxRetransmits;
    }

    public boolean isAllowChunking() {
        return this.allowChunking;
    }

    public int getChunkingThreshold() {
        return this.chunkingThreshold;
    }

    public int getChunkLength() {
        return this.chunkLength;
    }

    public String getAccept() {
        return this.accept;
    }

    public String getAcceptLanguage() {
        return this.acceptLanguage;
    }

    public String getAcceptEncoding() {
        return this.acceptEncoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getHost() {
        return this.host;
    }

    public ConnectionType getConnection() {
        return this.connection;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBrowserType() {
        return this.browserType;
    }

    public String getDecoupledEndpoint() {
        return this.decoupledEndpoint;
    }

    public String getDecoupledEndpointBase() {
        return this.decoupledEndpointBase;
    }

    public String getProxyServer() {
        return this.proxyServer;
    }

    public Integer getProxyServerPort() {
        return this.proxyServerPort;
    }

    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    public ProxyServerType getProxyServerType() {
        return this.proxyServerType;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public HTTPConduitImpl getHttpConduitImpl() {
        return this.httpConduitImpl;
    }

    public String getTlsConfigurationName() {
        return this.tlsConfigurationName;
    }

    public TlsConfiguration getTlsConfiguration() {
        return this.tlsConfiguration;
    }

    public String getConfigKey() {
        return this.configKey;
    }

    public SchemaValidation.SchemaValidationType getSchemaValidationEnabledFor() {
        return this.schemaValidationEnabledFor;
    }

    public boolean isSecureWsdlAccess() {
        return this.secureWsdlAccess;
    }
}

