/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import io.quarkiverse.cxf.CXFClientInfo;
import io.quarkiverse.cxf.HTTPConduitSpec;
import io.quarkiverse.cxf.QuarkusHTTPConduitFactory;
import io.quarkiverse.cxf.QuarkusTLSClientParameters;
import io.quarkiverse.cxf.vertx.http.client.HttpClientPool;
import io.quarkiverse.cxf.vertx.http.client.VertxHttpClientHTTPConduit;
import java.io.IOException;
import org.apache.cxf.Bus;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transport.http.HttpClientHTTPConduit;
import org.apache.cxf.transport.http.URLConnectionHTTPConduit;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum HTTPConduitImpl implements HTTPConduitSpec
{
    QuarkusCXFDefault{
        private HTTPConduitImpl defaultHTTPConduitImpl;

        @Override
        public HTTPConduitImpl resolveDefault() {
            HTTPConduitImpl result = this.defaultHTTPConduitImpl;
            if (result == null) {
                this.defaultHTTPConduitImpl = result = 1.findDefaultHTTPConduitImpl();
            }
            return result;
        }
    }
    ,
    CXFDefault{

        @Override
        public HTTPConduitImpl resolveDefault() {
            if (Boolean.getBoolean("org.apache.cxf.transport.http.forceURLConnection")) {
                return URLConnectionHTTPConduitFactory;
            }
            return HttpClientHTTPConduitFactory;
        }
    }
    ,
    VertxHttpClientHTTPConduitFactory{

        @Override
        public HTTPConduit createConduit(HttpClientPool httpClientPool, Bus b, EndpointInfo localInfo, EndpointReferenceType target) throws IOException {
            return new VertxHttpClientHTTPConduit(b, localInfo, target, httpClientPool);
        }

        @Override
        public TLSClientParameters createTLSClientParameters(CXFClientInfo cxfClientInfo) {
            if (cxfClientInfo.getHostnameVerifier() != null) {
                throw new IllegalStateException(this.getConduitDescription() + " does not support quarkus.cxf.client." + cxfClientInfo.getConfigKey() + ".hostname-verifier. AllowAllHostnameVerifier can be replaced by using a named TLS configuration (via quarkus.cxf.client." + cxfClientInfo.getConfigKey() + ".tls-configuration-name) with quarkus.tls.\"tls-bucket-name\".hostname-verification-algorithm set to NONE");
            }
            return new QuarkusTLSClientParameters(cxfClientInfo.getTlsConfigurationName(), cxfClientInfo.getTlsConfiguration());
        }
    }
    ,
    HttpClientHTTPConduitFactory{

        @Override
        public HTTPConduit createConduit(HttpClientPool httpClientPool, Bus b, EndpointInfo localInfo, EndpointReferenceType target) throws IOException {
            return new HttpClientHTTPConduit(b, localInfo, target);
        }
    }
    ,
    URLConnectionHTTPConduitFactory{

        @Override
        public HTTPConduit createConduit(HttpClientPool httpClientPool, Bus b, EndpointInfo localInfo, EndpointReferenceType target) throws IOException {
            return new URLConnectionHTTPConduit(b, localInfo, target);
        }
    };


    public static HTTPConduitImpl findDefaultHTTPConduitImpl() {
        if (QuarkusHTTPConduitFactory.defaultHTTPConduitImpl == null) {
            String defaultName = System.getenv("QUARKUS_CXF_DEFAULT_HTTP_CONDUIT_FACTORY");
            QuarkusHTTPConduitFactory.defaultHTTPConduitImpl = defaultName == null || defaultName.isEmpty() ? VertxHttpClientHTTPConduitFactory : HTTPConduitImpl.valueOf(defaultName);
        }
        return QuarkusHTTPConduitFactory.defaultHTTPConduitImpl;
    }

    @Override
    public HTTPConduit createConduit(HttpClientPool httpClientPool, Bus b, EndpointInfo localInfo, EndpointReferenceType target) throws IOException {
        throw new IllegalStateException("Call " + HTTPConduitImpl.class.getName() + ".resolveDefault() before calling createConduit()");
    }

    @Override
    public String getConduitDescription() {
        return "http-conduit-factory = " + this.name();
    }
}

