/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.transport;

import io.quarkiverse.cxf.transport.servlet.DateUtils;
import io.quarkiverse.cxf.transport.servlet.LocaleUtils;
import io.quarkus.security.identity.CurrentIdentityAssociation;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.VertxInputStream;
import io.quarkus.vertx.http.runtime.security.QuarkusHttpUser;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.web.RoutingContext;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.ReadListener;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConnection;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.apache.cxf.common.util.UrlUtils;

public class VertxHttpServletRequest
implements HttpServletRequest {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String SSL_CIPHER_SUITE_ATTRIBUTE = "jakarta.servlet.request.cipher_suite";
    private static final String SSL_PEER_CERT_CHAIN_ATTRIBUTE = "jakarta.servlet.request.X509Certificate";
    private final RoutingContext context;
    private final VertxInputStream in;
    private final HttpServerRequest request;
    private final String contextPath;
    private final String servletPath;
    private final Map<String, Object> attributes;
    private Cookie[] cookies;
    private String characterEncoding;

    public VertxHttpServletRequest(RoutingContext context, String contextPath, String servletPath) {
        this.request = context.request();
        this.contextPath = contextPath;
        this.servletPath = servletPath;
        this.attributes = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        this.context = context;
        this.in = new VertxInputStream(context, 10000L);
        SSLSession sslSession = this.request.connection().sslSession();
        if (sslSession != null) {
            this.attributes.put(SSL_CIPHER_SUITE_ATTRIBUTE, sslSession.getCipherSuite());
            try {
                this.attributes.put(SSL_PEER_CERT_CHAIN_ATTRIBUTE, sslSession.getPeerCertificates());
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                // empty catch block
            }
        }
    }

    public AsyncContext getAsyncContext() {
        throw new UnsupportedOperationException("Unsupported method " + this.getClass().getName() + ".getAsyncContext()");
    }

    public DispatcherType getDispatcherType() {
        throw new UnsupportedOperationException("Unsupported method " + this.getClass().getName() + ".getDispatcherType()");
    }

    public String getRequestId() {
        throw new UnsupportedOperationException("Unsupported method " + this.getClass().getName() + ".getRequestId()");
    }

    public String getProtocolRequestId() {
        throw new UnsupportedOperationException("Unsupported method " + this.getClass().getName() + ".getProtocolRequestId()");
    }

    public ServletConnection getServletConnection() {
        throw new UnsupportedOperationException("Unsupported method " + this.getClass().getName() + ".getServletConnection()");
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.attributes.isEmpty() ? Collections.emptyEnumeration() : Collections.enumeration(this.attributes.keySet());
    }

    public String getCharacterEncoding() {
        if (this.characterEncoding == null) {
            this.characterEncoding = this.getCharacterEncodingFromHeader();
        }
        return this.characterEncoding;
    }

    public int getContentLength() {
        return this.getIntHeader("Content-Length");
    }

    public String getContentType() {
        return this.request.getHeader("Content-Type");
    }

    public ServletInputStream getInputStream() throws IOException {
        return new ServletInputStream(){

            public int read() throws IOException {
                return VertxHttpServletRequest.this.in.read();
            }

            public int read(byte[] b, int off, int len) throws IOException {
                return VertxHttpServletRequest.this.in.read(b, off, len);
            }

            public boolean isFinished() {
                try {
                    return VertxHttpServletRequest.this.in.available() == -1;
                }
                catch (IOException e) {
                    return true;
                }
            }

            public boolean isReady() {
                return !this.isFinished();
            }

            public void setReadListener(ReadListener readListener) {
                throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName() + ".setReadListener(ReadListener)");
            }
        };
    }

    public String getLocalAddr() {
        SocketAddress adr = this.request.localAddress();
        if (adr != null) {
            return adr.hostAddress();
        }
        return null;
    }

    public String getLocalName() {
        SocketAddress adr = this.request.localAddress();
        if (adr != null) {
            return adr.host();
        }
        return null;
    }

    public int getLocalPort() {
        SocketAddress adr = this.request.localAddress();
        if (adr != null) {
            return adr.port();
        }
        return -1;
    }

    public Locale getLocale() {
        return this.getLocales().nextElement();
    }

    public Enumeration<Locale> getLocales() {
        List acceptLanguage = this.request.headers().getAll("Accept-Language");
        List<Locale> ret = LocaleUtils.getLocalesFromHeader(acceptLanguage);
        if (ret.isEmpty()) {
            return Collections.enumeration(Collections.singletonList(Locale.getDefault()));
        }
        return Collections.enumeration(ret);
    }

    public String getParameter(String name) {
        return this.request.getParam(name);
    }

    public Map<String, String[]> getParameterMap() {
        MultiMap params = this.request.params();
        if (params.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String[]> result = new LinkedHashMap<String, String[]>();
        for (String key : params.names()) {
            result.put(key, this.getParameterValues(key));
        }
        return result;
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.request.params().names());
    }

    public String[] getParameterValues(String name) {
        List list = this.request.params().getAll(name);
        if (list != null) {
            return (String[])list.toArray();
        }
        return EMPTY_STRING_ARRAY;
    }

    public String getProtocol() {
        return this.request.version().alpnName();
    }

    public BufferedReader getReader() throws IOException {
        Charset charset = StandardCharsets.UTF_8;
        return new BufferedReader(new InputStreamReader((InputStream)this.in, charset));
    }

    public String getRemoteAddr() {
        SocketAddress remoteAddress = this.request.remoteAddress();
        if (remoteAddress != null) {
            return remoteAddress.hostAddress();
        }
        return null;
    }

    public String getRemoteHost() {
        SocketAddress remoteAddress = this.request.remoteAddress();
        if (remoteAddress != null) {
            return remoteAddress.host();
        }
        return null;
    }

    public int getRemotePort() {
        SocketAddress remoteAddress = this.request.remoteAddress();
        if (remoteAddress != null) {
            return remoteAddress.port();
        }
        return -1;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new UnsupportedOperationException("Unsupported method " + this.getClass().getName() + ".getRequestDispatcher(String)");
    }

    public String getScheme() {
        return this.request.scheme();
    }

    public String getServerName() {
        return this.request.authority().host();
    }

    public int getServerPort() {
        return this.request.authority().port();
    }

    public ServletContext getServletContext() {
        throw new UnsupportedOperationException("Unsupported method " + this.getClass().getName() + ".getServletContext()");
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public boolean isSecure() {
        return this.request.isSSL();
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object o) {
        this.attributes.put(name, o);
    }

    private String getCharacterEncodingFromHeader() {
        String contentType = this.request.getHeader("Content-Type");
        if (contentType == null) {
            return null;
        }
        return VertxHttpServletRequest.extractQuotedValueFromHeader(contentType, "charset");
    }

    static String extractQuotedValueFromHeader(String header, String key) {
        char c;
        int end;
        int keypos = 0;
        int pos = -1;
        boolean whiteSpace = true;
        boolean inQuotes = false;
        for (int i = 0; i < header.length() - 1; ++i) {
            char c2 = header.charAt(i);
            if (inQuotes) {
                if (c2 != '\"') continue;
                inQuotes = false;
                continue;
            }
            if (key.charAt(keypos) == c2 && (whiteSpace || keypos > 0)) {
                ++keypos;
                whiteSpace = false;
            } else if (c2 == '\"') {
                keypos = 0;
                inQuotes = true;
                whiteSpace = false;
            } else {
                keypos = 0;
                boolean bl = whiteSpace = c2 == ' ' || c2 == ';' || c2 == '\t';
            }
            if (keypos != key.length()) continue;
            if (header.charAt(i + 1) == '=') {
                pos = i + 2;
                break;
            }
            keypos = 0;
        }
        if (pos == -1) {
            return null;
        }
        int start = pos;
        if (header.charAt(start) == '\"') {
            char c3;
            for (end = ++start; end < header.length() && (c3 = header.charAt(end)) != '\"'; ++end) {
            }
            return header.substring(start, end);
        }
        for (end = start; end < header.length() && (c = header.charAt(end)) != ' ' && c != '\t' && c != ';'; ++end) {
        }
        return header.substring(start, end);
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        throw new UnsupportedOperationException("Unsupported method " + this.getClass().getName() + ".setCharacterEncoding(String)");
    }

    public AsyncContext startAsync() {
        throw new UnsupportedOperationException("Unsupported method " + this.getClass().getName() + ".startAsync()");
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) {
        throw new UnsupportedOperationException("Unsupported method " + this.getClass().getName() + ".startAsync(ServletRequest, ServletResponse)");
    }

    public boolean authenticate(HttpServletResponse servletResponse) throws IOException, ServletException {
        throw new UnsupportedOperationException("Unsupported method " + this.getClass().getName() + ".authenticate(HttpServletResponse)");
    }

    public String getAuthType() {
        String authorizationValue = this.request.getHeader("Authorization");
        if (authorizationValue == null) {
            return null;
        }
        return authorizationValue.split(" ")[0].trim();
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public Cookie[] getCookies() {
        if (this.cookies == null) {
            Set vertxCookies = this.request.cookies();
            if (vertxCookies.isEmpty()) {
                return null;
            }
            int count = vertxCookies.size();
            Cookie[] value = new Cookie[count];
            int i = 0;
            for (io.vertx.core.http.Cookie cookie : vertxCookies) {
                try {
                    Cookie c = new Cookie(cookie.getName(), cookie.getValue());
                    if (cookie.getDomain() != null) {
                        c.setDomain(cookie.getDomain());
                    }
                    c.setHttpOnly(cookie.isHttpOnly());
                    if (cookie.getMaxAge() >= 0L) {
                        c.setMaxAge((int)cookie.getMaxAge());
                    }
                    if (cookie.getPath() != null) {
                        c.setPath(cookie.getPath());
                    }
                    c.setSecure(cookie.isSecure());
                    value[i++] = c;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            if (i < count) {
                Cookie[] shrunkCookies = new Cookie[i];
                System.arraycopy(value, 0, shrunkCookies, 0, i);
                value = shrunkCookies;
            }
            this.cookies = value;
        }
        return this.cookies;
    }

    public long getDateHeader(String name) {
        String header = this.request.getHeader(name);
        if (header == null) {
            return -1L;
        }
        Date date = DateUtils.parseDate(header);
        if (date == null) {
            throw new IllegalArgumentException(String.format("Header %s cannot be converted to a date", header));
        }
        return date.getTime();
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.request.headers().names());
    }

    public Enumeration<String> getHeaders(String name) {
        if (this.request.headers().contains(name)) {
            return Collections.enumeration(this.request.headers().getAll(name));
        }
        return Collections.emptyEnumeration();
    }

    public int getIntHeader(String name) {
        String v = this.getHeader(name);
        return v == null ? -1 : Integer.parseInt(v);
    }

    public String getMethod() {
        return this.request.method().name();
    }

    public Part getPart(String name) throws IOException, ServletException {
        throw new UnsupportedOperationException("Unsupported method " + this.getClass().getName() + ".getPart(String)");
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        throw new UnsupportedOperationException("Unsupported method " + this.getClass().getName() + ".getParts()");
    }

    public String getPathInfo() {
        String path = this.request.path();
        if (this.contextPath != null && !this.contextPath.equals("/") && this.contextPath.length() < path.length()) {
            path = path.substring(this.contextPath.length());
        }
        if (this.servletPath != null && !this.servletPath.equals("/") && this.servletPath.length() < path.length()) {
            path = path.substring(this.servletPath.length());
        }
        return UrlUtils.urlDecode((String)path);
    }

    public String getPathTranslated() {
        return null;
    }

    public String getQueryString() {
        return this.request.query();
    }

    public String getRemoteUser() {
        Principal userPrincipal = this.getUserPrincipal();
        return userPrincipal != null ? userPrincipal.getName() : null;
    }

    public String getRequestURI() {
        return this.request.uri();
    }

    public StringBuffer getRequestURL() {
        String url = this.request.absoluteURI();
        int index = url.indexOf("?");
        if (index > -1) {
            url = url.substring(0, index);
        }
        return new StringBuffer(url);
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        if (!create) {
            return null;
        }
        throw new UnsupportedOperationException("Unsupported method " + this.getClass().getName() + ".getSession(boolean)");
    }

    public Principal getUserPrincipal() {
        QuarkusHttpUser user = (QuarkusHttpUser)this.context.user();
        if (user == null || user.getSecurityIdentity().isAnonymous()) {
            return null;
        }
        return user.getSecurityIdentity().getPrincipal();
    }

    public boolean isRequestedSessionIdFromCookie() {
        throw new UnsupportedOperationException("Unsupported method " + this.getClass().getName() + ".isRequestedSessionIdFromCookie()");
    }

    public boolean isRequestedSessionIdFromURL() {
        throw new UnsupportedOperationException("Unsupported method " + this.getClass().getName() + ".isRequestedSessionIdFromURL()");
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isUserInRole(String role) {
        if (role == null) {
            return false;
        }
        if (role.equals("*")) {
            return false;
        }
        SecurityIdentity user = CurrentIdentityAssociation.current();
        if (role.equals("**")) {
            return !user.isAnonymous();
        }
        return user.hasRole(role);
    }

    public void login(String username, String password) throws ServletException {
        throw new UnsupportedOperationException("Unsupported method " + this.getClass().getName() + ".login(String, String)");
    }

    public void logout() throws ServletException {
        throw new UnsupportedOperationException("Unsupported method " + this.getClass().getName() + ".logout()");
    }

    public long getContentLengthLong() {
        String v = this.getHeader("Content-Length");
        return v == null ? -1L : Long.parseLong(v);
    }

    public String changeSessionId() {
        throw new UnsupportedOperationException("Unsupported method " + this.getClass().getName() + ".changeSessionId()");
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> arg0) throws IOException, ServletException {
        throw new UnsupportedOperationException("Unsupported method " + this.getClass().getName() + ".upgrade(Class<T>)");
    }
}

