/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.vertx.http.client;

import io.quarkus.tls.CertificateUpdatedEvent;
import io.quarkus.tls.TlsConfiguration;
import io.quarkus.tls.runtime.config.TlsConfigUtils;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpVersion;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.transport.http.HTTPConduit;

@ApplicationScoped
public class HttpClientPool {
    private final Map<ClientSpec, HttpClient> clients = new ConcurrentHashMap<ClientSpec, HttpClient>();
    private final Vertx vertx;

    HttpClientPool() {
        this(null);
    }

    @Inject
    public HttpClientPool(Vertx vertx) {
        this.vertx = vertx;
    }

    public HttpClient getClient(ClientSpec spec) {
        return this.clients.computeIfAbsent(spec, v -> {
            HttpClientOptions opts = new HttpClientOptions().setProtocolVersion(spec.getVersion());
            if (spec.isSsl()) {
                TlsConfigUtils.configure((HttpClientOptions)opts, (TlsConfiguration)spec.tlsConfiguration);
            }
            return this.vertx.createHttpClient(opts);
        });
    }

    public void onCertificateUpdate(@Observes CertificateUpdatedEvent event) {
        String tlsConfigName = event.name();
        if (tlsConfigName != null) {
            Iterator<ClientSpec> it = this.clients.keySet().iterator();
            while (it.hasNext()) {
                ClientSpec spec = it.next();
                if (!tlsConfigName.equals(spec.tlsConfigurationName)) continue;
                it.remove();
            }
        }
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public static class ClientSpec {
        protected static final Logger LOG = LogUtils.getL7dLogger(HTTPConduit.class);
        private final HttpVersion httpVersion;
        private final TlsConfiguration tlsConfiguration;
        private final String tlsConfigurationName;
        private final int hashCode;

        public ClientSpec(HttpVersion version, String tlsConfigurationName, TlsConfiguration tlsConfiguration) {
            this.httpVersion = version;
            this.tlsConfigurationName = tlsConfigurationName;
            this.tlsConfiguration = tlsConfiguration;
            int h = 31 + this.httpVersion.hashCode();
            if (this.tlsConfiguration != null) {
                h = 31 * h + this.tlsConfiguration.hashCode();
            }
            this.hashCode = h;
        }

        public boolean isSsl() {
            return this.tlsConfiguration != null;
        }

        public HttpVersion getVersion() {
            return this.httpVersion;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClientSpec other = (ClientSpec)obj;
            return this.httpVersion == other.httpVersion && Objects.equals(this.tlsConfiguration, other.tlsConfiguration);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

