/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import io.quarkiverse.cxf.CXFClientData;
import io.quarkiverse.cxf.CXFRuntimeUtils;
import io.quarkiverse.cxf.CXFServletInfo;
import io.quarkiverse.cxf.CXFServletInfos;
import io.quarkiverse.cxf.CxfConfig;
import io.quarkiverse.cxf.CxfEndpointConfig;
import io.quarkiverse.cxf.CxfFixedConfig;
import io.quarkiverse.cxf.HTTPConduitImpl;
import io.quarkiverse.cxf.HTTPConduitSpec;
import io.quarkiverse.cxf.QuarkusBusFactory;
import io.quarkiverse.cxf.annotation.CXFEndpoint;
import io.quarkiverse.cxf.transport.CxfHandler;
import io.quarkiverse.cxf.transport.VertxDestinationFactory;
import io.quarkiverse.cxf.wsdl.QuarkusWSDLManager;
import io.quarkus.arc.Arc;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.http.runtime.HttpConfiguration;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.cxf.Bus;
import org.apache.cxf.annotations.SchemaValidation;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.cxf.wsdl.WSDLManager;
import org.jboss.logging.Logger;

@Recorder
public class CXFRecorder {
    private static final Logger LOGGER = Logger.getLogger(CXFRecorder.class);
    private static boolean hc5Present = false;

    public RuntimeValue<CXFClientData> cxfClientData(CXFClientData cxfClientData) {
        return new RuntimeValue((Object)cxfClientData);
    }

    public void addCxfServletInfo(RuntimeValue<CXFServletInfos> runtimeInfos, RuntimeValue<Map<String, List<ServletConfig>>> implementorToCfg, String path, Class<?> sei, CxfConfig cxfConfig, String serviceName, String serviceTargetNamepsace, String soapBinding, Class<?> wsImplementor, Boolean isProvider, String relativePathFromCxfEndpointAnnotation, BeanLookupStrategy beanLookupStrategy) {
        CXFServletInfos infos = (CXFServletInfos)runtimeInfos.getValue();
        switch (beanLookupStrategy) {
            case METHOD_WITH_CXFENDPOINT_ANNOTATION: 
            case TYPE_WITH_CXFENDPOINT_ANNOTATION: {
                CxfEndpointConfig cxfEndPointConfig = cxfConfig.endpoints().get(relativePathFromCxfEndpointAnnotation);
                CXFServletInfo info = CXFRecorder.createServletInfo(path, sei, serviceName, serviceTargetNamepsace, soapBinding, wsImplementor, cxfEndPointConfig, relativePathFromCxfEndpointAnnotation, isProvider, beanLookupStrategy.createLookUp(sei, wsImplementor, relativePathFromCxfEndpointAnnotation));
                infos.add(info);
                return;
            }
            case TYPE: {
                if (relativePathFromCxfEndpointAnnotation != null) {
                    CxfEndpointConfig cxfEndPointConfig = cxfConfig.endpoints().get(relativePathFromCxfEndpointAnnotation);
                    CXFServletInfo info = CXFRecorder.createServletInfo(path, sei, serviceName, serviceTargetNamepsace, soapBinding, wsImplementor, cxfEndPointConfig, relativePathFromCxfEndpointAnnotation, isProvider, beanLookupStrategy.createLookUp(sei, wsImplementor, relativePathFromCxfEndpointAnnotation));
                    infos.add(info);
                    return;
                }
                List cfgs = (List)((Map)implementorToCfg.getValue()).get(wsImplementor.getName());
                if (cfgs != null) {
                    for (ServletConfig cfg : cfgs) {
                        CxfEndpointConfig cxfEndPointConfig = cfg.config;
                        String relativePath = cfg.path;
                        CXFServletInfo info = CXFRecorder.createServletInfo(path, sei, serviceName, serviceTargetNamepsace, soapBinding, wsImplementor, cxfEndPointConfig, relativePath, isProvider, beanLookupStrategy.createLookUp(sei, wsImplementor, relativePathFromCxfEndpointAnnotation));
                        infos.add(info);
                    }
                } else {
                    if ((serviceName == null || serviceName.isEmpty()) && (serviceName = sei.getName().toLowerCase()).contains(".")) {
                        serviceName = serviceName.substring(serviceName.lastIndexOf(46) + 1);
                    }
                    String relativePath = "/" + serviceName;
                    CXFServletInfo info = CXFRecorder.createServletInfo(path, sei, serviceName, serviceTargetNamepsace, soapBinding, wsImplementor, null, relativePath, isProvider, beanLookupStrategy.createLookUp(sei, wsImplementor, relativePathFromCxfEndpointAnnotation));
                    infos.add(info);
                }
                return;
            }
        }
        throw new IllegalArgumentException("Unexpected BeanLookupStrategy " + String.valueOf((Object)beanLookupStrategy));
    }

    public RuntimeValue<Map<String, List<ServletConfig>>> implementorToCfgMap(CxfConfig cxfConfig) {
        HashMap implementorToCfg = new HashMap();
        for (Map.Entry<String, CxfEndpointConfig> webServicesByPath : cxfConfig.endpoints().entrySet()) {
            List<ServletConfig> lst;
            CxfEndpointConfig cxfEndPointConfig = webServicesByPath.getValue();
            String relativePath = webServicesByPath.getKey();
            if (!cxfEndPointConfig.implementor().isPresent()) continue;
            String cfgImplementor = cxfEndPointConfig.implementor().get();
            if (implementorToCfg.containsKey(cfgImplementor)) {
                lst = (List)implementorToCfg.get(cfgImplementor);
            } else {
                lst = new ArrayList();
                implementorToCfg.put(cfgImplementor, lst);
            }
            lst.add(new ServletConfig(cxfEndPointConfig, relativePath));
        }
        return new RuntimeValue(implementorToCfg);
    }

    private static CXFServletInfo createServletInfo(String path, Class<?> sei, String serviceName, String serviceTargetNamespace, String soapBinding, Class<?> implementor, CxfEndpointConfig cxfEndPointConfig, String relativePath, Boolean isProvider, MessagePassingQueue.Supplier<Object> beanLookup) {
        CXFServletInfo cfg = new CXFServletInfo(path, relativePath, implementor, sei, cxfEndPointConfig != null ? (String)cxfEndPointConfig.wsdlPath().orElse(null) : null, serviceName, serviceTargetNamespace, cxfEndPointConfig != null ? cxfEndPointConfig.soapBinding().orElse(soapBinding) : soapBinding, isProvider, cxfEndPointConfig != null ? (String)cxfEndPointConfig.publishedEndpointUrl().orElse(null) : null, cxfEndPointConfig != null ? (SchemaValidation.SchemaValidationType)cxfEndPointConfig.schemaValidationEnabledFor().orElse(null) : null, beanLookup);
        if (cxfEndPointConfig != null && cxfEndPointConfig.inInterceptors().isPresent()) {
            cfg.addInInterceptors(cxfEndPointConfig.inInterceptors().get());
        }
        if (cxfEndPointConfig != null && cxfEndPointConfig.outInterceptors().isPresent()) {
            cfg.addOutInterceptors(cxfEndPointConfig.outInterceptors().get());
        }
        if (cxfEndPointConfig != null && cxfEndPointConfig.outFaultInterceptors().isPresent()) {
            cfg.addOutFaultInterceptors(cxfEndPointConfig.outFaultInterceptors().get());
        }
        if (cxfEndPointConfig != null && cxfEndPointConfig.inFaultInterceptors().isPresent()) {
            cfg.addInFaultInterceptors(cxfEndPointConfig.inFaultInterceptors().get());
        }
        if (cxfEndPointConfig != null && cxfEndPointConfig.features().isPresent()) {
            cfg.addFeatures(cxfEndPointConfig.features().get());
        }
        if (cxfEndPointConfig != null && cxfEndPointConfig.handlers().isPresent()) {
            cfg.addHandlers(cxfEndPointConfig.handlers().get());
        }
        LOGGER.tracef("Registering CXF Servlet info %s", (Object)cfg);
        return cfg;
    }

    public RuntimeValue<CXFServletInfos> createInfos(String path, String contextPath) {
        CXFServletInfos infos = new CXFServletInfos(path, contextPath);
        return new RuntimeValue((Object)infos);
    }

    public Handler<RoutingContext> initServer(RuntimeValue<CXFServletInfos> infos, BeanContainer beanContainer, HttpConfiguration httpConfiguration, CxfFixedConfig fixedConfig) {
        LOGGER.trace((Object)"init server");
        return new CxfHandler((CXFServletInfos)infos.getValue(), beanContainer, httpConfiguration, fixedConfig);
    }

    public void resetDestinationRegistry(ShutdownContext context) {
        context.addShutdownTask(VertxDestinationFactory::resetRegistry);
    }

    public void addRuntimeBusCustomizer(RuntimeValue<Consumer<Bus>> customizer) {
        QuarkusBusFactory.addBusCustomizer((Consumer)customizer.getValue());
    }

    public void setHc5Present() {
        hc5Present = true;
    }

    public static boolean isHc5Present() {
        return hc5Present;
    }

    public RuntimeValue<Consumer<Bus>> setBusHTTPConduitFactory(HTTPConduitImpl factory) {
        return new RuntimeValue(bus -> bus.setExtension((Object)factory, HTTPConduitSpec.class));
    }

    public RuntimeValue<Consumer<Bus>> setQuarkusWSDLManager() {
        return new RuntimeValue(bus -> bus.setExtension((Object)QuarkusWSDLManager.newInstance(bus), WSDLManager.class));
    }

    public void workaroundBadForceURLConnectionInit() {
        Field forceURLConnectionConduitField = null;
        for (Field f : HTTPTransportFactory.class.getDeclaredFields()) {
            if (!f.getName().equals("forceURLConnectionConduit")) continue;
            f.setAccessible(true);
            forceURLConnectionConduitField = f;
            break;
        }
        if (forceURLConnectionConduitField != null && Modifier.isStatic(forceURLConnectionConduitField.getModifiers())) {
            try {
                if (forceURLConnectionConduitField.getBoolean(null) && System.getProperty("org.apache.cxf.transport.http.forceURLConnection") == null) {
                    System.setProperty("org.apache.cxf.transport.http.forceURLConnection", "false");
                    forceURLConnectionConduitField.set(null, false);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public RuntimeValue<Consumer<Bus>> busConfigForRetransmitCache(CxfConfig cxfConfig) {
        return new RuntimeValue(bus -> {
            CxfConfig.RetransmitCacheConfig config = cxfConfig.retransmitCache();
            bus.setProperty("bus.io.CachedOutputStream.Threshold", (Object)String.valueOf(config.threshold().asLongValue()));
            config.maxSize().ifPresent(maxSize -> bus.setProperty("bus.io.CachedOutputStream.MaxSize", (Object)String.valueOf(maxSize.asLongValue())));
            config.directory().ifPresent(dir -> bus.setProperty("bus.io.CachedOutputStream.OutputDirectory", dir));
            bus.setProperty("bus.io.CachedOutputStreamCleaner.Delay", (Object)config.gcDelay().toMillis());
            bus.setProperty("bus.io.CachedOutputStreamCleaner.CleanOnShutdown", (Object)config.gcOnShutDown());
        });
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum BeanLookupStrategy {
        TYPE{

            @Override
            public MessagePassingQueue.Supplier<Object> createLookUp(Class<?> sei, Class<?> wsImplementor, String path) {
                return () -> CXFRuntimeUtils.getInstance(wsImplementor);
            }
        }
        ,
        METHOD_WITH_CXFENDPOINT_ANNOTATION{

            @Override
            public MessagePassingQueue.Supplier<Object> createLookUp(Class<?> sei, Class<?> wsImplementor, String path) {
                return BeanLookupStrategy.createLookupInternal(sei, path);
            }
        }
        ,
        TYPE_WITH_CXFENDPOINT_ANNOTATION{

            @Override
            public MessagePassingQueue.Supplier<Object> createLookUp(Class<?> sei, Class<?> wsImplementor, String path) {
                return BeanLookupStrategy.createLookupInternal(wsImplementor, path);
            }
        };


        private static MessagePassingQueue.Supplier<Object> createLookupInternal(Class<?> type, String path) {
            return () -> {
                Object result = Arc.container().instance(type, new Annotation[]{new CXFEndpoint.CXFEndpointLiteral(path)}).get();
                if (result == null) {
                    throw new IllegalStateException("Could get bean of type " + String.valueOf(type) + " qualified by @" + CXFEndpoint.class.getName() + "(\"" + path + "\")");
                }
                return result;
            };
        }

        public abstract MessagePassingQueue.Supplier<Object> createLookUp(Class<?> var1, Class<?> var2, String var3);
    }

    public static class ServletConfig {
        public CxfEndpointConfig config;
        public String path;

        public ServletConfig(CxfEndpointConfig cxfEndPointConfig, String relativePath) {
            this.config = cxfEndPointConfig;
            this.path = relativePath;
        }
    }
}

