/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import io.quarkiverse.cxf.CxfClientConfig;
import io.quarkiverse.cxf.CxfEndpointConfig;
import io.quarkiverse.cxf.LoggingConfig;
import io.quarkus.runtime.annotations.ConfigDocIgnore;
import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.runtime.configuration.DurationConverter;
import io.quarkus.runtime.configuration.MemorySize;
import io.quarkus.runtime.configuration.MemorySizeConverter;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithConverter;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithDefaults;
import io.smallrye.config.WithName;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;

@ConfigMapping(prefix="quarkus.cxf")
@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public interface CxfConfig {
    public Optional<String> decoupledEndpointBase();

    @WithName(value="endpoint")
    @ConfigDocMapKey(value="/endpoint-path")
    @WithDefaults
    public Map<String, CxfEndpointConfig> endpoints();

    public CxfGlobalClientConfig client();

    @WithName(value="client")
    @ConfigDocMapKey(value="client-name")
    @WithDefaults
    public Map<String, CxfClientConfig> clients();

    public InternalConfig internal();

    public LoggingConfig.GlobalLoggingConfig logging();

    public RetransmitCacheConfig retransmitCache();

    default public boolean isClientPresent(String key) {
        return Optional.ofNullable(this.clients()).map(m -> m.containsKey(key)).orElse(false);
    }

    default public CxfClientConfig getClient(String key) {
        return Optional.ofNullable(this.clients()).map(m -> (CxfClientConfig)m.get(key)).orElse(null);
    }

    public static interface RetransmitCacheConfig {
        @WithDefault(value="128K")
        @WithConverter(value=MemorySizeConverter.class)
        public MemorySize threshold();

        @WithConverter(value=MemorySizeConverter.class)
        public Optional<MemorySize> maxSize();

        public Optional<String> directory();

        @WithDefault(value="30m")
        @WithConverter(value=DurationConverter.class)
        public Duration gcDelay();

        @WithDefault(value="true")
        public boolean gcOnShutDown();
    }

    public static interface InternalConfig {
        @ConfigDocIgnore
        public CxfClientConfig client();
    }

    public static interface CxfGlobalClientConfig {
        @WithDefault(value="javax.net.ssl")
        public String tlsConfigurationName();
    }
}

