/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.mutiny;

import io.quarkiverse.cxf.mutiny.FailedResponse;
import io.quarkiverse.cxf.mutiny.SucceededResponse;
import io.quarkus.arc.Arc;
import io.quarkus.runtime.BlockingOperationControl;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.vertx.core.Vertx;
import jakarta.xml.ws.AsyncHandler;
import java.lang.annotation.Annotation;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class CxfMutinyUtils {
    public static <T> Uni<T> toUni(Consumer<AsyncHandler<T>> subscriptionConsumer) {
        return new WsAsyncHandlerUni<T>(subscriptionConsumer);
    }

    public static <T> Uni<SucceededResponse<T>> toResponseUni(Consumer<AsyncHandler<T>> subscriptionConsumer) {
        return new WsAsyncHandlerResponseUni<T>(subscriptionConsumer);
    }

    static class WsAsyncHandlerUni<T>
    extends AbstractUni<T>
    implements Uni<T> {
        private final Consumer<AsyncHandler<T>> subscriptionConsumer;

        public WsAsyncHandlerUni(Consumer<AsyncHandler<T>> subscriptionConsumer) {
            this.subscriptionConsumer = Infrastructure.decorate(subscriptionConsumer);
        }

        public void subscribe(UniSubscriber<? super T> downstream) {
            AtomicBoolean terminated = new AtomicBoolean();
            downstream.onSubscribe(() -> terminated.set(true));
            if (!terminated.get()) {
                if (!BlockingOperationControl.isBlockingAllowed()) {
                    Vertx vertx = (Vertx)Arc.container().instance(Vertx.class, new Annotation[0]).get();
                    vertx.executeBlocking(() -> {
                        if (!terminated.get()) {
                            this.subscribeIntenal(downstream, terminated);
                        }
                        return null;
                    });
                } else {
                    this.subscribeIntenal(downstream, terminated);
                }
            }
        }

        private void subscribeIntenal(UniSubscriber<? super T> downstream, AtomicBoolean terminated) {
            block2: {
                try {
                    this.subscriptionConsumer.accept(response -> {
                        if (!terminated.getAndSet(true)) {
                            try {
                                downstream.onItem(response.get());
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                downstream.onFailure((Throwable)e);
                            }
                            catch (ExecutionException e) {
                                downstream.onFailure(e.getCause());
                            }
                            catch (Exception e) {
                                downstream.onFailure((Throwable)e);
                            }
                        }
                    });
                }
                catch (Exception e) {
                    if (terminated.getAndSet(true)) break block2;
                    downstream.onFailure((Throwable)e);
                }
            }
        }
    }

    static class WsAsyncHandlerResponseUni<T>
    extends AbstractUni<SucceededResponse<T>>
    implements Uni<SucceededResponse<T>> {
        private final Consumer<AsyncHandler<T>> subscriptionConsumer;

        public WsAsyncHandlerResponseUni(Consumer<AsyncHandler<T>> subscriptionConsumer) {
            this.subscriptionConsumer = Infrastructure.decorate(subscriptionConsumer);
        }

        public void subscribe(UniSubscriber<? super SucceededResponse<T>> downstream) {
            AtomicBoolean terminated = new AtomicBoolean();
            downstream.onSubscribe(() -> terminated.set(true));
            if (!terminated.get()) {
                if (!BlockingOperationControl.isBlockingAllowed()) {
                    Vertx vertx = (Vertx)Arc.container().instance(Vertx.class, new Annotation[0]).get();
                    vertx.executeBlocking(() -> {
                        if (!terminated.get()) {
                            this.subscribeIntenal(downstream, terminated);
                        }
                        return null;
                    });
                } else {
                    this.subscribeIntenal(downstream, terminated);
                }
            }
        }

        private void subscribeIntenal(UniSubscriber<? super SucceededResponse<T>> downstream, AtomicBoolean terminated) {
            block2: {
                try {
                    this.subscriptionConsumer.accept(response -> {
                        if (!terminated.getAndSet(true)) {
                            try {
                                downstream.onItem(new SucceededResponse<Object>(response.get(), response.getContext()));
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                downstream.onFailure((Throwable)new FailedResponse(e, response.getContext()));
                            }
                            catch (ExecutionException e) {
                                downstream.onFailure((Throwable)new FailedResponse(e.getCause(), response.getContext()));
                            }
                            catch (Exception e) {
                                downstream.onFailure((Throwable)new FailedResponse(e, response.getContext()));
                            }
                        }
                    });
                }
                catch (Exception e) {
                    if (terminated.getAndSet(true)) break block2;
                    downstream.onFailure((Throwable)e);
                }
            }
        }
    }
}

