/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.vertx.http.client;

import io.quarkiverse.cxf.CxfConfig;
import io.quarkiverse.cxf.vertx.http.client.TempStore;
import io.quarkiverse.cxf.vertx.http.client.VertxHttpClientHTTPConduit;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.AsyncFile;
import io.vertx.core.file.OpenOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.streams.WriteStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jboss.logging.Logger;

class BodyRecorder {
    private static final Logger log = Logger.getLogger(VertxHttpClientHTTPConduit.class);

    BodyRecorder() {
    }

    public static Future<BodyWriter> openWriter(ContextInternal ctx, CxfConfig.RetransmitCacheConfig retransmitCacheConfig) {
        PromiseInternal result = ctx.promise();
        ctx.runOnContext(arg_0 -> BodyRecorder.lambda$openWriter$0(retransmitCacheConfig, (Promise)result, ctx, arg_0));
        return result.future();
    }

    private static /* synthetic */ void lambda$openWriter$0(CxfConfig.RetransmitCacheConfig retransmitCacheConfig, Promise result, ContextInternal ctx, Void v) {
        long maxSize = retransmitCacheConfig.maxSize().isPresent() ? retransmitCacheConfig.maxSize().get().asLongValue() : -1L;
        result.complete((Object)new MemoryBodyWriter(ctx, retransmitCacheConfig.threshold().asLongValue(), maxSize, retransmitCacheConfig.directory(), retransmitCacheConfig.gcDelay().toMillis(), retransmitCacheConfig.gcOnShutDown()));
    }

    static class MemoryBodyWriter
    implements BodyWriter {
        private final ContextInternal ctx;
        private final long threshold;
        private final long maxSize;
        private final Optional<String> tempDir;
        private final long fileDelayMs;
        private final boolean gcOnShutDown;
        private final String threadName;
        private List<Buffer> buffers;
        private long length = 0L;

        public MemoryBodyWriter(ContextInternal ctx, long threshold, long maxSize, Optional<String> tempDir, long fileDelayMs, boolean gcOnShutDown) {
            this.ctx = ctx;
            this.threshold = threshold;
            this.maxSize = maxSize;
            this.tempDir = tempDir;
            this.fileDelayMs = fileDelayMs;
            this.gcOnShutDown = gcOnShutDown;
            boolean asserting = false;
            if (!$assertionsDisabled) {
                asserting = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            this.threadName = asserting ? Thread.currentThread().getName() : null;
        }

        @Override
        public Future<BodyWriter> write(Buffer buffer) {
            assert (Thread.currentThread().getName().equals(this.threadName)) : "Expected " + this.threadName + "; found " + Thread.currentThread().getName();
            List<Buffer> buffs = this.buffers;
            this.length += (long)buffer.length();
            if (this.length > this.threshold) {
                if (this.maxSize >= 0L && this.length > this.maxSize) {
                    return Future.failedFuture((Throwable)new IOException("Request body size " + this.length + " bytes exceeded the max-size limit " + this.maxSize + " bytes"));
                }
                this.buffers = null;
                Future<BodyWriter> diskWriter = DiskBodyWriter.open(this.ctx, this.threshold, this.maxSize, this.tempDir, this.fileDelayMs, this.gcOnShutDown, buffs, this.threadName);
                return diskWriter.compose(bw -> bw.write(buffer));
            }
            if (buffs == null) {
                buffs = this.buffers = new ArrayList<Buffer>();
            }
            buffs.add(buffer);
            return Future.succeededFuture((Object)this);
        }

        @Override
        public Future<StoredBody> close() {
            assert (Thread.currentThread().getName().equals(this.threadName)) : "Expected " + this.threadName + "; found " + Thread.currentThread().getName();
            List<Buffer> buffs = this.buffers;
            this.buffers = null;
            return Future.succeededFuture((Object)new MemoryStoredBody(buffs, this.length, this.threadName));
        }
    }

    static class DiskStoredBody
    implements StoredBody {
        private final ContextInternal ctx;
        private final TempStore.InitializedTempStore.TempPath tempPath;
        private final String threadName;
        private final long length;

        public DiskStoredBody(ContextInternal ctx, TempStore.InitializedTempStore.TempPath tempPath, long length, String threadName) {
            this.ctx = ctx;
            this.tempPath = tempPath;
            this.length = length;
            this.threadName = threadName;
        }

        @Override
        public Future<Void> discard() {
            assert (Thread.currentThread().getName().equals(this.threadName)) : "Expected " + this.threadName + "; found " + Thread.currentThread().getName();
            return this.tempPath.discard();
        }

        @Override
        public Future<Void> pipeTo(HttpClientRequest req) {
            assert (Thread.currentThread().getName().equals(this.threadName)) : "Expected " + this.threadName + "; found " + Thread.currentThread().getName();
            return this.ctx.owner().fileSystem().open(this.tempPath.getPath().toString(), new OpenOptions().setRead(true)).compose(f -> f.pipeTo((WriteStream)req));
        }

        @Override
        public long length() {
            assert (Thread.currentThread().getName().equals(this.threadName)) : "Expected " + this.threadName + "; found " + Thread.currentThread().getName();
            return this.length;
        }
    }

    static class DiskBodyWriter
    implements BodyWriter {
        private final ContextInternal ctx;
        private final long maxSize;
        private final AsyncFile tempFile;
        private final TempStore.InitializedTempStore.TempPath tempPath;
        private final String threadName;
        private long length = 0L;

        private DiskBodyWriter(ContextInternal ctx, long maxSize, TempStore.InitializedTempStore.TempPath tempPath, AsyncFile tempFile, String threadName) {
            this.ctx = ctx;
            this.maxSize = maxSize;
            this.tempPath = tempPath;
            this.tempFile = tempFile;
            this.threadName = threadName;
        }

        public static Future<BodyWriter> open(ContextInternal ctx, long threshold, long maxSize, Optional<String> tempDir, long fileDelayMs, boolean gcOnShutDown, List<Buffer> buffs, String threadName) {
            Future<TempStore.InitializedTempStore> tempStore = TempStore.fromContext((Context)ctx, tempDir, fileDelayMs, gcOnShutDown);
            Future result = tempStore.compose(ts -> ts.newTempPath()).compose(tempPath -> {
                log.debugf("Offloading request body exceeding %s bytes to disk: %s", threshold, (Object)tempPath.getPath());
                Future fileFuture = ctx.owner().fileSystem().open(tempPath.getPath().toString(), new OpenOptions().setWrite(true).setCreate(true));
                return fileFuture.compose(file -> Future.succeededFuture((Object)new DiskBodyWriter(ctx, maxSize, (TempStore.InitializedTempStore.TempPath)tempPath, (AsyncFile)file, threadName)));
            });
            if (buffs != null) {
                for (Buffer b : buffs) {
                    result = result.compose(bw -> bw.write(b));
                }
            }
            return result;
        }

        @Override
        public Future<BodyWriter> write(Buffer buffer) {
            assert (Thread.currentThread().getName().equals(this.threadName)) : "Expected " + this.threadName + "; found " + Thread.currentThread().getName();
            this.length += (long)buffer.length();
            if (this.maxSize >= 0L && this.length > this.maxSize) {
                return Future.failedFuture((Throwable)new IOException("Request body size " + this.length + " bytes exceeded the max-size limit " + this.maxSize + " bytes"));
            }
            return this.tempFile.write((Object)buffer).compose(v -> Future.succeededFuture((Object)this));
        }

        @Override
        public Future<StoredBody> close() {
            assert (Thread.currentThread().getName().equals(this.threadName)) : "Expected " + this.threadName + "; found " + Thread.currentThread().getName();
            return this.tempFile.close().compose(v -> Future.succeededFuture((Object)new DiskStoredBody(this.ctx, this.tempPath, this.length, this.threadName)));
        }
    }

    static class MemoryStoredBody
    implements StoredBody {
        private List<Buffer> buffers;
        private final long length;
        private final String threadName;

        MemoryStoredBody(List<Buffer> buffers, long length, String threadName) {
            this.buffers = buffers;
            this.length = length;
            this.threadName = threadName;
        }

        @Override
        public long length() {
            assert (Thread.currentThread().getName().equals(this.threadName)) : "Expected " + this.threadName + "; found " + Thread.currentThread().getName();
            return this.length;
        }

        @Override
        public Future<Void> pipeTo(HttpClientRequest req) {
            assert (Thread.currentThread().getName().equals(this.threadName)) : "Expected " + this.threadName + "; found " + Thread.currentThread().getName();
            List<Buffer> buffs = this.buffers;
            if (buffs != null) {
                int last = buffs.size() - 1;
                if (last == 0) {
                    return req.end(buffs.get(0).slice());
                }
                if (last == -1) {
                    return req.end();
                }
                Future result = Future.succeededFuture();
                int i = 0;
                while (i < last) {
                    int fi = i++;
                    result = result.compose(v -> req.write((Object)((Buffer)buffs.get(fi)).slice()));
                }
                return result.compose(v -> req.end(((Buffer)buffs.get(last)).slice()));
            }
            return req.end();
        }

        @Override
        public Future<Void> discard() {
            assert (Thread.currentThread().getName().equals(this.threadName)) : "Expected " + this.threadName + "; found " + Thread.currentThread().getName();
            this.buffers = null;
            return Future.succeededFuture();
        }
    }

    static interface StoredBody {
        public long length();

        public Future<Void> pipeTo(HttpClientRequest var1);

        public Future<Void> discard();
    }

    static interface BodyWriter {
        public Future<BodyWriter> write(Buffer var1);

        public Future<StoredBody> close();
    }
}

