/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import io.quarkiverse.cxf.CXFClientData;
import io.quarkiverse.cxf.CXFClientInfo;
import io.quarkiverse.cxf.CxfClientProducer;
import io.quarkiverse.cxf.CxfFixedConfig;
import io.quarkiverse.cxf.annotation.CXFClient;
import io.quarkus.arc.Arc;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.util.Optional;

public class CxfClientInfoProducer
extends CxfClientProducer {
    @Produces
    @CXFClient
    public CXFClientInfo loadCxfClientInfo(InjectionPoint ip) {
        CXFClient cxfClient = (CXFClient)ip.getAnnotated().getAnnotation(CXFClient.class);
        if (cxfClient == null) {
            throw new IllegalStateException(CXFClientInfo.class.getName() + " can only be injected with @" + CXFClient.class.getName() + " annotation with value specified, e.g. @" + CXFClient.class.getSimpleName() + "(\"myClient\"), where \"myClient\" is the key used for configuring the given client in application.properties");
        }
        String key = cxfClient.value();
        if (key == null) {
            throw new IllegalStateException(CXFClientInfo.class.getName() + " can only be injected with @" + CXFClient.class.getName() + " annotation with value specified, e.g. @" + CXFClient.class.getSimpleName() + "(\"myClient\"), where \"myClient\" is the key used for configuring the given client in application.properties");
        }
        CxfFixedConfig.ClientFixedConfig fixedClientConfig = this.fixedConfig.clients().get(key);
        if (fixedClientConfig == null) {
            throw new IllegalStateException("Could not find quarkus.cxf.client." + key + ".service-interface in application configuration for @" + CXFClient.class.getSimpleName() + "(\"" + key + "\")");
        }
        Optional<String> serviceInterface = fixedClientConfig.serviceInterface();
        if (serviceInterface.isEmpty()) {
            throw new IllegalStateException("Could not find quarkus.cxf.client." + key + ".service-interface in application configuration for @" + CXFClient.class.getSimpleName() + "(\"" + key + "\")");
        }
        CXFClientData meta = (CXFClientData)Arc.container().instance(serviceInterface.get()).get();
        return CxfClientInfoProducer.selectorCXFClientInfo(this.config, this.fixedConfig, ip, meta, this.vertx);
    }
}

