/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf.vertx.http.client;

import io.quarkiverse.cxf.CXFClientInfo;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.tls.CertificateUpdatedEvent;
import io.quarkus.tls.TlsConfiguration;
import io.quarkus.tls.runtime.config.TlsConfigUtils;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpVersion;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;

@ApplicationScoped
public class HttpClientPool {
    private final Map<String, ClientEntry> clients = new ConcurrentHashMap<String, ClientEntry>();
    private final Vertx vertx;

    HttpClientPool() {
        this(null);
    }

    @Inject
    public HttpClientPool(Vertx vertx) {
        this.vertx = vertx;
    }

    public HttpClient getClient(CXFClientInfo clientInfo, HttpVersion version, TlsConfiguration tlsConfiguration) {
        String key = clientInfo.getConfigKey();
        Objects.requireNonNull(key, "CXFClientInfo.configKey cannot be null");
        return this.clients.computeIfAbsent((String)key, (Function<String, ClientEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getClient$0(io.vertx.core.http.HttpVersion io.quarkiverse.cxf.CXFClientInfo io.quarkus.tls.TlsConfiguration java.lang.String ), (Ljava/lang/String;)Lio/quarkiverse/cxf/vertx/http/client/HttpClientPool$ClientEntry;)((HttpClientPool)this, (HttpVersion)version, (CXFClientInfo)clientInfo, (TlsConfiguration)tlsConfiguration)).httpClient;
    }

    public void onCertificateUpdate(@Observes CertificateUpdatedEvent event) {
        String tlsConfigName = event.name();
        if (tlsConfigName != null) {
            Iterator<Map.Entry<String, ClientEntry>> it = this.clients.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, ClientEntry> en = it.next();
                if (!tlsConfigName.equals(en.getValue().tlsConfigurationName)) continue;
                HttpClient cl = en.getValue().httpClient();
                it.remove();
                cl.close(r -> {});
            }
        }
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    private /* synthetic */ ClientEntry lambda$getClient$0(HttpVersion version, CXFClientInfo clientInfo, TlsConfiguration tlsConfiguration, String v) {
        HttpClientOptions opts = new HttpClientOptions().setProtocolVersion(version);
        clientInfo.getVertxConfig().configure(opts);
        HttpClientPoolRecorder.configure(clientInfo, opts);
        if (tlsConfiguration != null) {
            TlsConfigUtils.configure((HttpClientOptions)opts, (TlsConfiguration)tlsConfiguration);
            return new ClientEntry(this.vertx.createHttpClient(opts), tlsConfiguration.getName());
        }
        return new ClientEntry(this.vertx.createHttpClient(opts), null);
    }

    record ClientEntry(HttpClient httpClient, String tlsConfigurationName) {
    }

    @Recorder
    public static class HttpClientPoolRecorder {
        private static final List<BiConsumer<CXFClientInfo, HttpClientOptions>> customizers = new ArrayList<BiConsumer<CXFClientInfo, HttpClientOptions>>();

        public void addHttpClientCustomizer(RuntimeValue<BiConsumer<CXFClientInfo, HttpClientOptions>> customizer) {
            customizers.add((BiConsumer)customizer.getValue());
        }

        public static void configure(CXFClientInfo clientInfo, HttpClientOptions opts) {
            for (BiConsumer<CXFClientInfo, HttpClientOptions> consumer : customizers) {
                consumer.accept(clientInfo, opts);
            }
        }
    }
}

