/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import java.io.Serializable;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.spi.Converter;

public abstract class AbstractEnumConverter<E extends Enum<E>>
implements Converter<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<E> enumType;
    private final Function<E, String> enumValueMapper;

    public AbstractEnumConverter(Class<E> enumType) {
        this.enumType = enumType;
        this.enumValueMapper = Enum::name;
    }

    public AbstractEnumConverter(Class<E> enumType, Function<E, String> enumValueMapper) {
        this.enumType = enumType;
        this.enumValueMapper = enumValueMapper;
    }

    public E convert(String value) {
        for (Enum c : (Enum[])this.enumType.getEnumConstants()) {
            if (!this.enumValueMapper.apply(c).equalsIgnoreCase(value)) continue;
            return (E)c;
        }
        throw new IllegalArgumentException("Cannot map '" + value + "' to any " + this.enumType.getName() + " value. Expected: " + Stream.of((Enum[])this.enumType.getEnumConstants()).map(this.enumValueMapper).collect(Collectors.joining(", ")));
    }
}

