/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.cxf;

import io.quarkiverse.cxf.CXFClientData;
import io.quarkiverse.cxf.CXFClientInfo;
import io.quarkiverse.cxf.CXFRecorder;
import io.quarkiverse.cxf.CXFRuntimeUtils;
import io.quarkiverse.cxf.CxfConfig;
import io.quarkiverse.cxf.CxfFixedConfig;
import io.quarkiverse.cxf.QuarkusClientFactoryBean;
import io.quarkiverse.cxf.QuarkusHTTPConduitFactory;
import io.quarkiverse.cxf.QuarkusJaxWsProxyFactoryBean;
import io.quarkiverse.cxf.annotation.CXFClient;
import io.quarkiverse.cxf.logging.LoggingFactoryCustomizer;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import jakarta.xml.ws.BindingProvider;
import java.io.Closeable;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.annotations.SchemaValidation;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.http.HTTPConduitFactory;
import org.jboss.logging.Logger;

public abstract class CxfClientProducer {
    private static final Logger LOGGER = Logger.getLogger(CxfClientProducer.class);
    public static final String RUNTIME_INITIALIZED_PROXY_MARKER_INTERFACE_PACKAGE = "io.quarkiverse.cxf.runtime.proxy";
    public static final String RUNTIME_INITIALIZED_PROXY_MARKER_INTERFACE_NAME = "io.quarkiverse.cxf.runtime.proxy.RuntimeInitializedProxyMarker";
    @Inject
    CxfConfig config;
    @Inject
    CxfFixedConfig fixedConfig;
    @Inject
    @Any
    Instance<ClientFactoryCustomizer> customizers;
    private LoggingFactoryCustomizer loggingFactoryCustomizer;

    @PostConstruct
    void init() {
        this.loggingFactoryCustomizer = new LoggingFactoryCustomizer(this.config);
    }

    public Object loadCxfClient(InjectionPoint ip, CXFClientData meta) {
        return this.produceCxfClient(CxfClientProducer.selectorCXFClientInfo(this.config, this.fixedConfig, ip, meta));
    }

    public void closeCxfClient(Object client) {
        try {
            ((Closeable)client).close();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not close CXF client " + client.getClass().getName(), e);
        }
    }

    public CXFClientInfo loadCxfClientInfo(InjectionPoint ip, CXFClientData meta) {
        return CxfClientProducer.selectorCXFClientInfo(this.config, this.fixedConfig, ip, meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object produceCxfClient(CXFClientInfo cxfClientInfo) {
        Object result;
        AuthorizationPolicy authorizationPolicy;
        Class[] interfaces;
        Class<?> seiClass;
        String sei = cxfClientInfo.getSei();
        try {
            seiClass = Class.forName(sei, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            LOGGER.errorf("WebService interface (client) class %s not found", (Object)sei);
            return null;
        }
        try {
            Class[] classArray;
            if (cxfClientInfo.isProxyClassRuntimeInitialized()) {
                Class[] classArray2 = new Class[4];
                classArray2[0] = BindingProvider.class;
                classArray2[1] = Closeable.class;
                classArray2[2] = Client.class;
                classArray = classArray2;
                classArray2[3] = Class.forName(RUNTIME_INITIALIZED_PROXY_MARKER_INTERFACE_NAME, true, Thread.currentThread().getContextClassLoader());
            } else {
                Class[] classArray3 = new Class[3];
                classArray3[0] = BindingProvider.class;
                classArray3[1] = Closeable.class;
                classArray = classArray3;
                classArray3[2] = Client.class;
            }
            interfaces = classArray;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load io.quarkiverse.cxf.runtime.proxy.RuntimeInitializedProxyMarker", e);
        }
        QuarkusClientFactoryBean quarkusClientFactoryBean = new QuarkusClientFactoryBean(seiClass);
        QuarkusJaxWsProxyFactoryBean factory = new QuarkusJaxWsProxyFactoryBean(quarkusClientFactoryBean, interfaces);
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        factory.setProperties(props);
        props.put(CXFClientInfo.class.getName(), cxfClientInfo);
        LOGGER.debugf("using servicename {%s}%s", (Object)cxfClientInfo.getWsNamespace(), (Object)cxfClientInfo.getWsName());
        factory.setServiceName(new QName(cxfClientInfo.getWsNamespace(), cxfClientInfo.getWsName()));
        if (cxfClientInfo.getEpName() != null) {
            factory.setEndpointName(new QName(cxfClientInfo.getEpNamespace(), cxfClientInfo.getEpName()));
        }
        factory.setAddress(cxfClientInfo.getEndpointAddress());
        if (cxfClientInfo.getSoapBinding() != null) {
            factory.setBindingId(cxfClientInfo.getSoapBinding());
        }
        if (cxfClientInfo.getWsdlUrl() != null && !cxfClientInfo.getWsdlUrl().isEmpty()) {
            factory.setWsdlURL(cxfClientInfo.getWsdlUrl());
        }
        if ((authorizationPolicy = CxfClientProducer.authorizationPolicy(cxfClientInfo)) != null && !cxfClientInfo.isSecureWsdlAccess()) {
            props.put(AuthorizationPolicy.class.getName(), authorizationPolicy);
        }
        String clientString = "client" + (String)(cxfClientInfo.getConfigKey() != null ? " " + cxfClientInfo.getConfigKey() : "");
        CXFRuntimeUtils.addBeans(cxfClientInfo.getFeatures(), "feature", clientString, sei, factory.getFeatures());
        CXFRuntimeUtils.addBeans(cxfClientInfo.getHandlers(), "handler", clientString, sei, factory.getHandlers());
        CXFRuntimeUtils.addBeans(cxfClientInfo.getInInterceptors(), "inInterceptor", clientString, sei, factory.getInInterceptors());
        CXFRuntimeUtils.addBeans(cxfClientInfo.getOutInterceptors(), "outInterceptor", clientString, sei, factory.getOutInterceptors());
        CXFRuntimeUtils.addBeans(cxfClientInfo.getOutFaultInterceptors(), "outFaultInterceptor", clientString, sei, factory.getOutFaultInterceptors());
        CXFRuntimeUtils.addBeans(cxfClientInfo.getInFaultInterceptors(), "inFaultInterceptor", clientString, sei, factory.getInFaultInterceptors());
        String value = cxfClientInfo.getDecoupledEndpointBase();
        if (value != null) {
            props.put("org.apache.cxf.ws.addressing.decoupled.endpoint.base", value);
        }
        this.loggingFactoryCustomizer.customize(cxfClientInfo, factory);
        this.customizers.forEach(customizer -> customizer.customize(cxfClientInfo, factory));
        Bus bus = BusFactory.getDefaultBus();
        HTTPConduitFactory origConduitFactory = (HTTPConduitFactory)bus.getExtension(HTTPConduitFactory.class);
        QuarkusHTTPConduitFactory conduitFactory = new QuarkusHTTPConduitFactory(this.fixedConfig, cxfClientInfo, CXFRecorder.isHc5Present(), origConduitFactory, authorizationPolicy);
        props.put(HTTPConduitFactory.class.getName(), conduitFactory);
        try {
            bus.setExtension((Object)conduitFactory, HTTPConduitFactory.class);
            LOGGER.debug((Object)("cxf client loaded for " + sei));
            result = factory.create();
        }
        finally {
            bus.setExtension((Object)origConduitFactory, HTTPConduitFactory.class);
        }
        Client client = ClientProxy.getClient((Object)result);
        SchemaValidation.SchemaValidationType value2 = cxfClientInfo.getSchemaValidationEnabledFor();
        if (value2 != null) {
            client.getEndpoint().getEndpointInfo().setProperty("schema-validation-type", (Object)value2);
        }
        return result;
    }

    private static AuthorizationPolicy authorizationPolicy(CXFClientInfo cxfClientInfo) {
        String username = cxfClientInfo.getUsername();
        if (username != null) {
            String password = cxfClientInfo.getPassword();
            AuthorizationPolicy authPolicy = new AuthorizationPolicy();
            authPolicy.setUserName(username);
            if (password != null) {
                authPolicy.setPassword(password);
            }
            return authPolicy;
        }
        return null;
    }

    protected static CXFClientInfo selectorCXFClientInfo(CxfConfig config, CxfFixedConfig fixedConfig, InjectionPoint ip, CXFClientData meta) {
        String configKey;
        if (ip.getAnnotated().isAnnotationPresent(CXFClient.class)) {
            CXFClient anno = (CXFClient)ip.getAnnotated().getAnnotation(CXFClient.class);
            configKey = anno.value();
        } else {
            configKey = "";
        }
        return CxfClientProducer.selectorCXFClientInfo(config, fixedConfig, meta, configKey, () -> new IllegalStateException("quarkus.cxf.client.\"" + configKey + "\" is referenced in " + ip.getMember() + " but no such build time configuration entry exists"));
    }

    public static CXFClientInfo selectorCXFClientInfo(CxfConfig config, CxfFixedConfig fixedConfig, CXFClientData meta, String configKey, Supplier<IllegalStateException> exceptionSupplier) {
        if (configKey != null && !configKey.isEmpty()) {
            if (config.isClientPresent(configKey)) {
                return new CXFClientInfo(meta, config, config.getClient(configKey), configKey);
            }
            throw exceptionSupplier.get();
        }
        List keylist = fixedConfig.clients().entrySet().stream().filter(kv -> kv.getValue() != null).filter(kv -> ((CxfFixedConfig.ClientFixedConfig)kv.getValue()).serviceInterface().isPresent()).filter(kv -> ((CxfFixedConfig.ClientFixedConfig)kv.getValue()).serviceInterface().get().equals(meta.getSei())).filter(kv -> !((CxfFixedConfig.ClientFixedConfig)kv.getValue()).alternative()).map(Map.Entry::getKey).collect(Collectors.toList());
        switch (keylist.size()) {
            case 0: {
                LOGGER.warnf("No configuration found for quarkus.cxf.*.service-interface = %s and alternative = false. Using the values from the service instead: %s.", (Object)meta.getSei(), (Object)meta);
                return new CXFClientInfo(meta, config, config.internal().client(), null);
            }
            case 1: {
                return new CXFClientInfo(meta, config, config.clients().get(keylist.get(0)), (String)keylist.get(0));
            }
        }
        throw new IllegalStateException("quarkus.cxf.*.service-interface = " + meta.getSei() + " with alternative = false expected once, but found " + keylist.size() + " times in " + keylist.stream().map(k -> "quarkus.cxf.\"" + k + "\".service-interface").collect(Collectors.joining(", ")));
    }

    public static interface ClientFactoryCustomizer {
        public void customize(CXFClientInfo var1, JaxWsProxyFactoryBean var2);
    }
}

