/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.dapr.core;

import io.quarkiverse.dapr.core.DaprSubscriptionBuilder;
import io.quarkiverse.dapr.core.DaprTopicKey;
import io.quarkiverse.dapr.core.DaprTopicSubscription;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class DaprRuntime {
    private static volatile DaprRuntime instance;
    private final Map<DaprTopicKey, DaprSubscriptionBuilder> subscriptionBuilders = new HashMap<DaprTopicKey, DaprSubscriptionBuilder>();

    private DaprRuntime() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DaprRuntime getInstance() {
        if (instance != null) return instance;
        Class<DaprRuntime> clazz = DaprRuntime.class;
        synchronized (DaprRuntime.class) {
            if (instance != null) return instance;
            instance = new DaprRuntime();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized void addSubscribedTopic(String pubsubName, String topicName, String match, int priority, String route, Map<String, String> metadata) {
        DaprTopicKey topicKey = new DaprTopicKey(pubsubName, topicName);
        DaprSubscriptionBuilder builder = this.subscriptionBuilders.get(topicKey);
        if (builder == null) {
            builder = new DaprSubscriptionBuilder(pubsubName, topicName);
            this.subscriptionBuilders.put(topicKey, builder);
        }
        if (match.length() > 0) {
            builder.addRule(route, match, priority);
        } else if (Objects.isNull(builder.getDefaultPath())) {
            builder.setDefaultPath(route);
        }
        if (metadata != null && !metadata.isEmpty()) {
            builder.setMetadata(metadata);
        }
    }

    public synchronized DaprTopicSubscription[] listSubscribedTopics() {
        List<DaprTopicSubscription> values = this.subscriptionBuilders.values().stream().map(b -> b.build()).collect(Collectors.toList());
        return values.toArray(new DaprTopicSubscription[0]);
    }
}

