/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.dapr.core;

import io.dapr.client.DaprClient;
import io.dapr.client.domain.DeleteStateRequest;
import io.dapr.client.domain.ExecuteStateTransactionRequest;
import io.dapr.client.domain.GetBulkSecretRequest;
import io.dapr.client.domain.GetBulkStateRequest;
import io.dapr.client.domain.GetSecretRequest;
import io.dapr.client.domain.GetStateRequest;
import io.dapr.client.domain.HttpExtension;
import io.dapr.client.domain.InvokeBindingRequest;
import io.dapr.client.domain.InvokeMethodRequest;
import io.dapr.client.domain.PublishEventRequest;
import io.dapr.client.domain.SaveStateRequest;
import io.dapr.client.domain.State;
import io.dapr.client.domain.StateOptions;
import io.dapr.client.domain.TransactionalStateOperation;
import io.dapr.utils.TypeRef;
import io.quarkiverse.dapr.config.DaprConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SyncDaprClient
implements AutoCloseable {
    private final DaprClient daprClient;
    private final DaprConfig config;

    public SyncDaprClient(DaprClient daprClient, DaprConfig config) {
        this.daprClient = daprClient;
        this.config = config;
    }

    public void waitForSidecar(int timeoutInMilliseconds) {
        this.daprClient.waitForSidecar(timeoutInMilliseconds).block();
    }

    public void publishEvent(String topicName, Object data) {
        String pubSubName = this.getPubsubName(null);
        Map<String, String> end = this.getPubSubPublishMetadata(pubSubName, null);
        this.daprClient.publishEvent(pubSubName, topicName, data, end).block();
    }

    public void publishEvent(String topicName, Object data, Map<String, String> metadata) {
        String pubSubName = this.getPubsubName(null);
        Map<String, String> end = this.getPubSubPublishMetadata(pubSubName, metadata);
        this.daprClient.publishEvent(pubSubName, topicName, data, end).block();
    }

    public void publishEvent(String pubsubName, String topicName, Object data) {
        pubsubName = this.getPubsubName(pubsubName);
        Map<String, String> end = this.getPubSubPublishMetadata(pubsubName, null);
        this.daprClient.publishEvent(pubsubName, topicName, data, end).block();
    }

    public void publishEvent(String pubsubName, String topicName, Object data, Map<String, String> metadata) {
        pubsubName = this.getPubsubName(pubsubName);
        Map<String, String> end = this.getPubSubPublishMetadata(pubsubName, metadata);
        this.daprClient.publishEvent(pubsubName, topicName, data, end).block();
    }

    void publishEvent(PublishEventRequest request) {
        String pubsubName = this.getPubsubName(request.getPubsubName());
        Map<String, String> end = this.getPubSubPublishMetadata(pubsubName, request.getMetadata());
        request.setMetadata(end);
        this.daprClient.publishEvent(request).block();
    }

    public <T> T invokeMethod(String appId, String methodName, Object data, HttpExtension httpExtension, Map<String, String> metadata, TypeRef<T> type) {
        return (T)this.daprClient.invokeMethod(appId, methodName, data, httpExtension, metadata, type).block();
    }

    public <T> T invokeMethod(String appId, String methodName, Object request, HttpExtension httpExtension, Map<String, String> metadata, Class<T> clazz) {
        return (T)this.daprClient.invokeMethod(appId, methodName, request, httpExtension, metadata, clazz).block();
    }

    public <T> T invokeMethod(String appId, String methodName, Object request, HttpExtension httpExtension, TypeRef<T> type) {
        return (T)this.daprClient.invokeMethod(appId, methodName, request, httpExtension, type).block();
    }

    public <T> T invokeMethod(String appId, String methodName, Object request, HttpExtension httpExtension, Class<T> clazz) {
        return (T)this.daprClient.invokeMethod(appId, methodName, request, httpExtension, clazz).block();
    }

    public <T> T invokeMethod(String appId, String methodName, HttpExtension httpExtension, Map<String, String> metadata, TypeRef<T> type) {
        return (T)this.daprClient.invokeMethod(appId, methodName, httpExtension, metadata, type).block();
    }

    public <T> T invokeMethod(String appId, String methodName, HttpExtension httpExtension, Map<String, String> metadata, Class<T> clazz) {
        return (T)this.daprClient.invokeMethod(appId, methodName, httpExtension, metadata, clazz).block();
    }

    public void invokeMethod(String appId, String methodName, Object request, HttpExtension httpExtension, Map<String, String> metadata) {
        this.daprClient.invokeMethod(appId, methodName, request, httpExtension, metadata).block();
    }

    public void invokeMethod(String appId, String methodName, Object request, HttpExtension httpExtension) {
        this.daprClient.invokeMethod(appId, methodName, request, httpExtension).block();
    }

    public void invokeMethod(String appId, String methodName, HttpExtension httpExtension, Map<String, String> metadata) {
        this.daprClient.invokeMethod(appId, methodName, httpExtension, metadata).block();
    }

    public byte[] invokeMethod(String appId, String methodName, byte[] request, HttpExtension httpExtension, Map<String, String> metadata) {
        return (byte[])this.daprClient.invokeMethod(appId, methodName, request, httpExtension, metadata).block();
    }

    public <T> T invokeMethod(InvokeMethodRequest invokeMethodRequest, TypeRef<T> type) {
        return (T)this.daprClient.invokeMethod(invokeMethodRequest, type).block();
    }

    public void invokeBinding(String bindingName, String operation, Object data) {
        this.daprClient.invokeBinding(bindingName, operation, data).block();
    }

    public byte[] invokeBinding(String bindingName, String operation, byte[] data, Map<String, String> metadata) {
        return (byte[])this.daprClient.invokeBinding(bindingName, operation, data, metadata).block();
    }

    public <T> T invokeBinding(String bindingName, String operation, Object data, TypeRef<T> type) {
        return (T)this.daprClient.invokeBinding(bindingName, operation, data, type).block();
    }

    public <T> T invokeBinding(String bindingName, String operation, Object data, Class<T> clazz) {
        return (T)this.daprClient.invokeBinding(bindingName, operation, data, clazz).block();
    }

    public <T> T invokeBinding(String bindingName, String operation, Object data, Map<String, String> metadata, TypeRef<T> type) {
        return (T)this.daprClient.invokeBinding(bindingName, operation, data, metadata, type).block();
    }

    public <T> T invokeBinding(String bindingName, String operation, Object data, Map<String, String> metadata, Class<T> clazz) {
        return (T)this.daprClient.invokeBinding(bindingName, operation, data, metadata, clazz).block();
    }

    public <T> T invokeBinding(InvokeBindingRequest request, TypeRef<T> type) {
        return (T)this.daprClient.invokeBinding(request, type).block();
    }

    public <T> State<T> getState(String storeName, State<T> state, TypeRef<T> type) {
        return (State)this.daprClient.getState(storeName, state, type).block();
    }

    public <T> State<T> getState(String storeName, State<T> state, Class<T> clazz) {
        return (State)this.daprClient.getState(storeName, state, clazz).block();
    }

    public <T> State<T> getState(String storeName, String key, TypeRef<T> type) {
        return (State)this.daprClient.getState(storeName, key, type).block();
    }

    public <T> State<T> getState(String storeName, String key, Class<T> clazz) {
        return (State)this.daprClient.getState(storeName, key, clazz).block();
    }

    public <T> State<T> getState(String storeName, String key, StateOptions options, TypeRef<T> type) {
        return (State)this.daprClient.getState(storeName, key, options, type).block();
    }

    public <T> State<T> getState(String storeName, String key, StateOptions options, Class<T> clazz) {
        return (State)this.daprClient.getState(storeName, key, options, clazz).block();
    }

    public <T> State<T> getState(GetStateRequest request, TypeRef<T> type) {
        return (State)this.daprClient.getState(request, type).block();
    }

    public <T> List<State<T>> getBulkState(String storeName, List<String> keys, TypeRef<T> type) {
        return (List)this.daprClient.getBulkState(storeName, keys, type).block();
    }

    public <T> List<State<T>> getBulkState(String storeName, List<String> keys, Class<T> clazz) {
        return (List)this.daprClient.getBulkState(storeName, keys, clazz).block();
    }

    public <T> List<State<T>> getBulkState(GetBulkStateRequest request, TypeRef<T> type) {
        return (List)this.daprClient.getBulkState(request, type).block();
    }

    public void executeStateTransaction(String storeName, List<TransactionalStateOperation<?>> operations) {
        this.daprClient.executeStateTransaction(storeName, operations).block();
    }

    public void executeStateTransaction(ExecuteStateTransactionRequest request) {
        this.daprClient.executeStateTransaction(request).block();
    }

    public void saveBulkState(String storeName, List<State<?>> states) {
        this.daprClient.saveBulkState(storeName, states).block();
    }

    public void saveBulkState(SaveStateRequest request) {
        this.daprClient.saveBulkState(request).block();
    }

    public void saveState(String storeName, String key, Object value) {
        this.daprClient.saveState(storeName, key, value).block();
    }

    public void saveState(String storeName, String key, String etag, Object value, StateOptions options) {
        this.daprClient.saveState(storeName, key, etag, value, options).block();
    }

    public void deleteState(String storeName, String key) {
        this.daprClient.deleteState(storeName, key).block();
    }

    public void deleteState(String storeName, String key, String etag, StateOptions options) {
        this.daprClient.deleteState(storeName, key, etag, options).block();
    }

    public void deleteState(DeleteStateRequest request) {
        this.daprClient.deleteState(request).block();
    }

    public Map<String, String> getSecret(String storeName, String secretName, Map<String, String> metadata) {
        return (Map)this.daprClient.getSecret(storeName, secretName, metadata).block();
    }

    public Map<String, String> getSecret(String storeName, String secretName) {
        return (Map)this.daprClient.getSecret(storeName, secretName).block();
    }

    public Map<String, String> getSecret(GetSecretRequest request) {
        return (Map)this.daprClient.getSecret(request).block();
    }

    public Map<String, Map<String, String>> getBulkSecret(String storeName) {
        return (Map)this.daprClient.getBulkSecret(storeName).block();
    }

    public Map<String, Map<String, String>> getBulkSecret(String storeName, Map<String, String> metadata) {
        return (Map)this.daprClient.getBulkSecret(storeName, metadata).block();
    }

    public Map<String, Map<String, String>> getBulkSecret(GetBulkSecretRequest request) {
        return (Map)this.daprClient.getBulkSecret(request).block();
    }

    public void shutdown() {
        this.daprClient.shutdown().block();
    }

    @Override
    public void close() throws Exception {
        this.daprClient.close();
    }

    private String getPubsubName(String pubsubName) {
        return Optional.ofNullable(pubsubName).orElse(this.config.defaultPubSub());
    }

    public Map<String, String> getPubSubPublishMetadata(String pubsubName, Map<String, String> metadata) {
        Map pubsubDefaultPublishMetadata = Optional.ofNullable(this.config.pubSub().get(pubsubName)).map(a -> new HashMap<String, String>(a.publishMetadata())).orElse(new HashMap(16));
        if (Objects.nonNull(metadata)) {
            pubsubDefaultPublishMetadata.putAll(metadata);
        }
        return pubsubDefaultPublishMetadata;
    }
}

