/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.dapr.resteasy;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dapr.client.domain.CloudEvent;
import io.quarkiverse.dapr.config.DaprConfig;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.ws.rs.NotSupportedException;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

@Provider
@Produces(value={"application/cloudevents+json"})
public class CloudEventReader
implements MessageBodyReader<CloudEvent> {
    private static ObjectMapper OBJECT_MAPPER;
    private static DaprConfig DAPR_CONFIG;
    private static final Map<Type, JavaType> TYPE_CACHE;

    public CloudEventReader() {
        if (OBJECT_MAPPER == null) {
            OBJECT_MAPPER = (ObjectMapper)CDI.current().select(ObjectMapper.class, new Annotation[0]).get();
        }
        if (DAPR_CONFIG == null) {
            DAPR_CONFIG = (DaprConfig)CDI.current().select(DaprConfig.class, new Annotation[0]).get();
        }
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type == CloudEvent.class;
    }

    public CloudEvent readFrom(Class<CloudEvent> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        JavaType valueType = TYPE_CACHE.computeIfAbsent(genericType, a -> OBJECT_MAPPER.getTypeFactory().constructType(genericType));
        JsonNode jsonNode = OBJECT_MAPPER.readTree(entityStream);
        return CloudEventReader.getCloudEvent(jsonNode, valueType);
    }

    private static CloudEvent getCloudEvent(JsonNode jsonNode, JavaType valueType) throws IOException {
        String dataContentType;
        switch (dataContentType = jsonNode.get("datacontenttype").asText()) {
            case "application/json": {
                return (CloudEvent)OBJECT_MAPPER.treeToValue((TreeNode)jsonNode, valueType);
            }
            case "text/plain": {
                String data = jsonNode.get("data").asText();
                return (CloudEvent)OBJECT_MAPPER.readValue(data, valueType);
            }
            case "application/octet-stream": {
                byte[] binaryData = jsonNode.get("data_base64").binaryValue();
                String pubsubname = jsonNode.get("pubsubname").asText();
                String rawPayload = Optional.ofNullable(DAPR_CONFIG.pubSub().get(pubsubname)).map(a -> a.consumeMetadata()).map(a -> (String)a.get("rawPayload")).orElse("");
                if (Objects.equals("true", rawPayload)) {
                    JsonNode subJsonNode = OBJECT_MAPPER.readTree(binaryData);
                    return CloudEventReader.getCloudEvent(subJsonNode, valueType);
                }
                return (CloudEvent)OBJECT_MAPPER.readValue(binaryData, valueType);
            }
        }
        throw new NotSupportedException("can't read unknown cloud event content type: " + dataContentType);
    }

    static {
        TYPE_CACHE = new ConcurrentHashMap<Type, JavaType>();
    }
}

