/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.dapr.serializer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.MessageLite;
import io.dapr.serializer.DaprObjectSerializer;
import io.dapr.utils.TypeRef;
import java.io.IOException;

public class JacksonDaprObjectSerializer
implements DaprObjectSerializer {
    private final ObjectMapper objectMapper;

    public JacksonDaprObjectSerializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public byte[] serialize(Object state) throws IOException {
        if (state == null) {
            return null;
        }
        if (state.getClass() == Void.class) {
            return null;
        }
        if (state instanceof byte[]) {
            return (byte[])state;
        }
        if (state instanceof MessageLite) {
            return ((MessageLite)state).toByteArray();
        }
        return this.objectMapper.writeValueAsBytes(state);
    }

    public <T> T deserialize(byte[] data, TypeRef<T> type) throws IOException {
        if (data.length == 0) {
            return null;
        }
        return (T)this.objectMapper.readValue(data, this.objectMapper.constructType(type.getType()));
    }

    public String getContentType() {
        return "application/json";
    }
}

