/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.dashbuilder.deployment;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.quarkiverse.dashbuilder.deployment.DashboardsBuildItem;
import io.quarkiverse.dashbuilder.deployment.DashbuilderConfig;
import io.quarkiverse.dashbuilder.runtime.DashbuilderRecorder;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.maven.dependency.GACT;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.webjar.WebJarBuildItem;
import io.quarkus.vertx.http.deployment.webjar.WebJarResourcesFilter;
import io.quarkus.vertx.http.deployment.webjar.WebJarResultsBuildItem;
import io.vertx.core.Handler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;
import org.yaml.snakeyaml.Yaml;

public class DashbuilderProcessor {
    private static final Logger log = Logger.getLogger(DashbuilderProcessor.class);
    private static final GACT DASHBUILDER_UI_WEBJAR_ARTIFACT_KEY = new GACT("io.quarkiverse.dashbuilder", "quarkus-dashbuilder-ui", null, "jar");
    private static final String FEATURE = "dashbuilder";
    private static final String SETUP_FILE = "setup.js";
    private static final String SAMPLES_FILE = "samples.json";
    private static final String SAMPLES_URL = "samples";
    private static final String SAMPLES_EXT = ".dash.yaml";
    private static final String DASHBUILDER_STATIC_PATH = "@kie-tools/dashbuilder-client/dist/";
    private static final String DASHBOARDS_WEB_CONTEXT = "__dashboard";
    private static final String SAMPLES_EDIT_URL = "getSamplePath";
    private static final String PROPERTIES_KEY = "properties";

    @BuildStep
    public FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    public void scanDashboardsAndSamples(ApplicationArchivesBuildItem applicationArchives, BuildProducer<HotDeploymentWatchedFileBuildItem> hotDeploymentWatchedFiles, DashbuilderConfig dashbuilderConfig, BuildProducer<DashboardsBuildItem> dashboardsProducer) {
        DashboardsBuildItem dashboardsBuildItem = new DashboardsBuildItem();
        ArrayList<String> watchList = new ArrayList<String>();
        Optional<List<String>> dashboards = dashbuilderConfig.dashboards;
        BiConsumer<String, String> register = (name, content) -> {
            if (dashbuilderConfig.properties.containsKey(name)) {
                Map<String, String> dashboardProperties = dashbuilderConfig.properties.get(name);
                String newContent = this.replaceProperties(dashboardProperties, (String)name, (String)content);
                dashboardsBuildItem.registerDashboard((String)name, newContent);
            } else {
                dashboardsBuildItem.registerDashboard((String)name, (String)content);
            }
        };
        if (dashboards.isEmpty()) {
            applicationArchives.getRootArchive().accept(t -> t.walk(visit -> {
                Path path = visit.getPath();
                if (this.isDashboard(path.toString())) {
                    String relativePath = visit.getRelativePath("/");
                    watchList.add(relativePath);
                    try {
                        String name = this.getDashboardName(path);
                        String content = Files.readString(path);
                        register.accept(name, content);
                    }
                    catch (IOException e) {
                        log.errorv("Not able to load dashboard file {}: {}", (Object)relativePath, (Object)e.getMessage());
                        log.debug((Object)e);
                    }
                }
            }));
            int n = dashboardsBuildItem.listDashboards().size();
            log.info((Object)("Found " + n + " dashboard" + (n == 1 ? "" : "s")));
        } else {
            for (String db2 : dashboards.get()) {
                String name2 = this.getDashboardName(Paths.get(db2, new String[0]));
                String content2 = this.readDashboardFromClasspath(db2);
                if (content2 != null) {
                    watchList.add(db2);
                    register.accept(name2, content2);
                    log.info((Object)("Registered " + db2));
                    continue;
                }
                log.warn((Object)("Not able to load " + db2));
            }
        }
        dashboardsProducer.produce((BuildItem)dashboardsBuildItem);
        watchList.forEach(db -> hotDeploymentWatchedFiles.produce((BuildItem)new HotDeploymentWatchedFileBuildItem(db)));
    }

    @BuildStep
    public void buildDashbuilderWebApp(DashboardsBuildItem dashboardsBuildItem, CurateOutcomeBuildItem curateOutcomeBuildItem, DashbuilderConfig dashbuilderConfig, BuildProducer<WebJarBuildItem> webJarBuildProducer) throws Exception {
        Set<String> dashboards = dashboardsBuildItem.listDashboards();
        byte[] buildSetupJs = this.buildSetupJs(dashboards, dashbuilderConfig).getBytes();
        String appPath = curateOutcomeBuildItem.getApplicationModel().getApplicationModule().getModuleDir().toString();
        dashboardsBuildItem.setApplicationDirectory(appPath);
        webJarBuildProducer.produce((BuildItem)WebJarBuildItem.builder().artifactKey(DASHBUILDER_UI_WEBJAR_ARTIFACT_KEY).root(DASHBUILDER_STATIC_PATH).filter((fileName, file) -> {
            if (fileName.startsWith(SAMPLES_URL) && !this.includeSamples(dashbuilderConfig)) {
                return new WebJarResourcesFilter.FilterResult(null, true);
            }
            if (fileName.equals(SETUP_FILE)) {
                return new WebJarResourcesFilter.FilterResult((InputStream)new ByteArrayInputStream(buildSetupJs), true);
            }
            if (fileName.equals(SAMPLES_FILE)) {
                ByteArrayInputStream filteredSamples = this.filterSamples(curateOutcomeBuildItem, file);
                return new WebJarResourcesFilter.FilterResult((InputStream)filteredSamples, true);
            }
            if (fileName.startsWith("samples/") && this.isDashboard(fileName)) {
                String sampleId = this.retrieveSampleId(fileName);
                byte[] samplesBytes = file.readAllBytes();
                String content = new String(samplesBytes, StandardCharsets.UTF_8);
                dashboardsBuildItem.registerSample(sampleId, content);
                return new WebJarResourcesFilter.FilterResult((InputStream)new ByteArrayInputStream(samplesBytes), false);
            }
            return new WebJarResourcesFilter.FilterResult(file, false);
        }).build());
    }

    private String retrieveSampleId(String fileName) {
        return Paths.get(fileName, new String[0]).toFile().getName().replaceAll(SAMPLES_EXT, "");
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void registerDashbuilderHandler(DashbuilderRecorder dashbuilderRecorder, DashboardsBuildItem dashboardsBuildItem, BuildProducer<RouteBuildItem> routes, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, WebJarResultsBuildItem webJarResultsBuildItem, LaunchModeBuildItem launchMode, DashbuilderConfig dashbuilderConfig, ShutdownContextBuildItem shutdownContext) {
        WebJarResultsBuildItem.WebJarResult result = webJarResultsBuildItem.byArtifactKey(DASHBUILDER_UI_WEBJAR_ARTIFACT_KEY);
        if (result == null) {
            return;
        }
        String dashbuilderWebAppPath = nonApplicationRootPathBuildItem.resolvePath(dashbuilderConfig.path);
        Handler webAppHandler = dashbuilderRecorder.dashbuilderWebAppHandler(result.getFinalDestination(), dashbuilderWebAppPath, result.getWebRootConfigurations(), (ShutdownContext)shutdownContext);
        Handler dashboardsHandler = dashbuilderRecorder.dashboardsHandler(DASHBOARDS_WEB_CONTEXT, dashboardsBuildItem.getDashboards());
        String dashboardsContext = dashbuilderConfig.path + "/__dashboard";
        routes.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().route(dashbuilderConfig.path).displayOnNotFoundPage("Dashbuilder Web App").routeConfigKey("quarkus.dashbuilder.path").handler(webAppHandler).build());
        routes.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().route(dashbuilderConfig.path + "*").handler(webAppHandler).build());
        routes.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().route(dashboardsContext).handler(dashboardsHandler).build());
        routes.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().route(dashboardsContext + "*").handler(dashboardsHandler).build());
        if (this.isDev()) {
            Handler samplesHandler = dashbuilderRecorder.samplesHandler(dashboardsBuildItem.getAppDir(), dashboardsBuildItem.getSamples());
            routes.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().route(SAMPLES_EDIT_URL).handler(samplesHandler).build());
            routes.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().route("getSamplePath*").handler(samplesHandler).build());
        }
    }

    boolean isDashboard(String path) {
        return path.endsWith(SAMPLES_EXT) || path.endsWith(".dash.yml") || path.endsWith(".dash.json");
    }

    ByteArrayInputStream filterSamples(CurateOutcomeBuildItem curateOutcomeBuildItem, InputStream file) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonObj = mapper.readTree(file);
            ObjectNode resultNode = mapper.createObjectNode();
            curateOutcomeBuildItem.getApplicationModel().getDependencies().stream().filter(Dependency::isRuntimeExtensionArtifact).map(ArtifactCoords::getArtifactId).filter(arg_0 -> ((JsonNode)jsonObj).has(arg_0)).forEach(artifact -> resultNode.set(artifact, jsonObj.get(artifact)));
            return new ByteArrayInputStream(mapper.writeValueAsBytes((Object)resultNode));
        }
        catch (IOException e) {
            throw new RuntimeException("Error generating samples file", e);
        }
    }

    String buildSetupJs(Set<String> dashboardsSet, DashbuilderConfig config) {
        String dashboardsJsArray = dashboardsSet.stream().map(p -> "'" + p + "'").collect(Collectors.joining(",", "[", "]"));
        StringBuffer setupJsSb = new StringBuffer();
        setupJsSb.append("dashbuilder = {\n");
        setupJsSb.append("   \"mode\": \"CLIENT\"\n");
        if (!dashboardsSet.isEmpty()) {
            setupJsSb.append(",   \"path\": \"__dashboard\"\n");
            setupJsSb.append(",   \"dashboards\": " + dashboardsJsArray + "\n");
        }
        if (this.includeSamples(config)) {
            setupJsSb.append(",  \"samplesUrl\": \"samples\"\n");
        }
        if (this.isDev()) {
            setupJsSb.append(",  \"samplesEditService\": \"/q/getSamplePath\"\n");
        }
        setupJsSb.append("}");
        return setupJsSb.toString();
    }

    String getDashboardName(Path dashboard) {
        String fileName = dashboard.getFileName().toString();
        int dotIndex = fileName.indexOf(".");
        return dotIndex == -1 ? fileName : fileName.substring(0, dotIndex);
    }

    String readDashboardFromClasspath(String db) {
        InputStream is;
        Object resource = db;
        if (!db.startsWith("/")) {
            resource = "/" + (String)resource;
        }
        if ((is = Thread.currentThread().getContextClassLoader().getResourceAsStream((String)resource)) != null) {
            try {
                return new String(is.readAllBytes(), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                log.errorv("Not able to read {}: {}", (Object)db, (Object)e.getMessage());
                log.debug((Object)e);
            }
        }
        return null;
    }

    private boolean isDev() {
        return LaunchMode.current() == LaunchMode.DEVELOPMENT;
    }

    private boolean includeSamples(DashbuilderConfig config) {
        return this.isDev() || config.includeSamples;
    }

    private String replaceProperties(Map<String, String> dashboardProperties, String name, String content) {
        try {
            Yaml yaml = new Yaml();
            Map loadedYaml = (Map)yaml.load(content);
            Map props = (Map)loadedYaml.get(PROPERTIES_KEY);
            Config config = ConfigProvider.getConfig();
            if (props != null && !props.isEmpty()) {
                props.keySet().stream().map(arg_0 -> ((Config)config).getConfigValue(arg_0)).filter(prop -> prop.getValue() != null).forEach(prop -> props.put(prop.getName(), prop.getValue()));
                props.keySet().stream().filter(dashboardProperties::containsKey).forEach(key -> props.put(key, (String)dashboardProperties.get(key)));
                return yaml.dumpAsMap((Object)loadedYaml);
            }
        }
        catch (Exception e) {
            log.errorv("Error replacing properties for dashboard {0}: {1}", (Object)name, (Object)e.getMessage());
            log.debug((Object)e);
        }
        return content;
    }
}

