/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.dashbuilder.runtime;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class DashboardsHandler
implements Handler<RoutingContext> {
    private String basePath;
    private Map<String, String> dashboards;

    public DashboardsHandler() {
    }

    public DashboardsHandler(String basePath, Map<String, String> dashboardsBuildItem) {
        this.basePath = basePath;
        this.dashboards = dashboardsBuildItem;
    }

    public void handle(RoutingContext event) {
        HttpServerRequest request = event.request();
        HttpServerResponse response = event.response();
        String name = this.retrieveName(request.uri());
        String dashboard = this.dashboards.get(name);
        if (request.method() != HttpMethod.GET) {
            response.setStatusCode(405);
            response.end();
        } else if (dashboard != null) {
            response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/plain");
            response.setStatusCode(200);
            response.end(dashboard);
        } else {
            response.setStatusCode(404);
            response.end();
        }
    }

    String retrieveName(String uri) {
        int index = uri.indexOf(this.basePath) + this.basePath.length() + 1;
        if (index < uri.length()) {
            String name = uri.substring(index, uri.length());
            try {
                return URLDecoder.decode(name, StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException e) {
                return name;
            }
        }
        return null;
    }
}

