/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.docker.client.runtime;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.httpclient5.ApacheDockerHttpClient;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.transport.SSLConfig;
import io.quarkiverse.docker.client.runtime.config.DockerClientRuntimeConfig;
import org.apache.commons.lang3.SystemUtils;

public class DockerClientFactory {
    private static final String WINDOWS_DOCKER_HOST = "npipe:////./pipe/docker_engine";
    private static final String UNIX_DOCKER_HOST = "unix:///var/run/docker.sock";
    private final DockerClientRuntimeConfig config;

    public DockerClientFactory(DockerClientRuntimeConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("DockerClientRuntimeConfig cannot be null");
        }
        this.config = config;
    }

    public DockerClient createClient() {
        DockerClientConfig clientConfig = this.buildDockerClientConfig();
        DockerHttpClient httpClient = this.buildDockerHttpClient(clientConfig);
        return DockerClientImpl.getInstance((DockerClientConfig)clientConfig, (DockerHttpClient)httpClient);
    }

    private DockerClientConfig buildDockerClientConfig() {
        DefaultDockerClientConfig.Builder configBuilder = DefaultDockerClientConfig.createDefaultConfigBuilder();
        this.configureDockerHost(configBuilder);
        this.applyOptionalConfiguration(configBuilder);
        return configBuilder.build();
    }

    private void configureDockerHost(DefaultDockerClientConfig.Builder builder) {
        this.config.dockerHost().ifPresentOrElse(arg_0 -> ((DefaultDockerClientConfig.Builder)builder).withDockerHost(arg_0), () -> {
            if (SystemUtils.IS_OS_WINDOWS) {
                builder.withDockerHost(WINDOWS_DOCKER_HOST);
            } else if (SystemUtils.IS_OS_UNIX) {
                builder.withDockerHost(UNIX_DOCKER_HOST);
            } else {
                throw new IllegalStateException("Unsupported operating system. Please explicitly configure 'dockerHost'");
            }
        });
    }

    private void applyOptionalConfiguration(DefaultDockerClientConfig.Builder builder) {
        this.config.dockerConfig().ifPresent(arg_0 -> ((DefaultDockerClientConfig.Builder)builder).withDockerConfig(arg_0));
        this.config.apiVersion().ifPresent(arg_0 -> ((DefaultDockerClientConfig.Builder)builder).withApiVersion(arg_0));
        this.config.dockerContext().ifPresent(arg_0 -> ((DefaultDockerClientConfig.Builder)builder).withDockerContext(arg_0));
        this.config.dockerCertPath().ifPresent(arg_0 -> ((DefaultDockerClientConfig.Builder)builder).withDockerCertPath(arg_0));
        this.config.dockerTlsVerify().ifPresent(arg_0 -> ((DefaultDockerClientConfig.Builder)builder).withDockerTlsVerify(arg_0));
        this.applyRegistryConfiguration(builder);
    }

    private void applyRegistryConfiguration(DefaultDockerClientConfig.Builder builder) {
        this.config.registryEmail().ifPresent(arg_0 -> ((DefaultDockerClientConfig.Builder)builder).withRegistryEmail(arg_0));
        this.config.registryUsername().ifPresent(arg_0 -> ((DefaultDockerClientConfig.Builder)builder).withRegistryUsername(arg_0));
        this.config.registryPassword().ifPresent(arg_0 -> ((DefaultDockerClientConfig.Builder)builder).withRegistryPassword(arg_0));
        this.config.registryUrl().ifPresent(arg_0 -> ((DefaultDockerClientConfig.Builder)builder).withRegistryUrl(arg_0));
    }

    private DockerHttpClient buildDockerHttpClient(DockerClientConfig dockerConfig) {
        return new ApacheDockerHttpClient.Builder().dockerHost(dockerConfig.getDockerHost()).sslConfig((SSLConfig)dockerConfig.getSSLConfig()).connectionTimeout(this.config.connectTimeout()).responseTimeout(this.config.readTimeout()).build();
    }
}

