/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.docker.client.runtime;

import com.github.dockerjava.api.DockerClient;
import io.quarkiverse.docker.client.runtime.DockerClientFactory;
import io.quarkiverse.docker.client.runtime.config.DockerClientRuntimeConfig;
import io.quarkiverse.docker.client.runtime.config.DockerRuntimeConfig;
import io.quarkus.runtime.annotations.Recorder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

@Recorder
public class DockerClientRecorder {
    private static final Map<String, DockerClient> clients = Collections.synchronizedMap(new HashMap());
    private final DockerRuntimeConfig config;

    public DockerClientRecorder(DockerRuntimeConfig config) {
        this.config = config;
    }

    public void initialize(Set<String> names) {
        if (names == null) {
            throw new IllegalArgumentException("Client names set cannot be null");
        }
        for (String name : names) {
            this.initializeClient(name);
        }
    }

    private void initializeClient(String name) {
        DockerClientRuntimeConfig clientConfig = DockerClientRecorder.getConfigForName(this.config, name).orElseThrow(() -> new IllegalStateException(String.format("No configuration found for Docker client: %s", name)));
        if (clientConfig.enabled()) {
            clients.computeIfAbsent(name, k -> this.createDockerClient(clientConfig));
        }
    }

    private DockerClient createDockerClient(DockerClientRuntimeConfig clientConfig) {
        return new DockerClientFactory(clientConfig).createClient();
    }

    static Optional<DockerClientRuntimeConfig> getConfigForName(DockerRuntimeConfig cfg, String name) {
        if (DockerRuntimeConfig.isDefaultClient(name)) {
            return Optional.ofNullable(cfg.defaultDockerClient());
        }
        return cfg.namedDockerClients().entrySet().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase(name)).map(Map.Entry::getValue).findFirst();
    }

    public Supplier<DockerClient> createDockerClientBean() {
        return () -> {
            DockerClient client = clients.get("<default>");
            if (client == null) {
                throw new IllegalStateException("Default Docker client not initialized");
            }
            return client;
        };
    }

    public Supplier<DockerClient> createNamedDockerClientBean(String clientName) {
        return () -> {
            DockerClient client = clients.get(clientName);
            if (client == null) {
                throw new IllegalStateException(String.format("Docker client '%s' not initialized", clientName));
            }
            return client;
        };
    }
}

