/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.docker.client.runtime.config;

import io.quarkiverse.docker.client.runtime.config.DockerClientRuntimeConfig;
import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithName;
import io.smallrye.config.WithParentName;
import java.util.Map;
import java.util.Optional;

@ConfigMapping(prefix="quarkus.docker")
@ConfigRoot(phase=ConfigPhase.BUILD_AND_RUN_TIME_FIXED)
public interface DockerRuntimeConfig {
    public static final String DOCKER_CONFIG_ROOT_NAME = "docker";
    public static final String DEFAULT_CLIENT_NAME = "<default>";

    @WithParentName
    public DockerClientRuntimeConfig defaultDockerClient();

    @WithName(value="health-check")
    public Optional<Boolean> enableHealthCheck();

    @WithParentName
    @ConfigDocMapKey(value="docker-client-name")
    public Map<String, DockerClientRuntimeConfig> namedDockerClients();

    public static boolean isDefaultClient(String name) {
        return DEFAULT_CLIENT_NAME.equalsIgnoreCase(name);
    }

    public static String propertyKey(String name, String radical) {
        if (name == null || radical == null) {
            throw new IllegalArgumentException("Name and radical cannot be null");
        }
        Object prefix = DEFAULT_CLIENT_NAME.equals(name) ? "quarkus.docker." : "quarkus.docker.\"" + name + "\".";
        return (String)prefix + radical;
    }
}

