/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.docker.client.runtime.health;

import com.github.dockerjava.api.DockerClient;
import io.quarkiverse.docker.client.runtime.NamedDockerClient;
import io.quarkiverse.docker.client.runtime.config.DockerClientRuntimeConfig;
import io.quarkiverse.docker.client.runtime.config.DockerRuntimeConfig;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.smallrye.mutiny.TimeoutException;
import io.smallrye.mutiny.Uni;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.Bean;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
public class DockerClientHealthCheck
implements HealthCheck {
    private static final String HEALTH_CHECK_NAME = "Docker daemon connection health check";
    private static final String CLIENT_STATUS_FORMAT = "client [%s]: %s";
    private static final String STATUS_OK = "OK";
    private static final String REASON_KEY = "reason";
    private static final String DEFAULT_CLIENT_DISPLAY_NAME = "default";
    private final Map<String, DockerClient> clients = new HashMap<String, DockerClient>();
    private final DockerRuntimeConfig config;

    public DockerClientHealthCheck(DockerRuntimeConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("DockerRuntimeConfig cannot be null");
        }
        this.config = config;
    }

    @PostConstruct
    protected void init() {
        Arc.container().select(DockerClient.class, new Annotation[]{Any.Literal.INSTANCE}).handles().forEach(this::registerClient);
    }

    private void registerClient(InstanceHandle<DockerClient> handle) {
        String clientName = this.getClientName((Bean<?>)handle.getBean());
        String effectiveName = clientName == null ? "<default>" : clientName;
        this.clients.putIfAbsent(effectiveName, (DockerClient)handle.get());
    }

    private String getClientName(Bean<?> bean) {
        return bean.getQualifiers().stream().filter(qualifier -> qualifier instanceof NamedDockerClient).map(qualifier -> ((NamedDockerClient)qualifier).value()).findFirst().orElse(null);
    }

    private Duration getTimeout(String name) {
        DockerClientRuntimeConfig clientConfig = DockerRuntimeConfig.isDefaultClient(name) ? this.config.defaultDockerClient() : Optional.ofNullable(this.config.namedDockerClients().get(name)).orElseThrow(() -> new IllegalStateException("Configuration not found for client: " + name));
        return clientConfig.connectTimeout();
    }

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)HEALTH_CHECK_NAME).up();
        for (Map.Entry<String, DockerClient> entry : this.clients.entrySet()) {
            String clientName = entry.getKey();
            DockerClient client = entry.getValue();
            try {
                this.checkClientHealth(builder, clientName, client);
            }
            catch (TimeoutException e) {
                return this.createErrorResponse(builder, clientName, "timeout");
            }
            catch (Exception e) {
                return this.createErrorResponse(builder, clientName, e.getMessage() != null ? e.getMessage() : e.toString());
            }
        }
        return builder.build();
    }

    private void checkClientHealth(HealthCheckResponseBuilder builder, String clientName, DockerClient client) {
        Duration timeout = this.getTimeout(clientName);
        Uni.createFrom().item(() -> (Void)client.pingCmd().exec()).await().atMost(timeout);
        String displayName = DockerRuntimeConfig.isDefaultClient(clientName) ? DEFAULT_CLIENT_DISPLAY_NAME : clientName;
        builder.up().withData(displayName, String.format(CLIENT_STATUS_FORMAT, displayName, STATUS_OK));
    }

    private HealthCheckResponse createErrorResponse(HealthCheckResponseBuilder builder, String clientName, String errorMessage) {
        return builder.down().withData(REASON_KEY, String.format(CLIENT_STATUS_FORMAT, clientName, errorMessage)).build();
    }
}

