/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.doma.deployment;

import io.quarkus.runtime.util.ClassPathUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class DomaResourceScanner {
    private static final Logger logger = Logger.getLogger(DomaResourceScanner.class);
    private static final String META_INF = "META-INF";

    List<String> scan() {
        HashSet files = new HashSet();
        try {
            ClassPathUtils.consumeAsPaths((String)META_INF, resource -> this.collect((Path)resource, files));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return files.stream().map(it -> "META-INF/" + it).collect(Collectors.toList());
    }

    private void collect(final Path resource, final Set<String> files) {
        try {
            Files.walkFileTree(resource, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    String fileName = resource.relativize(file).toString();
                    if (fileName.endsWith(".sql") || fileName.endsWith(".script")) {
                        logger.debugf("resource found: %s", (Object)fileName);
                        files.add(fileName);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

