/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.doma.deployment;

import io.quarkiverse.doma.deployment.DomaBuildTimeConfig;
import io.quarkiverse.doma.runtime.DomaSettings;
import io.quarkus.agroal.spi.JdbcDataSourceBuildItem;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jboss.logging.Logger;

public class DomaSettingsFactory {
    private static final Logger logger = Logger.getLogger(DomaSettingsFactory.class);
    private final DomaBuildTimeConfig buildTimeConfig;
    private final List<JdbcDataSourceBuildItem> dataSources;
    private final ApplicationArchivesBuildItem applicationArchives;
    private final LaunchModeBuildItem launchMode;

    DomaSettingsFactory(DomaBuildTimeConfig buildTimeConfig, List<JdbcDataSourceBuildItem> dataSources, ApplicationArchivesBuildItem applicationArchives, LaunchModeBuildItem launchMode) {
        this.buildTimeConfig = Objects.requireNonNull(buildTimeConfig);
        this.dataSources = new ArrayList<JdbcDataSourceBuildItem>((Collection)Objects.requireNonNull(dataSources));
        this.applicationArchives = Objects.requireNonNull(applicationArchives);
        this.launchMode = Objects.requireNonNull(launchMode);
    }

    DomaSettings create() {
        DomaSettings settings = new DomaSettings();
        settings.sqlFileRepository = this.buildTimeConfig.sqlFileRepository();
        settings.naming = this.buildTimeConfig.naming();
        settings.exceptionSqlLogType = this.buildTimeConfig.exceptionSqlLogType();
        settings.dataSources = this.dataSources();
        if (this.dataSources.isEmpty()) {
            throw new IllegalStateException("The quarkus.datasource is empty. Specify it.");
        }
        DomaSettings.SqlBuilderSettings sqlBuilderSettings = new DomaSettings.SqlBuilderSettings();
        sqlBuilderSettings.shouldRemoveBlankLines = this.buildTimeConfig.sqlBuilderSettings().shouldRemoveBlankLines();
        sqlBuilderSettings.shouldRequireInListPadding = this.buildTimeConfig.sqlBuilderSettings().shouldRequireInListPadding();
        settings.sqlBuilderSettings = sqlBuilderSettings;
        settings.throwExceptionIfDuplicateColumn = this.buildTimeConfig.throwExceptionIfDuplicateColumn();
        logger.debugf("settings: %s", (Object)settings);
        return settings;
    }

    private List<DomaSettings.DataSourceSettings> dataSources() {
        return this.dataSources.stream().map(ds -> this.createDataSourceSettings((JdbcDataSourceBuildItem)ds, this.buildTimeConfig.dataSources().get(ds.getName()))).toList();
    }

    private DomaSettings.DataSourceSettings createDataSourceSettings(JdbcDataSourceBuildItem dataSource, DomaBuildTimeConfig.DataSourceBuildTimeConfig dataSourceBuildTimeConfig) {
        DomaSettings.DataSourceSettings settings = new DomaSettings.DataSourceSettings();
        settings.name = dataSource.getName();
        settings.isDefault = dataSource.isDefault();
        settings.dialect = dataSourceBuildTimeConfig.dialect().orElseGet(() -> this.resolveDialectType(dataSource.getDbKind()));
        settings.batchSize = dataSourceBuildTimeConfig.batchSize();
        settings.fetchSize = dataSourceBuildTimeConfig.fetchSize();
        settings.maxRows = dataSourceBuildTimeConfig.maxRows();
        settings.queryTimeout = dataSourceBuildTimeConfig.queryTimeout();
        settings.sqlLoadScript = this.resolveSqlLoadScript(dataSourceBuildTimeConfig.sqlLoadScript());
        return settings;
    }

    private DomaSettings.DialectType resolveDialectType(String dbKind) {
        switch (dbKind) {
            case "h2": {
                return DomaSettings.DialectType.H2;
            }
            case "mssql": {
                return DomaSettings.DialectType.MSSQL;
            }
            case "mysql": 
            case "mariadb": {
                return DomaSettings.DialectType.MYSQL;
            }
            case "postgresql": 
            case "pgsql": 
            case "pg": {
                return DomaSettings.DialectType.POSTGRES;
            }
        }
        throw new IllegalStateException("Can't infer the dialect from the dbKind \"" + dbKind + "\". The dbKind is illegal or not supported.");
    }

    private String resolveSqlLoadScript(Optional<String> sqlLoadScript) {
        if (sqlLoadScript.isPresent()) {
            if (sqlLoadScript.get().equals("no-file")) {
                return null;
            }
            Path path = this.applicationArchives.getRootArchive().getChildPath(sqlLoadScript.get());
            if (path == null || Files.isDirectory(path, new LinkOption[0])) {
                throw new IllegalStateException(String.format("Can't find the file referenced in 'quarkus.doma.sql-load-script=%s'. Remove property or add file to your path.", sqlLoadScript.get()));
            }
            return sqlLoadScript.get();
        }
        if (this.launchMode.getLaunchMode().isDevOrTest()) {
            Path path = this.applicationArchives.getRootArchive().getChildPath("import.sql");
            if (path == null || Files.isDirectory(path, new LinkOption[0])) {
                return null;
            }
            return "import.sql";
        }
        return null;
    }
}

