/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.doma.runtime;

import io.quarkus.agroal.runtime.DataSources;
import io.quarkus.arc.DefaultBean;
import io.quarkus.arc.Unremovable;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Objects;
import javax.sql.DataSource;

public interface DataSourceResolver {
    public DataSource resolve(String var1);

    @Singleton
    @DefaultBean
    @Unremovable
    public static class DefaultDataSourceResolver
    implements DataSourceResolver {
        private final DataSources dataSources;

        @Inject
        public DefaultDataSourceResolver(DataSources dataSources) {
            this.dataSources = Objects.requireNonNull(dataSources);
        }

        @Override
        public DataSource resolve(String dataSourceName) {
            Objects.requireNonNull(dataSourceName);
            return this.dataSources.getDataSource(dataSourceName);
        }
    }
}

