/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.doma.runtime;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.seasar.doma.jdbc.GreedyCacheSqlFileRepository;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.NoCacheSqlFileRepository;
import org.seasar.doma.jdbc.SqlFileRepository;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.dialect.Db2Dialect;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.dialect.H2Dialect;
import org.seasar.doma.jdbc.dialect.MssqlDialect;
import org.seasar.doma.jdbc.dialect.MysqlDialect;
import org.seasar.doma.jdbc.dialect.OracleDialect;
import org.seasar.doma.jdbc.dialect.PostgresDialect;
import org.seasar.doma.jdbc.dialect.SqliteDialect;
import org.seasar.doma.jdbc.dialect.StandardDialect;

public class DomaSettings {
    public SqlFileRepositoryType sqlFileRepository;
    public NamingType naming;
    public SqlLogType exceptionSqlLogType;
    public List<DataSourceSettings> dataSources;
    public SqlBuilderSettings sqlBuilderSettings;
    public boolean throwExceptionIfDuplicateColumn;

    public Map<String, String> asNamedSqlLoadScripts() {
        return this.dataSources.stream().filter(it -> it.sqlLoadScript != null).collect(Collectors.toMap(it -> it.name, it -> it.sqlLoadScript, (a, b) -> a, LinkedHashMap::new));
    }

    public String toString() {
        return "DomaSettings{sqlFileRepository=" + String.valueOf((Object)this.sqlFileRepository) + ", naming=" + String.valueOf((Object)this.naming) + ", exceptionSqlLogType=" + String.valueOf(this.exceptionSqlLogType) + ", dataSources=" + String.valueOf(this.dataSources) + ", sqlBuilderSettings=" + String.valueOf(this.sqlBuilderSettings) + ", throwExceptionIfDuplicateColumn=" + this.throwExceptionIfDuplicateColumn + "}";
    }

    public static enum SqlFileRepositoryType {
        NO_CACHE(NoCacheSqlFileRepository::new),
        GREEDY_CACHE(GreedyCacheSqlFileRepository::new);

        private final Supplier<SqlFileRepository> constructor;

        private SqlFileRepositoryType(Supplier<SqlFileRepository> constructor) {
            this.constructor = constructor;
        }

        public SqlFileRepository create() {
            return this.constructor.get();
        }
    }

    public static enum NamingType {
        NONE(Naming.NONE),
        LOWER_CASE(Naming.LOWER_CASE),
        UPPER_CASE(Naming.UPPER_CASE),
        SNAKE_LOWER_CASE(Naming.SNAKE_LOWER_CASE),
        SNAKE_UPPER_CASE(Naming.SNAKE_UPPER_CASE);

        private final Naming naming;

        private NamingType(Naming naming) {
            this.naming = naming;
        }

        public Naming naming() {
            return this.naming;
        }
    }

    public static class SqlBuilderSettings {
        public boolean shouldRemoveBlankLines;
        public boolean shouldRequireInListPadding;

        public String toString() {
            return "SqlBuilderSettings{shouldRemoveBlankLines=" + this.shouldRemoveBlankLines + ", shouldRequireInListPadding=" + this.shouldRequireInListPadding + "}";
        }
    }

    public static class DataSourceSettings {
        public String name;
        public boolean isDefault;
        public DialectType dialect;
        public int batchSize;
        public int fetchSize;
        public int maxRows;
        public int queryTimeout;
        public String sqlLoadScript;

        public String toString() {
            return "DataSourceSettings{name='" + this.name + "', isDefault=" + this.isDefault + ", dialect=" + String.valueOf((Object)this.dialect) + ", batchSize=" + this.batchSize + ", fetchSize=" + this.fetchSize + ", maxRows=" + this.maxRows + ", queryTimeout=" + this.queryTimeout + ", sqlLoadScript='" + this.sqlLoadScript + "'}";
        }
    }

    public static enum DialectType {
        DB2(Db2Dialect::new),
        H2(H2Dialect::new),
        MSSQL(MssqlDialect::new),
        MYSQL(MysqlDialect::new),
        ORACLE(OracleDialect::new),
        POSTGRES(PostgresDialect::new),
        STANDARD(StandardDialect::new),
        SQLITE(SqliteDialect::new);

        private final Supplier<Dialect> constructor;

        private DialectType(Supplier<Dialect> constructor) {
            this.constructor = constructor;
        }

        public Dialect create() {
            return this.constructor.get();
        }
    }
}

