/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.doma.runtime;

import io.agroal.api.AgroalDataSource;
import io.quarkus.agroal.runtime.DataSources;
import io.quarkus.arc.DefaultBean;
import io.quarkus.runtime.StartupEvent;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import org.jboss.logging.Logger;
import org.seasar.doma.internal.util.ResourceUtil;

@Singleton
@DefaultBean
public class ScriptExecutor {
    private static final Logger logger = Logger.getLogger((String)ScriptExecutor.class.getName());
    private final Map<String, String> namedSqlLoadScripts;
    private final DataSources dataSources;

    @Inject
    public ScriptExecutor(@Named(value="doma.namedSqlLoadScripts") Map<String, String> namedSqlLoadScripts, DataSources dataSources) {
        Objects.requireNonNull(namedSqlLoadScripts);
        this.namedSqlLoadScripts = Collections.unmodifiableMap(namedSqlLoadScripts);
        this.dataSources = dataSources;
    }

    void onStartup(@Observes StartupEvent event) throws Exception {
        for (Map.Entry<String, String> entry : this.namedSqlLoadScripts.entrySet()) {
            String name = entry.getKey();
            String path = entry.getValue();
            AgroalDataSource dataSource = this.dataSources.getDataSource(name);
            if (dataSource == null) {
                throw new IllegalStateException(String.format("The datasource '%s' is not found.", name));
            }
            this.execute((DataSource)dataSource, path);
        }
    }

    private void execute(DataSource dataSource, String path) throws Exception {
        logger.infof("Execute %s", (Object)path);
        String sql = ResourceUtil.getResourceAsString((String)path);
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute(sql);
        }
    }
}

