/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.embedded.postgresql.deployment;

import io.quarkiverse.embedded.postgresql.EmbeddedPostgreSQLConnectionConfigurer;
import io.quarkiverse.embedded.postgresql.EmbeddedPostgreSQLRecorder;
import io.quarkus.agroal.spi.JdbcDriverBuildItem;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.runtime.DataSourcesBuildTimeConfig;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.IndexDependencyBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationSourceValueBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourcePatternsBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import java.io.IOException;

class EmbeddedPostgreSQLProcessor {
    private static final String FEATURE = "embedded-postgres";

    EmbeddedPostgreSQLProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    ServiceStartBuildItem startService(EmbeddedPostgreSQLRecorder recorder, ShutdownContextBuildItem shutdown, BuildProducer<RunTimeConfigurationSourceValueBuildItem> configSourceValueBuildItem, DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig) throws IOException {
        RuntimeValue info = recorder.startPostgres((ShutdownContext)shutdown, dataSourcesBuildTimeConfig);
        configSourceValueBuildItem.produce((BuildItem)new RunTimeConfigurationSourceValueBuildItem(recorder.configSources(info)));
        return new ServiceStartBuildItem(FEATURE);
    }

    @BuildStep
    void configureAgroalConnection(BuildProducer<AdditionalBeanBuildItem> additionalBeans, Capabilities capabilities) {
        if (capabilities.isPresent("io.quarkus.agroal")) {
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem.Builder().addBeanClass(EmbeddedPostgreSQLConnectionConfigurer.class).setDefaultScope(BuiltinScope.APPLICATION.getName()).setUnremovable().build());
        }
    }

    @BuildStep
    void registerDriver(BuildProducer<JdbcDriverBuildItem> jdbcDriver) {
        jdbcDriver.produce((BuildItem)new JdbcDriverBuildItem("postgresql", "org.postgresql.Driver", "org.postgresql.xa.PGXADataSource"));
    }

    @BuildStep
    void addDependencies(BuildProducer<IndexDependencyBuildItem> indexDependency) {
        indexDependency.produce((BuildItem)new IndexDependencyBuildItem("io.zonky.test", FEATURE));
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    public void nativeResources(BuildProducer<NativeImageResourcePatternsBuildItem> resource) {
        resource.produce((BuildItem)NativeImageResourcePatternsBuildItem.builder().includeGlob("postgres-*.txz").build());
    }
}

