/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.embedded.postgresql;

import io.quarkiverse.embedded.postgresql.EmbeddedPostgreSQLConfigSource;
import io.quarkiverse.embedded.postgresql.StartupInfo;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

public class EmbeddedPostgreSQLConfigSourceProvider
implements ConfigSourceProvider {
    static final String QUARKUS_DATASOURCE_REACTIVE_URL = "quarkus.datasource.reactive.url";
    static final String QUARKUS_DATASOURCE_JDBC_URL = "quarkus.datasource.jdbc.url";
    static final String QUARKUS_NAMED_DATASOURCE_REACTIVE_URL = "quarkus.datasource.\"%s\".reactive.url";
    static final String QUARKUS_NAMED_DATASOURCE_JDBC_URL = "quarkus.datasource.\"%s\".jdbc.url";
    static final String QUARKUS_DATASOURCE_USERNAME = "quarkus.datasource.username";
    static final String QUARKUS_DATASOURCE_PASSWORD = "quarkus.datasource.password";
    static final String QUARKUS_NAMED_DATASOURCE_USERNAME = "quarkus.datasource.\"%s\".username";
    static final String QUARKUS_NAMED_DATASOURCE_PASSWORD = "quarkus.datasource.\"%s\".password";
    static final String DEFAULT_DATABASE = "postgres";
    static final String DEFAULT_REACTIVE_URL = "postgresql://localhost:%d/%s?stringtype=unspecified";
    static final String DEFAULT_JDBC_URL = "jdbc:postgresql://localhost:%d/%s?stringtype=unspecified";
    static final String DEFAULT_USERNAME = "postgres";
    static final String DEFAULT_PASSWORD = "postgres";
    private StartupInfo startupInfo;

    public EmbeddedPostgreSQLConfigSourceProvider(StartupInfo startupInfo) {
        this.startupInfo = startupInfo;
    }

    public Iterable<ConfigSource> getConfigSources(ClassLoader forClassLoader) {
        HashMap<String, String> allConfigs = new HashMap<String, String>();
        this.startupInfo.getDatabases().forEach((key, value) -> {
            allConfigs.put(String.format(QUARKUS_NAMED_DATASOURCE_REACTIVE_URL, key), String.format(DEFAULT_REACTIVE_URL, this.startupInfo.getPort(), value));
            allConfigs.put(String.format(QUARKUS_NAMED_DATASOURCE_JDBC_URL, key), String.format(DEFAULT_JDBC_URL, this.startupInfo.getPort(), value));
            allConfigs.put(String.format(QUARKUS_NAMED_DATASOURCE_USERNAME, key), "postgres");
            allConfigs.put(String.format(QUARKUS_NAMED_DATASOURCE_PASSWORD, key), "postgres");
        });
        allConfigs.put(QUARKUS_DATASOURCE_REACTIVE_URL, String.format(DEFAULT_REACTIVE_URL, this.startupInfo.getPort(), "postgres"));
        allConfigs.put(QUARKUS_DATASOURCE_JDBC_URL, String.format(DEFAULT_JDBC_URL, this.startupInfo.getPort(), "postgres"));
        allConfigs.put(QUARKUS_DATASOURCE_USERNAME, "postgres");
        allConfigs.put(QUARKUS_DATASOURCE_PASSWORD, "postgres");
        return Collections.singleton(new EmbeddedPostgreSQLConfigSource(allConfigs));
    }
}

