/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.embedded.postgresql;

import io.quarkiverse.embedded.postgresql.EmbeddedPostgreSQLConfigSourceProvider;
import io.quarkiverse.embedded.postgresql.PostgreSQLSyntaxUtils;
import io.quarkiverse.embedded.postgresql.StartupInfo;
import io.quarkus.datasource.runtime.DataSourceBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourcesBuildTimeConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.zonky.test.db.postgres.embedded.EmbeddedPostgres;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.jboss.logging.Logger;

@Recorder
public class EmbeddedPostgreSQLRecorder {
    private static final Logger logger = Logger.getLogger(EmbeddedPostgreSQLRecorder.class);

    public RuntimeValue<StartupInfo> startPostgres(ShutdownContext shutdownContext, DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig) throws IOException {
        EmbeddedPostgres.Builder builder = EmbeddedPostgres.builder();
        Config config = ConfigProvider.getConfig();
        config.getOptionalValue("quarkus.embedded.postgresql.port", Integer.class).ifPresent(port -> {
            logger.infov("PG port will be set to {0}", port);
            builder.setPort(port.intValue());
        });
        builder.setConnectConfig("stringtype", config.getOptionalValue("quarkus.embedded.postgresql.stringtype", String.class).orElse("unspecified"));
        config.getOptionalValue("quarkus.embedded.postgresql.startup.wait", Long.class).ifPresent(timeout -> {
            logger.infov("PG startup timeout set to {0}", timeout);
            builder.setPGStartupWait(Duration.ofMillis(timeout));
        });
        config.getOptionalValue("quarkus.embedded.postgresql.data.dir", String.class).ifPresent(path -> {
            logger.infov("Setting embedded postgresql data dir to {0}", path);
            builder.setDataDirectory(path);
            builder.setCleanDataDirectory(false);
        });
        EmbeddedPostgres pg = builder.start();
        logger.infov("Embedded Postgres started at port \"{0,number,#}\" with database \"{1}\", user \"{2}\" and password \"{3}\"", new Object[]{pg.getPort(), "postgres", "postgres", "postgres"});
        shutdownContext.addShutdownTask(() -> {
            try {
                pg.close();
            }
            catch (IOException e) {
                logger.warn((Object)"Error shutting down embedded postgres", (Throwable)e);
            }
        });
        return new RuntimeValue((Object)new StartupInfo(pg.getPort(), this.createDatabases(pg, dataSourcesBuildTimeConfig, "postgres")));
    }

    private Map<String, String> createDatabases(EmbeddedPostgres pg, DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig, String userName) {
        pg.getDatabase("postgres", "postgres");
        return dataSourcesBuildTimeConfig.namedDataSources.entrySet().stream().filter(ds -> Objects.equals(((DataSourceBuildTimeConfig)ds.getValue()).dbKind.get(), "postgresql")).map(Map.Entry::getKey).map(ds -> Map.entry(ds, this.createDatabase(pg.getPostgresDatabase(), (String)ds, userName))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String createDatabase(DataSource dataSource, String dbName, String userName) {
        Objects.requireNonNull(dbName);
        Objects.requireNonNull(userName);
        String sanitizedDbName = PostgreSQLSyntaxUtils.sanitizeDbName(dbName);
        String createDbStatement = String.format("SELECT 'CREATE DATABASE %s OWNER %s' as createQuery WHERE NOT EXISTS (SELECT FROM pg_database WHERE datname = '%s')", sanitizedDbName, userName, sanitizedDbName);
        try (Connection connection = dataSource.getConnection();){
            String string;
            block15: {
                Statement stmt = connection.createStatement();
                try {
                    ResultSet result = stmt.executeQuery(createDbStatement);
                    if (result.next()) {
                        stmt.executeUpdate(result.getString("createQuery"));
                    }
                    string = sanitizedDbName;
                    if (stmt == null) break block15;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return string;
        }
        catch (SQLException e) {
            throw new IllegalStateException("Error creating DB " + dbName, e);
        }
    }

    public RuntimeValue<ConfigSourceProvider> configSources(RuntimeValue<StartupInfo> info) {
        return new RuntimeValue((Object)new EmbeddedPostgreSQLConfigSourceProvider((StartupInfo)info.getValue()));
    }
}

