/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.embedded.postgresql;

import io.quarkiverse.embedded.postgresql.PostgreSQLSyntaxUtils;
import io.quarkus.datasource.runtime.DataSourceBuildTimeConfig;
import io.quarkus.datasource.runtime.DataSourcesBuildTimeConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class EmbeddedPostgreSQLConfigUtils {
    private static final String QUARKUS_DATASOURCE_REACTIVE_URL = "quarkus.datasource.reactive.url";
    private static final String QUARKUS_DATASOURCE_JDBC_URL = "quarkus.datasource.jdbc.url";
    private static final String QUARKUS_NAMED_DATASOURCE_REACTIVE_URL = "quarkus.datasource.\"%s\".reactive.url";
    private static final String QUARKUS_NAMED_DATASOURCE_JDBC_URL = "quarkus.datasource.\"%s\".jdbc.url";
    private static final String QUARKUS_DATASOURCE_USERNAME = "quarkus.datasource.username";
    private static final String QUARKUS_DATASOURCE_PASSWORD = "quarkus.datasource.password";
    private static final String QUARKUS_NAMED_DATASOURCE_USERNAME = "quarkus.datasource.\"%s\".username";
    private static final String QUARKUS_NAMED_DATASOURCE_PASSWORD = "quarkus.datasource.\"%s\".password";
    public static final String DEFAULT_DATABASE = "postgres";
    public static final String DEFAULT_REACTIVE_URL = "postgresql://localhost:%d/%s?stringtype=unspecified";
    public static final String DEFAULT_JDBC_URL = "jdbc:postgresql://localhost:%d/%s?stringtype=unspecified";
    public static final String DEFAULT_USERNAME = "postgres";
    public static final String DEFAULT_PASSWORD = "postgres";
    private static final int START_PORT = 5432;

    public static Map<String, String> getConfig(int port, Map<String, String> dbNames) {
        HashMap<String, String> allConfigs = new HashMap<String, String>();
        dbNames.forEach((key, value) -> {
            allConfigs.put(String.format(QUARKUS_NAMED_DATASOURCE_REACTIVE_URL, key), String.format(DEFAULT_REACTIVE_URL, port, value));
            allConfigs.put(String.format(QUARKUS_NAMED_DATASOURCE_JDBC_URL, key), String.format(DEFAULT_JDBC_URL, port, value));
            allConfigs.put(String.format(QUARKUS_NAMED_DATASOURCE_USERNAME, key), "postgres");
            allConfigs.put(String.format(QUARKUS_NAMED_DATASOURCE_PASSWORD, key), "postgres");
        });
        allConfigs.put(QUARKUS_DATASOURCE_REACTIVE_URL, String.format(DEFAULT_REACTIVE_URL, port, "postgres"));
        allConfigs.put(QUARKUS_DATASOURCE_JDBC_URL, String.format(DEFAULT_JDBC_URL, port, "postgres"));
        allConfigs.put(QUARKUS_DATASOURCE_USERNAME, "postgres");
        allConfigs.put(QUARKUS_DATASOURCE_PASSWORD, "postgres");
        return allConfigs;
    }

    public static Integer getDefaultPort() {
        return (int)Math.round(Math.random() * 10.0) + 5432;
    }

    public static Map<String, String> getDBNames(DataSourcesBuildTimeConfig dataSourcesBuildTimeConfig) {
        return dataSourcesBuildTimeConfig.dataSources().entrySet().stream().filter(e -> !((String)e.getKey()).equals("<default>")).filter(ds -> ((DataSourceBuildTimeConfig)ds.getValue()).dbKind().filter(kind -> kind.equals("postgresql")).isPresent()).map(Map.Entry::getKey).collect(Collectors.toMap(e -> e, PostgreSQLSyntaxUtils::sanitizeDbName));
    }

    private EmbeddedPostgreSQLConfigUtils() {
    }
}

