/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.freemarker.deployment;

import freemarker.ext.jython.JythonModel;
import freemarker.ext.jython.JythonWrapper;
import io.quarkiverse.freemarker.TemplatePath;
import io.quarkiverse.freemarker.deployment.TemplateSetBuildItem;
import io.quarkiverse.freemarker.runtime.FreemarkerBuildConfig;
import io.quarkiverse.freemarker.runtime.FreemarkerBuildConfigSupport;
import io.quarkiverse.freemarker.runtime.FreemarkerConfigurationProducer;
import io.quarkiverse.freemarker.runtime.FreemarkerRecorder;
import io.quarkiverse.freemarker.runtime.FreemarkerTemplateProducer;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourcePatternsBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Singleton;
import org.jboss.logging.Logger;

public class FreemarkerProcessor {
    private static final Logger LOGGER = Logger.getLogger(FreemarkerProcessor.class);
    private static final String FEATURE = "freemarker";
    private static final String CLASSPATH_PROTOCOL = "classpath";

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void runtimeInit(BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitialized) {
        Stream.of(JythonWrapper.class, JythonModel.class).map(Class::getName).map(RuntimeInitializedClassBuildItem::new).forEach(arg_0 -> runtimeInitialized.produce(arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @BuildStep
    void discoverTemplates(BuildProducer<TemplateSetBuildItem> templateSets, FreemarkerBuildConfig config) {
        if (config.resourcePaths.isPresent()) {
            for (String string : (List)config.resourcePaths.get()) {
                void var4_4;
                if (string.startsWith("classpath:")) {
                    String string2 = string.substring(CLASSPATH_PROTOCOL.length() + 1);
                }
                templateSets.produce((BuildItem)TemplateSetBuildItem.builder().basePath((String)var4_4).includeGlob("**").build());
            }
        }
        if (!config.resourcePaths.isPresent() && !config.defaultTemplateSet.isSetByUser()) {
            templateSets.produce((BuildItem)TemplateSetBuildItem.builder().basePath("freemarker/templates").includeGlob("**").build());
        }
        if (config.defaultTemplateSet.isSetByUser()) {
            templateSets.produce((BuildItem)FreemarkerProcessor.toBuildItem(config.defaultTemplateSet.assertValid(null)));
        }
        for (Map.Entry entry : config.namedTemplateSets.entrySet()) {
            templateSets.produce((BuildItem)FreemarkerProcessor.toBuildItem(((FreemarkerBuildConfig.TemplateSet)entry.getValue()).assertValid((String)entry.getKey())));
        }
    }

    static TemplateSetBuildItem toBuildItem(FreemarkerBuildConfig.TemplateSet templateSet) {
        TemplateSetBuildItem.Builder builder = TemplateSetBuildItem.builder();
        templateSet.basePath.ifPresent(builder::basePath);
        templateSet.includes.ifPresent(builder::includeGlobs);
        templateSet.excludes.ifPresent(builder::excludeGlobs);
        return builder.build();
    }

    @BuildStep
    void nativeResources(List<TemplateSetBuildItem> templateSets, BuildProducer<NativeImageResourcePatternsBuildItem> nativeImageResources) {
        for (TemplateSetBuildItem templateSet : templateSets) {
            NativeImageResourcePatternsBuildItem.Builder builder = NativeImageResourcePatternsBuildItem.builder();
            templateSet.getIncludeGlobs().stream().map(templateSet::resolve).forEach(arg_0 -> ((NativeImageResourcePatternsBuildItem.Builder)builder).includeGlob(arg_0));
            templateSet.getExcludeGlobs().stream().map(templateSet::resolve).forEach(arg_0 -> ((NativeImageResourcePatternsBuildItem.Builder)builder).excludeGlob(arg_0));
            nativeImageResources.produce((BuildItem)builder.build());
        }
    }

    @BuildStep
    AdditionalBeanBuildItem additionalBeans() {
        return AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(new Class[]{FreemarkerConfigurationProducer.class, TemplatePath.class, FreemarkerTemplateProducer.class}).build();
    }

    @BuildStep
    public void reflection(BuildProducer<ReflectiveClassBuildItem> reflectiveClassBuildItemProducer, FreemarkerBuildConfig config) {
        LOGGER.debugf("Adding directives: %s", config.directives.values());
        config.directives.values().stream().map(classname -> new ReflectiveClassBuildItem(false, false, new String[]{classname})).forEach(arg_0 -> reflectiveClassBuildItemProducer.produce(arg_0));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    SyntheticBeanBuildItem pushConfigurationBean(FreemarkerRecorder recorder, List<TemplateSetBuildItem> templateSets, FreemarkerBuildConfig buildConfig) {
        List resourcePaths = templateSets.stream().map(TemplateSetBuildItem::getBasePath).map(basePath -> basePath.orElse("")).collect(Collectors.toList());
        return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(FreemarkerBuildConfigSupport.class).scope(Singleton.class)).supplier(recorder.freemarkerBuildConfigSupport(resourcePaths, buildConfig.directives)).done();
    }
}

