/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.fx;

import io.quarkiverse.fx.FxStartupLatch;
import io.quarkiverse.fx.RunOnFxThread;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import javafx.application.Platform;
import org.jboss.logging.Logger;

@Interceptor
@Priority(value=2000)
@RunOnFxThread
public class RunOnFxThreadInterceptor {
    private static final Logger LOGGER = Logger.getLogger(RunOnFxThreadInterceptor.class);
    @Inject
    FxStartupLatch startupLatch;

    @AroundInvoke
    public Object runOnFxThread(InvocationContext ctx) throws Exception {
        LOGGER.tracef("intercepted %s on thread %s", (Object)ctx.getMethod(), (Object)Thread.currentThread());
        this.startupLatch.await();
        if (Platform.isFxApplicationThread()) {
            return ctx.proceed();
        }
        Platform.runLater(() -> {
            try {
                ctx.proceed();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return null;
    }
}

