/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.fx.style;

import io.quarkus.logging.Log;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.collections.ObservableList;

public final class StylesheetWatchService {
    private StylesheetWatchService() {
    }

    public static void setStyleAndStartWatchingTask(Supplier<ObservableList<String>> stylesheetsSupplier, String stylesheet) throws IOException {
        Path path = Path.of(stylesheet, new String[0]);
        URL url = path.toUri().toURL();
        WatchService watchService = FileSystems.getDefault().newWatchService();
        path.getParent().register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
        ObservableList<String> stylesheets = stylesheetsSupplier.get();
        String stylesheetExternalForm = url.toExternalForm();
        StylesheetWatchService.updateWithStylesheet(stylesheetExternalForm, stylesheets);
        CompletableFuture.runAsync(() -> {
            try {
                StylesheetWatchService.performBlockingWatch(watchService, stylesheets, stylesheetExternalForm);
            }
            catch (InterruptedException e) {
                Log.error((Object)"Stylesheet file watch got interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        });
    }

    private static void performBlockingWatch(WatchService watchService, ObservableList<String> stylesheets, String stylesheet) throws InterruptedException {
        WatchKey key;
        while ((key = watchService.take()) != null) {
            for (WatchEvent<?> event : key.pollEvents()) {
                StylesheetWatchService.updateWithStylesheet(stylesheet, stylesheets);
            }
            key.reset();
        }
    }

    private static void updateWithStylesheet(String stylesheet, ObservableList<String> stylesheets) {
        Platform.runLater(() -> stylesheets.setAll((Object[])new String[]{stylesheet}));
    }
}

