/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.fx.views;

import io.quarkiverse.fx.FxViewLoadEvent;
import io.quarkiverse.fx.style.StylesheetWatchService;
import io.quarkiverse.fx.views.FxViewConfig;
import io.quarkiverse.fx.views.FxViewData;
import io.quarkiverse.fx.views.StylesheetReloadStrategy;
import io.quarkus.runtime.LaunchMode;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import javafx.collections.ObservableList;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Dialog;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.jboss.logging.Logger;

@ApplicationScoped
public class FxViewRepository {
    private static final String FXML_EXT = ".fxml";
    private static final Logger LOGGER = Logger.getLogger(FxViewRepository.class);
    @Inject
    Instance<FXMLLoader> fxmlLoader;
    @Inject
    FxViewConfig config;
    private final Map<String, FxViewData> viewDataMap = new HashMap<String, FxViewData>();
    private List<String> viewNames;
    private Stage primaryStage;

    public void setViewNames(List<String> views) {
        this.viewNames = views;
    }

    void setupViews(@Observes FxViewLoadEvent event) {
        this.primaryStage = event.getPrimaryStage();
        if (this.viewNames.isEmpty()) {
            return;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        boolean stylesheetReload = switch (this.config.stylesheetReloadStrategy()) {
            default -> throw new IncompatibleClassChangeError();
            case StylesheetReloadStrategy.NEVER -> false;
            case StylesheetReloadStrategy.ALWAYS -> true;
            case StylesheetReloadStrategy.DEV -> LaunchMode.current() == LaunchMode.DEVELOPMENT;
        };
        for (String name : this.viewNames) {
            this.manageView(name, classLoader, stylesheetReload);
        }
    }

    private void manageView(String name, ClassLoader classLoader, boolean stylesheetReload) {
        ResourceBundle bundle;
        FXMLLoader loader = (FXMLLoader)this.fxmlLoader.get();
        Object viewsRoot = this.config.viewsRoot();
        if (!((String)viewsRoot).endsWith("/")) {
            viewsRoot = (String)viewsRoot + "/";
        }
        String fxml = (String)viewsRoot + name + FXML_EXT;
        String resources = (String)viewsRoot + name;
        try {
            LOGGER.debugf("Attempting to load resource bundle %s", (Object)resources);
            bundle = ResourceBundle.getBundle(resources, Locale.getDefault(), classLoader);
            LOGGER.debugf("Found resource bundle %s", (Object)bundle);
        }
        catch (MissingResourceException e) {
            String alternateResources = resources + "." + name;
            try {
                LOGGER.debugf("Attempting to load resource bundle %s", (Object)alternateResources);
                bundle = ResourceBundle.getBundle(alternateResources, Locale.getDefault(), classLoader);
                LOGGER.debugf("Found resource bundle %s", (Object)bundle);
            }
            catch (MissingResourceException ee) {
                bundle = null;
                LOGGER.debugf("No resource bundle found for %s", (Object)name);
            }
        }
        LOGGER.debugf("Loading FXML %s", (Object)fxml);
        InputStream stream = FxViewRepository.lookupResourceAsStream(classLoader, fxml);
        if (stream == null) {
            String alternateFxml = (String)viewsRoot + name + "/" + name + FXML_EXT;
            stream = FxViewRepository.lookupResourceAsStream(classLoader, alternateFxml);
            Objects.requireNonNull(stream, "FXML " + fxml + " not found in classpath.");
        }
        try {
            URL url;
            if (bundle != null) {
                loader.setResources(bundle);
            }
            if ((url = FxViewRepository.lookupResource(classLoader, (String)viewsRoot)) == null) {
                throw new IllegalStateException("Failed to find FXML viewsRoot location : " + (String)viewsRoot);
            }
            loader.setLocation(url);
            Object rootNode = loader.load(stream);
            if (stylesheetReload) {
                this.manageStylesheetLiveReload(rootNode);
            }
            Object controller = loader.getController();
            FxViewData viewData = FxViewData.of(rootNode, controller);
            this.viewDataMap.put(name, viewData);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load FX view " + name, e);
        }
    }

    private void manageStylesheetLiveReload(Object rootNode) throws IOException {
        ObservableList<String> styleSheets = FxViewRepository.getFxmlObjectStyleSheets(rootNode);
        if (!styleSheets.isEmpty()) {
            String targetMarker = this.config.targetResources();
            for (String styleSheet : styleSheets) {
                int targetIndex = styleSheet.indexOf(targetMarker);
                if (targetIndex != -1) {
                    String relativePath = styleSheet.substring(targetIndex + targetMarker.length());
                    String sourcesPath = this.config.sourceResources() + relativePath;
                    LOGGER.debugf("Stylesheet live reload : substituting '%s' with '%s'", (Object)styleSheet, (Object)sourcesPath);
                    StylesheetWatchService.setStyleAndStartWatchingTask(() -> styleSheets, sourcesPath);
                    continue;
                }
                LOGGER.errorf("Could not find '%s' in the stylesheet file path '%s'", (Object)targetMarker, (Object)styleSheet);
            }
        }
    }

    private static URL lookupResource(ClassLoader classLoader, String name) {
        URL url = classLoader.getResource(name);
        if (url == null) {
            url = FxViewRepository.class.getResource(name);
        }
        return url;
    }

    private static InputStream lookupResourceAsStream(ClassLoader classLoader, String name) {
        InputStream stream = classLoader.getResourceAsStream(name);
        if (stream == null) {
            stream = FxViewRepository.class.getResourceAsStream(name);
        }
        return stream;
    }

    private static ObservableList<String> getFxmlObjectStyleSheets(Object rootNode) {
        ObservableList stylesheets;
        if (rootNode instanceof Parent) {
            Parent p = (Parent)rootNode;
            stylesheets = p.getStylesheets();
        } else if (rootNode instanceof Window) {
            Window w = (Window)rootNode;
            stylesheets = w.getScene().getStylesheets();
        } else if (rootNode instanceof Scene) {
            Scene s = (Scene)rootNode;
            stylesheets = s.getStylesheets();
        } else if (rootNode instanceof Dialog) {
            Dialog d = (Dialog)rootNode;
            stylesheets = d.getDialogPane().getStylesheets();
        } else {
            String message = "rootNode shall be a valid UI root component (Parent, Window, Scene or Dialog)";
            throw new IllegalArgumentException(message);
        }
        return stylesheets;
    }

    public FxViewData getViewData(String viewName) {
        return this.viewDataMap.get(viewName);
    }

    public Stage getPrimaryStage() {
        return this.primaryStage;
    }
}

