/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.command.airline.deployment;

import io.quarkiverse.githubapp.command.airline.deployment.GitHubAppCommandAirlineDotNames;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Transformation;
import java.util.Set;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

public class HideAirlineInjectAnnotationsTransformer
implements AnnotationsTransformer {
    private final IndexView index;

    HideAirlineInjectAnnotationsTransformer(IndexView index) {
        this.index = index;
    }

    public boolean appliesTo(AnnotationTarget.Kind kind) {
        return AnnotationTarget.Kind.FIELD == kind;
    }

    public void transform(AnnotationsTransformer.TransformationContext transformationContext) {
        FieldInfo fieldInfo = transformationContext.getTarget().asField();
        if (!fieldInfo.hasAnnotation(DotNames.INJECT)) {
            return;
        }
        if (!(fieldInfo.hasAnnotation(GitHubAppCommandAirlineDotNames.ARGUMENTS) || fieldInfo.hasAnnotation(GitHubAppCommandAirlineDotNames.OPTION) || GitHubAppCommandAirlineDotNames.GLOBAL_METADATA.equals((Object)fieldInfo.type().name()) || GitHubAppCommandAirlineDotNames.COMMAND_GROUP_METADATA.equals((Object)fieldInfo.type().name()) || GitHubAppCommandAirlineDotNames.COMMAND_METADATA.equals((Object)fieldInfo.type().name()) || this.isComposition(fieldInfo))) {
            return;
        }
        ((Transformation)transformationContext.transform().remove(ai -> DotNames.INJECT.equals((Object)ai.name()))).done();
    }

    private boolean isComposition(FieldInfo fieldInfo) {
        Type fieldType = fieldInfo.type();
        if (fieldType.kind() != Type.Kind.CLASS) {
            return false;
        }
        ClassInfo fieldClass = this.index.getClassByName(fieldType.asClassType().name());
        if (fieldClass == null) {
            return false;
        }
        Set fieldClassAnnotations = fieldClass.annotationsMap().keySet();
        return fieldClassAnnotations.contains(GitHubAppCommandAirlineDotNames.ARGUMENTS) || fieldClassAnnotations.contains(GitHubAppCommandAirlineDotNames.OPTION);
    }
}

