/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.command.airline.deployment;

import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;

class IndexedGeneratedBeansBuildProducer
implements BuildProducer<GeneratedBeanBuildItem> {
    private final BuildProducer<GeneratedBeanBuildItem> delegate;
    private final Indexer indexer;
    private boolean empty = true;

    public IndexedGeneratedBeansBuildProducer(BuildProducer<GeneratedBeanBuildItem> delegate) {
        this.delegate = delegate;
        this.indexer = new Indexer();
    }

    public void produce(GeneratedBeanBuildItem generatedBean) {
        this.delegate.produce((BuildItem)generatedBean);
        try {
            this.indexer.index((InputStream)new ByteArrayInputStream(generatedBean.getData()));
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to index generated class " + generatedBean.getName());
        }
        this.empty = false;
    }

    public IndexView getIndex() {
        return this.indexer.complete();
    }

    public boolean isEmpty() {
        return this.empty;
    }
}

