/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.command.airline.deployment;

import io.quarkiverse.githubapp.command.airline.CliOptions;
import io.quarkiverse.githubapp.command.airline.CommandOptions;
import io.quarkiverse.githubapp.command.airline.ExecutionErrorHandler;
import io.quarkiverse.githubapp.command.airline.ParseErrorHandler;
import io.quarkiverse.githubapp.command.airline.deployment.GitHubAppCommandAirlineDotNames;
import io.quarkiverse.githubapp.command.airline.deployment.HideAirlineInjectAnnotationsTransformer;
import io.quarkiverse.githubapp.command.airline.deployment.IndexedGeneratedBeansBuildProducer;
import io.quarkiverse.githubapp.command.airline.runtime.AbstractCommandDispatcher;
import io.quarkiverse.githubapp.command.airline.runtime.CliConfig;
import io.quarkiverse.githubapp.command.airline.runtime.CommandConfig;
import io.quarkiverse.githubapp.command.airline.runtime.CommandExecutionException;
import io.quarkiverse.githubapp.command.airline.runtime.CommandPermissionConfig;
import io.quarkiverse.githubapp.command.airline.runtime.CommandTeamConfig;
import io.quarkiverse.githubapp.command.airline.runtime.DefaultExecutionErrorHandler;
import io.quarkiverse.githubapp.command.airline.runtime.DefaultParseErrorHandler;
import io.quarkiverse.githubapp.command.airline.runtime.util.Reactions;
import io.quarkiverse.githubapp.deployment.AdditionalEventDispatchingClassesIndexBuildItem;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.kohsuke.github.GHEventPayload;
import org.kohsuke.github.GHIssueComment;
import org.kohsuke.github.GHPermissionType;
import org.kohsuke.github.GHReaction;
import org.kohsuke.github.ReactionContent;

class GitHubAppCommandAirlineProcessor {
    private static final String FEATURE = "github-app-command-airline";
    private static final String RUN_METHOD = "run";

    GitHubAppCommandAirlineProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    public void beanConfig(CombinedIndexBuildItem index, BuildProducer<BeanDefiningAnnotationBuildItem> beanDefiningAnnotations, BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformer, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<UnremovableBeanBuildItem> unremovableBeans) {
        beanDefiningAnnotations.produce((BuildItem)new BeanDefiningAnnotationBuildItem(GitHubAppCommandAirlineDotNames.COMMAND, GitHubAppCommandAirlineDotNames.DEPENDENT));
        annotationsTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem((AnnotationsTransformer)new HideAirlineInjectAnnotationsTransformer(index.getIndex())));
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{DefaultExecutionErrorHandler.class, DefaultParseErrorHandler.class}));
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{ExecutionErrorHandler.class, ParseErrorHandler.class}));
    }

    @BuildStep
    public void indexAnnotations(BuildProducer<AdditionalIndexedClassesBuildItem> additionalIndexedClasses) {
        additionalIndexedClasses.produce((BuildItem)new AdditionalIndexedClassesBuildItem(new String[]{GitHubAppCommandAirlineDotNames.CLI_OPTIONS.toString(), GitHubAppCommandAirlineDotNames.COMMAND_OPTIONS.toString()}));
        additionalIndexedClasses.produce((BuildItem)new AdditionalIndexedClassesBuildItem(Runnable.class.getName()));
    }

    @BuildStep
    public void generate(CombinedIndexBuildItem index, BuildProducer<AdditionalEventDispatchingClassesIndexBuildItem> additionalEventDispatchingClassesIndexes, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<GeneratedBeanBuildItem> generatedBeans) {
        GitHubAppCommandAirlineProcessor.validate(index.getIndex());
        IndexedGeneratedBeansBuildProducer indexedGeneratedBeans = new IndexedGeneratedBeansBuildProducer(generatedBeans);
        GeneratedBeanGizmoAdaptor classOutput = new GeneratedBeanGizmoAdaptor((BuildProducer)indexedGeneratedBeans);
        for (AnnotationInstance cliAnnotationInstance : index.getIndex().getAnnotations(GitHubAppCommandAirlineDotNames.CLI)) {
            List<String> aliases = GitHubAppCommandAirlineProcessor.getAliases(cliAnnotationInstance);
            Map<DotName, ClassInfo> allCommands = GitHubAppCommandAirlineProcessor.getAllCommands(index.getIndex(), cliAnnotationInstance);
            for (ClassInfo commandClassInfo : allCommands.values()) {
                reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{commandClassInfo.toString()}));
            }
            GitHubAppCommandAirlineProcessor.generateCommandDispatcher(index.getIndex(), (ClassOutput)classOutput, cliAnnotationInstance, aliases, GitHubAppCommandAirlineProcessor.findCommonInterfaceWithRunMethod(index.getIndex(), aliases.get(0), allCommands.values()), allCommands.values());
        }
        if (!indexedGeneratedBeans.isEmpty()) {
            additionalEventDispatchingClassesIndexes.produce((BuildItem)new AdditionalEventDispatchingClassesIndexBuildItem(indexedGeneratedBeans.getIndex()));
        }
    }

    private static void validate(IndexView index) {
        Set nonStaticNestedCommandClasses = index.getAnnotations(GitHubAppCommandAirlineDotNames.COMMAND).stream().filter(ai -> ai.target().kind() == AnnotationTarget.Kind.CLASS).map(ai -> ai.target().asClass()).filter(ci -> ci.enclosingClass() != null && !Modifier.isStatic(ci.flags())).map(ci -> ci.name().toString()).collect(Collectors.toCollection(TreeSet::new));
        if (!nonStaticNestedCommandClasses.isEmpty()) {
            throw new IllegalStateException("Nested classes marked with @Command must be made static. Offending classes: " + String.join((CharSequence)", ", nonStaticNestedCommandClasses));
        }
    }

    private static void generateCommandDispatcher(IndexView index, ClassOutput classOutput, AnnotationInstance cliAnnotationInstance, List<String> aliases, RunMethod runMethod, Collection<ClassInfo> allCommands) {
        ClassInfo cliClassInfo = cliAnnotationInstance.target().asClass();
        String commandDispatcherClassName = String.valueOf(cliClassInfo.name()) + "CommandDispatcherImpl";
        ClassCreator commandDispatcherClassCreator = ClassCreator.builder().classOutput(classOutput).className(commandDispatcherClassName).superClass(AbstractCommandDispatcher.class).build();
        GitHubAppCommandAirlineProcessor.generateCommandDispatcherConstructor(commandDispatcherClassCreator, commandDispatcherClassName, index, cliClassInfo, aliases);
        GitHubAppCommandAirlineProcessor.generateCommandDispatcherGetCommandConfigsMethod(commandDispatcherClassCreator, index, allCommands);
        GitHubAppCommandAirlineProcessor.generateCommandDispatcherGetCommandPermissionConfigsMethod(commandDispatcherClassCreator, allCommands);
        GitHubAppCommandAirlineProcessor.generateCommandDispatcherGetCommandTeamConfigsMethod(commandDispatcherClassCreator, allCommands);
        GitHubAppCommandAirlineProcessor.generateCommandDispatcherDispatchMethod(commandDispatcherClassCreator, runMethod);
        commandDispatcherClassCreator.close();
    }

    private static void generateCommandDispatcherDispatchMethod(ClassCreator commandDispatcherClassCreator, RunMethod runMethod) {
        List originalMethodParameterTypes = runMethod.getMethod().parameterTypes();
        Map<Short, List<AnnotationInstance>> originalMethodParameterAnnotationMapping = runMethod.getMethod().annotations().stream().filter(ai -> ai.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER).collect(Collectors.groupingBy(ai -> ai.target().asMethodParameter().position()));
        short issueCommentPayloadPosition = -1;
        boolean originalMethodHasIssueCommentPayloadParameter = false;
        for (short i = 0; i < originalMethodParameterTypes.size(); i = (short)((short)(i + 1))) {
            if (!GitHubAppCommandAirlineDotNames.GH_EVENT_PAYLOAD_ISSUE_COMMENT.equals((Object)((Type)originalMethodParameterTypes.get(i)).name())) continue;
            issueCommentPayloadPosition = i;
            originalMethodHasIssueCommentPayloadParameter = true;
        }
        ArrayList<String> parameterTypes = new ArrayList<String>();
        originalMethodParameterTypes.stream().map(t -> t.name().toString()).forEach(parameterTypes::add);
        if (!originalMethodHasIssueCommentPayloadParameter) {
            parameterTypes.add(GitHubAppCommandAirlineDotNames.GH_EVENT_PAYLOAD_ISSUE_COMMENT.toString());
            issueCommentPayloadPosition = (short)(parameterTypes.size() - 1);
        }
        MethodCreator dispatchMethodCreator = commandDispatcherClassCreator.getMethodCreator("dispatch", (Object)Void.TYPE.getName(), parameterTypes.toArray());
        for (short i = 0; i < originalMethodParameterTypes.size(); i = (short)(i + 1)) {
            List annotations = originalMethodParameterAnnotationMapping.getOrDefault(i, Collections.emptyList());
            if (i == issueCommentPayloadPosition) {
                dispatchMethodCreator.getParameterAnnotations((int)i).addAnnotation(GitHubAppCommandAirlineDotNames.ISSUE_COMMENT_CREATED.toString());
                continue;
            }
            for (AnnotationInstance annotation : annotations) {
                dispatchMethodCreator.getParameterAnnotations((int)i).addAnnotation(annotation);
            }
        }
        if (!originalMethodHasIssueCommentPayloadParameter) {
            dispatchMethodCreator.getParameterAnnotations((int)issueCommentPayloadPosition).addAnnotation(GitHubAppCommandAirlineDotNames.ISSUE_COMMENT_CREATED.toString());
        }
        ResultHandle issueCommentPayloadRh = dispatchMethodCreator.getMethodParam((int)issueCommentPayloadPosition);
        ResultHandle commandExecutionContextOptional = dispatchMethodCreator.invokeSpecialMethod(MethodDescriptor.ofMethod(AbstractCommandDispatcher.class, (String)"getCommand", Optional.class, (Class[])new Class[]{GHEventPayload.IssueComment.class}), dispatchMethodCreator.getThis(), new ResultHandle[]{issueCommentPayloadRh});
        BranchResult commandExecutionContextOptionalIsPresent = dispatchMethodCreator.ifTrue(dispatchMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(Optional.class, (String)"isPresent", Boolean.TYPE, (Class[])new Class[0]), commandExecutionContextOptional, new ResultHandle[0]));
        commandExecutionContextOptionalIsPresent.falseBranch().returnValue(null);
        BytecodeCreator commandExecutionContextOptionalIsPresentTrue = commandExecutionContextOptionalIsPresent.trueBranch();
        ResultHandle commandExecutionContextRh = commandExecutionContextOptionalIsPresentTrue.invokeVirtualMethod(MethodDescriptor.ofMethod(Optional.class, (String)"get", Object.class, (Class[])new Class[0]), commandExecutionContextOptional, new ResultHandle[0]);
        ResultHandle commandRh = commandExecutionContextOptionalIsPresentTrue.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractCommandDispatcher.CommandExecutionContext.class, (String)"getCommand", Object.class, (Class[])new Class[0]), commandExecutionContextRh, new ResultHandle[0]);
        ResultHandle ackReactionRh = commandExecutionContextOptionalIsPresentTrue.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractCommandDispatcher.CommandExecutionContext.class, (String)"getAckReaction", GHReaction.class, (Class[])new Class[0]), commandExecutionContextRh, new ResultHandle[0]);
        ResultHandle reactionStrategyRh = commandExecutionContextOptionalIsPresentTrue.invokeVirtualMethod(MethodDescriptor.ofMethod(CommandConfig.class, (String)"getReactionStrategy", CommandOptions.ReactionStrategy.class, (Class[])new Class[0]), commandExecutionContextOptionalIsPresentTrue.invokeVirtualMethod(MethodDescriptor.ofMethod(AbstractCommandDispatcher.CommandExecutionContext.class, (String)"getCommandConfig", CommandConfig.class, (Class[])new Class[0]), commandExecutionContextRh, new ResultHandle[0]), new ResultHandle[0]);
        TryBlock tryBlock = commandExecutionContextOptionalIsPresentTrue.tryBlock();
        ArrayList<ResultHandle> runMethodParameters = new ArrayList<ResultHandle>();
        for (int i = 0; i < originalMethodParameterTypes.size(); ++i) {
            runMethodParameters.add(commandExecutionContextOptionalIsPresentTrue.getMethodParam(i));
        }
        tryBlock.invokeInterfaceMethod(runMethod.getMethod(), commandRh, runMethodParameters.toArray(new ResultHandle[0]));
        GitHubAppCommandAirlineProcessor.deleteReaction((BytecodeCreator)tryBlock, issueCommentPayloadRh, ackReactionRh);
        BranchResult reactionOnNormalFlow = tryBlock.ifTrue(tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(CommandOptions.ReactionStrategy.class, (String)"reactionOnNormalFlow", Boolean.TYPE, (Class[])new Class[0]), reactionStrategyRh, new ResultHandle[0]));
        GitHubAppCommandAirlineProcessor.createReaction(reactionOnNormalFlow.trueBranch(), issueCommentPayloadRh, ReactionContent.PLUS_ONE);
        CatchBlockCreator catchBlock = tryBlock.addCatch(Exception.class);
        GitHubAppCommandAirlineProcessor.deleteReaction((BytecodeCreator)catchBlock, issueCommentPayloadRh, ackReactionRh);
        BranchResult reactionOnError = catchBlock.ifTrue(catchBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(CommandOptions.ReactionStrategy.class, (String)"reactionOnError", Boolean.TYPE, (Class[])new Class[0]), reactionStrategyRh, new ResultHandle[0]));
        GitHubAppCommandAirlineProcessor.createReaction(reactionOnError.trueBranch(), issueCommentPayloadRh, ReactionContent.MINUS_ONE);
        catchBlock.invokeSpecialMethod(MethodDescriptor.ofMethod(AbstractCommandDispatcher.class, (String)"handleExecutionError", Void.TYPE, (Class[])new Class[]{GHEventPayload.IssueComment.class, AbstractCommandDispatcher.CommandExecutionContext.class, Exception.class}), catchBlock.getThis(), new ResultHandle[]{issueCommentPayloadRh, commandExecutionContextRh, catchBlock.getCaughtException()});
        catchBlock.throwException(catchBlock.newInstance(MethodDescriptor.ofConstructor(CommandExecutionException.class, (Class[])new Class[]{String.class, Exception.class}), new ResultHandle[]{GitHubAppCommandAirlineProcessor.stringFormat((BytecodeCreator)catchBlock, catchBlock.load("Unable to execute command: %1$s"), catchBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(GHIssueComment.class, (String)"getBody", String.class, (Class[])new Class[0]), GitHubAppCommandAirlineProcessor.getIssueComment((BytecodeCreator)catchBlock, issueCommentPayloadRh), new ResultHandle[0])), catchBlock.getCaughtException()}));
        dispatchMethodCreator.returnValue(null);
    }

    private static void generateCommandDispatcherGetCommandConfigsMethod(ClassCreator commandDispatcherClassCreator, IndexView index, Collection<ClassInfo> allCommands) {
        MethodCreator getCommandConfigsMethodCreator = commandDispatcherClassCreator.getMethodCreator("getCommandConfigs", Map.class.getName(), new String[0]);
        ResultHandle commandConfigsRh = getCommandConfigsMethodCreator.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
        for (ClassInfo command : allCommands) {
            AnnotationInstance commandOptionsAnnotation = command.declaredAnnotation(GitHubAppCommandAirlineDotNames.COMMAND_OPTIONS);
            if (commandOptionsAnnotation == null) continue;
            getCommandConfigsMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(HashMap.class, (String)"put", Object.class, (Class[])new Class[]{Object.class, Object.class}), commandConfigsRh, new ResultHandle[]{getCommandConfigsMethodCreator.load(command.name().toString()), GitHubAppCommandAirlineProcessor.getCommandConfig((BytecodeCreator)getCommandConfigsMethodCreator, index, commandOptionsAnnotation)});
        }
        getCommandConfigsMethodCreator.returnValue(commandConfigsRh);
    }

    private static void generateCommandDispatcherGetCommandPermissionConfigsMethod(ClassCreator commandDispatcherClassCreator, Collection<ClassInfo> allCommands) {
        MethodCreator getCommandPermissionConfigsMethodCreator = commandDispatcherClassCreator.getMethodCreator("getCommandPermissionConfigs", Map.class.getName(), new String[0]);
        ResultHandle commandPermissionConfigsRh = getCommandPermissionConfigsMethodCreator.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
        for (ClassInfo command : allCommands) {
            AnnotationInstance permissionAnnotation = command.declaredAnnotation(GitHubAppCommandAirlineDotNames.PERMISSION);
            if (permissionAnnotation == null) continue;
            getCommandPermissionConfigsMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(HashMap.class, (String)"put", Object.class, (Class[])new Class[]{Object.class, Object.class}), commandPermissionConfigsRh, new ResultHandle[]{getCommandPermissionConfigsMethodCreator.load(command.name().toString()), GitHubAppCommandAirlineProcessor.getCommandPermissionConfig(getCommandPermissionConfigsMethodCreator, permissionAnnotation)});
        }
        getCommandPermissionConfigsMethodCreator.returnValue(commandPermissionConfigsRh);
    }

    private static ResultHandle getCommandPermissionConfig(MethodCreator bytecodeCreator, AnnotationInstance permissionAnnotation) {
        ResultHandle permissionRh = permissionAnnotation != null ? bytecodeCreator.load((Enum)GHPermissionType.valueOf((String)permissionAnnotation.value().asEnum())) : bytecodeCreator.loadNull();
        return bytecodeCreator.newInstance(MethodDescriptor.ofConstructor(CommandPermissionConfig.class, (Class[])new Class[]{GHPermissionType.class}), new ResultHandle[]{permissionRh});
    }

    private static void generateCommandDispatcherGetCommandTeamConfigsMethod(ClassCreator commandDispatcherClassCreator, Collection<ClassInfo> allCommands) {
        MethodCreator getCommandTeamConfigsMethodCreator = commandDispatcherClassCreator.getMethodCreator("getCommandTeamConfigs", Map.class.getName(), new String[0]);
        ResultHandle commandTeamConfigsRh = getCommandTeamConfigsMethodCreator.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
        for (ClassInfo command : allCommands) {
            AnnotationInstance teamAnnotation = command.declaredAnnotation(GitHubAppCommandAirlineDotNames.TEAM);
            if (teamAnnotation == null) continue;
            getCommandTeamConfigsMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(HashMap.class, (String)"put", Object.class, (Class[])new Class[]{Object.class, Object.class}), commandTeamConfigsRh, new ResultHandle[]{getCommandTeamConfigsMethodCreator.load(command.name().toString()), GitHubAppCommandAirlineProcessor.getCommandTeamConfig((BytecodeCreator)getCommandTeamConfigsMethodCreator, teamAnnotation)});
        }
        getCommandTeamConfigsMethodCreator.returnValue(commandTeamConfigsRh);
    }

    private static ResultHandle getCommandTeamConfig(BytecodeCreator bytecodeCreator, AnnotationInstance teamAnnotation) {
        ResultHandle teamsRh;
        if (teamAnnotation != null) {
            String[] teams = teamAnnotation.value().asStringArray();
            teamsRh = bytecodeCreator.newArray(String.class, teams.length);
            for (int i = 0; i < teams.length; ++i) {
                bytecodeCreator.writeArrayValue(teamsRh, i, bytecodeCreator.load(teams[i]));
            }
        } else {
            teamsRh = bytecodeCreator.loadNull();
        }
        return bytecodeCreator.newInstance(MethodDescriptor.ofConstructor(CommandTeamConfig.class, (Class[])new Class[]{String[].class}), new ResultHandle[]{teamsRh});
    }

    private static void generateCommandDispatcherConstructor(ClassCreator commandDispatcherClassCreator, String commandDispatcherClassName, IndexView index, ClassInfo cliClassInfo, List<String> aliases) {
        MethodCreator constructorMethodCreator = commandDispatcherClassCreator.getMethodCreator(MethodDescriptor.ofConstructor((String)commandDispatcherClassName, (String[])new String[0]));
        ResultHandle aliasesRh = GitHubAppCommandAirlineProcessor.toResultHandle((BytecodeCreator)constructorMethodCreator, aliases);
        AnnotationInstance cliOptionsAnnotation = cliClassInfo.declaredAnnotation(GitHubAppCommandAirlineDotNames.CLI_OPTIONS);
        ResultHandle defaultCommandConfigRh = GitHubAppCommandAirlineProcessor.getCommandConfig((BytecodeCreator)constructorMethodCreator, index, cliOptionsAnnotation != null ? cliOptionsAnnotation.valueWithDefault(index, "defaultCommandOptions").asNested() : null);
        ResultHandle defaultCommandPermissionConfigRh = GitHubAppCommandAirlineProcessor.getCommandPermissionConfig(constructorMethodCreator, cliClassInfo.declaredAnnotation(GitHubAppCommandAirlineDotNames.PERMISSION));
        ResultHandle defaultCommandTeamConfigRh = GitHubAppCommandAirlineProcessor.getCommandTeamConfig((BytecodeCreator)constructorMethodCreator, cliClassInfo.declaredAnnotation(GitHubAppCommandAirlineDotNames.TEAM));
        ResultHandle cliConfigRh = cliOptionsAnnotation != null ? constructorMethodCreator.newInstance(MethodDescriptor.ofConstructor(CliConfig.class, (Class[])new Class[]{List.class, CliOptions.ParseErrorStrategy.class, String.class, Class.class, CommandConfig.class, CommandPermissionConfig.class, CommandTeamConfig.class}), new ResultHandle[]{aliasesRh, constructorMethodCreator.load((Enum)CliOptions.ParseErrorStrategy.valueOf((String)cliOptionsAnnotation.valueWithDefault(index, "parseErrorStrategy").asEnum())), constructorMethodCreator.load(cliOptionsAnnotation.valueWithDefault(index, "parseErrorMessage").asString()), constructorMethodCreator.loadClass(cliOptionsAnnotation.valueWithDefault(index, "parseErrorHandler").asClass().name().toString()), defaultCommandConfigRh, defaultCommandPermissionConfigRh, defaultCommandTeamConfigRh}) : constructorMethodCreator.newInstance(MethodDescriptor.ofConstructor(CliConfig.class, (Class[])new Class[]{List.class, CommandConfig.class, CommandPermissionConfig.class, CommandTeamConfig.class}), new ResultHandle[]{aliasesRh, defaultCommandConfigRh, defaultCommandPermissionConfigRh, defaultCommandTeamConfigRh});
        constructorMethodCreator.invokeSpecialMethod(MethodDescriptor.ofConstructor(AbstractCommandDispatcher.class, (Class[])new Class[]{Class.class, CliConfig.class}), constructorMethodCreator.getThis(), new ResultHandle[]{constructorMethodCreator.loadClass(cliClassInfo), cliConfigRh});
        constructorMethodCreator.returnValue(null);
    }

    private static Map<DotName, ClassInfo> getAllCommands(IndexView index, AnnotationInstance annotationInstance) {
        AnnotationValue groupsValue;
        AnnotationValue defaultCommandValue;
        HashMap<DotName, ClassInfo> allCommands = new HashMap<DotName, ClassInfo>();
        AnnotationValue commandsValue = annotationInstance.value("commands");
        if (commandsValue != null) {
            for (Type commandType : commandsValue.asClassArray()) {
                allCommands.put(commandType.name(), index.getClassByName(commandType.name()));
            }
        }
        if ((defaultCommandValue = annotationInstance.value("defaultCommand")) != null) {
            allCommands.put(defaultCommandValue.asClass().name(), index.getClassByName(defaultCommandValue.asClass().name()));
        }
        if ((groupsValue = annotationInstance.value("groups")) != null) {
            for (AnnotationInstance groupAnnotationInstance : groupsValue.asNestedArray()) {
                allCommands.putAll(GitHubAppCommandAirlineProcessor.getAllCommands(index, groupAnnotationInstance));
            }
        }
        return allCommands;
    }

    private static List<String> getAliases(AnnotationInstance cliAnnotationInstance) {
        AnnotationValue aliases;
        AnnotationInstance cliOptionsAnnotation;
        ArrayList<String> cliAliases = new ArrayList<String>();
        cliAliases.add(cliAnnotationInstance.value("name").asString());
        AnnotationInstance aliasAnnotation = cliAnnotationInstance.target().asClass().declaredAnnotation(GitHubAppCommandAirlineDotNames.ALIAS);
        if (aliasAnnotation != null) {
            cliAliases.add(aliasAnnotation.value("name").asString());
        }
        if ((cliOptionsAnnotation = cliAnnotationInstance.target().asClass().declaredAnnotation(GitHubAppCommandAirlineDotNames.CLI_OPTIONS)) != null && (aliases = cliOptionsAnnotation.value("aliases")) != null) {
            cliAliases.addAll(List.of(aliases.asStringArray()));
        }
        return cliAliases;
    }

    private static ResultHandle getCommandConfig(BytecodeCreator bytecodeCreator, IndexView index, AnnotationInstance commandOptionsAnnotation) {
        if (commandOptionsAnnotation == null) {
            return bytecodeCreator.newInstance(MethodDescriptor.ofConstructor(CommandConfig.class, (Class[])new Class[0]), new ResultHandle[0]);
        }
        return bytecodeCreator.newInstance(MethodDescriptor.ofConstructor(CommandConfig.class, (Class[])new Class[]{CommandOptions.CommandScope.class, CommandOptions.ExecutionErrorStrategy.class, String.class, Class.class, CommandOptions.ReactionStrategy.class}), new ResultHandle[]{bytecodeCreator.load((Enum)CommandOptions.CommandScope.valueOf((String)commandOptionsAnnotation.valueWithDefault(index, "scope").asEnum())), bytecodeCreator.load((Enum)CommandOptions.ExecutionErrorStrategy.valueOf((String)commandOptionsAnnotation.valueWithDefault(index, "executionErrorStrategy").asEnum())), bytecodeCreator.load(commandOptionsAnnotation.valueWithDefault(index, "executionErrorMessage").asString()), bytecodeCreator.loadClass(commandOptionsAnnotation.valueWithDefault(index, "executionErrorHandler").asClass().name().toString()), bytecodeCreator.load((Enum)CommandOptions.ReactionStrategy.valueOf((String)commandOptionsAnnotation.valueWithDefault(index, "reactionStrategy").asEnum()))});
    }

    private static RunMethod findCommonInterfaceWithRunMethod(IndexView index, String cliName, Collection<ClassInfo> commands) {
        if (commands.isEmpty()) {
            throw new IllegalStateException("No commands are defined for command " + cliName);
        }
        List candidates = commands.iterator().next().interfaceNames();
        for (ClassInfo command : commands) {
            candidates.retainAll(command.interfaceNames());
        }
        RunMethod commonInterfaceWithRunMethod = null;
        for (DotName candidate : candidates) {
            List runMethods;
            ClassInfo candidateClassInfo = index.getClassByName(candidate);
            if (candidateClassInfo == null || (runMethods = candidateClassInfo.methods().stream().filter(mi -> RUN_METHOD.equals(mi.name())).collect(Collectors.toList())).isEmpty()) continue;
            if (runMethods.size() > 1) {
                throw new IllegalStateException("Found too many run(...) methods in interface common to all commands for command " + cliName + ": " + String.valueOf(candidate));
            }
            if (commonInterfaceWithRunMethod != null) {
                throw new IllegalStateException("Found too many interfaces with a run(...) method common to all commands for command " + cliName + ": " + String.valueOf(commonInterfaceWithRunMethod.getClazz()) + " and " + String.valueOf(candidate));
            }
            commonInterfaceWithRunMethod = new RunMethod(candidateClassInfo, (MethodInfo)runMethods.iterator().next());
        }
        if (commonInterfaceWithRunMethod == null) {
            throw new IllegalStateException("Unable to find an interface with a run(...) method common to all commands for command " + cliName);
        }
        return commonInterfaceWithRunMethod;
    }

    private static ResultHandle getIssueComment(BytecodeCreator bytecodeCreator, ResultHandle issueCommentPayloadRh) {
        return bytecodeCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(GHEventPayload.IssueComment.class, (String)"getComment", GHIssueComment.class, (Class[])new Class[0]), issueCommentPayloadRh, new ResultHandle[0]);
    }

    private static ResultHandle createReaction(BytecodeCreator bytecodeCreator, ResultHandle issueCommentPayloadRh, ReactionContent reactionContent) {
        return bytecodeCreator.invokeStaticMethod(MethodDescriptor.ofMethod(Reactions.class, (String)"createReaction", GHReaction.class, (Class[])new Class[]{GHEventPayload.IssueComment.class, ReactionContent.class}), new ResultHandle[]{issueCommentPayloadRh, bytecodeCreator.load((Enum)reactionContent)});
    }

    private static void deleteReaction(BytecodeCreator bytecodeCreator, ResultHandle issueCommentPayloadRh, ResultHandle reactionRh) {
        bytecodeCreator.ifNotNull(reactionRh).trueBranch().invokeStaticMethod(MethodDescriptor.ofMethod(Reactions.class, (String)"deleteReaction", Void.TYPE, (Class[])new Class[]{GHEventPayload.IssueComment.class, GHReaction.class}), new ResultHandle[]{issueCommentPayloadRh, reactionRh});
    }

    private static <T> ResultHandle toResultHandle(BytecodeCreator bytecodeCreator, List<String> list) {
        ResultHandle arrayRh = bytecodeCreator.newArray(String.class, list.size());
        for (int i = 0; i < list.size(); ++i) {
            bytecodeCreator.writeArrayValue(arrayRh, i, bytecodeCreator.load(list.get(i)));
        }
        return bytecodeCreator.invokeStaticInterfaceMethod(MethodDescriptor.ofMethod(List.class, (String)"of", List.class, (Class[])new Class[]{Object[].class}), new ResultHandle[]{arrayRh});
    }

    private static ResultHandle stringFormat(BytecodeCreator bytecodeCreator, ResultHandle string, ResultHandle ... arguments) {
        ResultHandle argumentsArrayRh = bytecodeCreator.newArray(Object.class, arguments.length);
        for (ResultHandle argument : arguments) {
            bytecodeCreator.writeArrayValue(argumentsArrayRh, 0, argument);
        }
        return bytecodeCreator.invokeStaticMethod(MethodDescriptor.ofMethod(String.class, (String)"format", String.class, (Class[])new Class[]{String.class, Object[].class}), new ResultHandle[]{string, argumentsArrayRh});
    }

    private static class RunMethod {
        private final ClassInfo clazz;
        private final MethodInfo method;

        private RunMethod(ClassInfo clazz, MethodInfo method) {
            this.clazz = clazz;
            this.method = method;
        }

        public ClassInfo getClazz() {
            return this.clazz;
        }

        public MethodInfo getMethod() {
            return this.method;
        }
    }
}

