/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.command.airline;

import io.quarkiverse.githubapp.command.airline.CommandOptions;
import io.quarkiverse.githubapp.command.airline.ParseErrorHandler;
import io.quarkiverse.githubapp.command.airline.runtime.DefaultParseErrorHandler;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
public @interface CliOptions {
    public static final ParseErrorStrategy DEFAULT_PARSE_ERROR_STRATEGY = ParseErrorStrategy.COMMENT_MESSAGE_HELP_ERRORS;
    public static final String DEFAULT_PARSE_ERROR_MESSAGE = "> `%s`\n\n:rotating_light: Unable to parse the command.";
    public static final Class<? extends ParseErrorHandler> DEFAULT_PARSE_ERROR_HANDLER = DefaultParseErrorHandler.class;

    public String[] aliases() default {};

    public ParseErrorStrategy parseErrorStrategy() default ParseErrorStrategy.COMMENT_MESSAGE_HELP_ERRORS;

    public String parseErrorMessage() default "> `%s`\n\n:rotating_light: Unable to parse the command.";

    public Class<? extends ParseErrorHandler> parseErrorHandler() default DefaultParseErrorHandler.class;

    public CommandOptions defaultCommandOptions() default @CommandOptions;

    public static enum ParseErrorStrategy {
        NONE(false, false, false),
        COMMENT_MESSAGE(true, false, false),
        COMMENT_MESSAGE_HELP(true, true, false),
        COMMENT_MESSAGE_ERRORS(true, false, true),
        COMMENT_MESSAGE_HELP_ERRORS(true, true, true);

        private final boolean message;
        private final boolean help;
        private final boolean errors;

        private ParseErrorStrategy(boolean message, boolean help, boolean errors) {
            this.message = message;
            this.help = help;
            this.errors = errors;
        }

        public boolean addMessage() {
            return this.message;
        }

        public boolean includeHelp() {
            return this.help;
        }

        public boolean includeErrors() {
            return this.errors;
        }
    }
}

