/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.command.airline;

import io.quarkiverse.githubapp.command.airline.ExecutionErrorHandler;
import io.quarkiverse.githubapp.command.airline.runtime.DefaultExecutionErrorHandler;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.kohsuke.github.GHEventPayload;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
public @interface CommandOptions {
    public static final CommandScope DEFAULT_SCOPE = CommandScope.ISSUES_AND_PULL_REQUESTS;
    public static final ExecutionErrorStrategy DEFAULT_EXECUTION_ERROR_STRATEGY = ExecutionErrorStrategy.NONE;
    public static final String DEFAULT_EXECUTION_ERROR_MESSAGE = "> `%s`\n\n:rotating_light: An error occurred while executing the command.";
    public static final Class<? extends ExecutionErrorHandler> DEFAULT_EXECUTION_ERROR_HANDLER = DefaultExecutionErrorHandler.class;
    public static final ReactionStrategy DEFAULT_REACTION_STRATEGY = ReactionStrategy.ALL;

    public CommandScope scope() default CommandScope.ISSUES_AND_PULL_REQUESTS;

    public ExecutionErrorStrategy executionErrorStrategy() default ExecutionErrorStrategy.NONE;

    public String executionErrorMessage() default "> `%s`\n\n:rotating_light: An error occurred while executing the command.";

    public Class<? extends ExecutionErrorHandler> executionErrorHandler() default DefaultExecutionErrorHandlerMarker.class;

    public ReactionStrategy reactionStrategy() default ReactionStrategy.ALL;

    public static enum CommandScope {
        ISSUES,
        PULL_REQUESTS,
        ISSUES_AND_PULL_REQUESTS;


        public boolean isInScope(boolean isPullRequest) {
            if (isPullRequest) {
                return this == ISSUES_AND_PULL_REQUESTS || this == PULL_REQUESTS;
            }
            return this == ISSUES_AND_PULL_REQUESTS || this == ISSUES;
        }
    }

    public static enum ExecutionErrorStrategy {
        NONE(false),
        COMMENT_MESSAGE(true);

        private final boolean message;

        private ExecutionErrorStrategy(boolean message) {
            this.message = message;
        }

        public boolean addMessage() {
            return this.message;
        }
    }

    public static enum ReactionStrategy {
        NONE(false, false, false),
        ON_PROGRESS(true, false, false),
        ON_PROGRESS_ON_ERROR(true, false, true),
        ON_NORMAL_ON_ERROR(false, true, true),
        ON_ERROR(false, false, true),
        ALL(true, true, true);

        private final boolean reactionOnProgress;
        private final boolean reactionOnNormalFlow;
        private final boolean reactionOnError;

        private ReactionStrategy(boolean reactionOnProgress, boolean reactionOnNormalFlow, boolean reactionOnError) {
            this.reactionOnProgress = reactionOnProgress;
            this.reactionOnNormalFlow = reactionOnNormalFlow;
            this.reactionOnError = reactionOnError;
        }

        public boolean reactionOnProgress() {
            return this.reactionOnProgress;
        }

        public boolean reactionOnNormalFlow() {
            return this.reactionOnNormalFlow;
        }

        public boolean reactionOnError() {
            return this.reactionOnError;
        }
    }

    public static class DefaultExecutionErrorHandlerMarker
    implements ExecutionErrorHandler {
        @Override
        public void handleExecutionError(GHEventPayload.IssueComment issueCommentPayload, ExecutionErrorHandler.ExecutionErrorContext executionErrorContext) {
            throw new IllegalStateException("This implementation is just a marker and may never get called");
        }
    }
}

