/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.command.airline.runtime;

import com.github.rvesse.airline.Cli;
import com.github.rvesse.airline.annotations.AirlineModule;
import com.github.rvesse.airline.builder.ParserBuilder;
import com.github.rvesse.airline.help.Help;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.GlobalMetadata;
import com.github.rvesse.airline.model.MetadataLoader;
import com.github.rvesse.airline.model.ParserMetadata;
import com.github.rvesse.airline.parser.ParseResult;
import com.github.rvesse.airline.parser.errors.ParseException;
import com.github.rvesse.airline.parser.errors.handlers.CollectAll;
import com.github.rvesse.airline.parser.errors.handlers.ParserErrorHandler;
import io.quarkiverse.githubapp.command.airline.AirlineInject;
import io.quarkiverse.githubapp.command.airline.runtime.ArcCommandFactory;
import io.quarkiverse.githubapp.command.airline.runtime.CliConfig;
import io.quarkiverse.githubapp.command.airline.runtime.CommandConfig;
import io.quarkiverse.githubapp.command.airline.runtime.CommandExecutionException;
import io.quarkiverse.githubapp.command.airline.runtime.CommandPermissionConfig;
import io.quarkiverse.githubapp.command.airline.runtime.CommandTeamConfig;
import io.quarkiverse.githubapp.command.airline.runtime.util.Commandline;
import io.quarkiverse.githubapp.command.airline.runtime.util.Reactions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.kohsuke.github.GHEventPayload;
import org.kohsuke.github.GHReaction;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHTeam;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.ReactionContent;

public abstract class AbstractCommandDispatcher<C> {
    private static final Logger LOGGER = Logger.getLogger(AbstractCommandDispatcher.class);
    private final Cli<C> cli;
    private final CliConfig cliConfig;
    private final Map<String, CommandConfig> commandConfigs;
    private final Map<String, CommandPermissionConfig> commandPermissionConfigs;
    private final Map<String, CommandTeamConfig> commandTeamConfigs;

    protected AbstractCommandDispatcher(Class<?> cliClass, CliConfig cliConfig) {
        ParserBuilder parserBuilder = new ParserBuilder();
        parserBuilder.withCommandFactory(new ArcCommandFactory());
        parserBuilder.withErrorHandler((ParserErrorHandler)new CollectAll());
        parserBuilder.withCompositionAnnotations(new String[]{AirlineModule.class.getName(), AirlineInject.class.getName()});
        this.cli = new Cli(MetadataLoader.loadGlobal(cliClass, (ParserMetadata)parserBuilder.build()));
        this.cliConfig = cliConfig;
        this.commandConfigs = this.getCommandConfigs();
        this.commandPermissionConfigs = this.getCommandPermissionConfigs();
        this.commandTeamConfigs = this.getCommandTeamConfigs();
    }

    protected abstract Map<String, CommandConfig> getCommandConfigs();

    protected abstract Map<String, CommandPermissionConfig> getCommandPermissionConfigs();

    protected abstract Map<String, CommandTeamConfig> getCommandTeamConfigs();

    protected Optional<CommandExecutionContext<C>> getCommand(GHEventPayload.IssueComment issueCommentPayload) {
        List<String> commandLine;
        String body = issueCommentPayload.getComment().getBody();
        if (body == null || body.isBlank()) {
            return Optional.empty();
        }
        Optional<String> firstLineOptional = body.trim().lines().findFirst();
        if (firstLineOptional.isEmpty() || firstLineOptional.get().isBlank()) {
            return Optional.empty();
        }
        String firstLine = firstLineOptional.get().trim();
        String cliName = firstLine.split(" ", 2)[0];
        if (!this.matches(cliName)) {
            return Optional.empty();
        }
        try {
            commandLine = Commandline.translateCommandline(firstLine);
            commandLine.remove(0);
        }
        catch (IllegalArgumentException e) {
            this.handleParseError(issueCommentPayload, firstLine, null, e.getMessage());
            if (this.cliConfig.getDefaultCommandConfig().getReactionStrategy().reactionOnError()) {
                Reactions.createReaction(issueCommentPayload, ReactionContent.CONFUSED);
            }
            return Optional.empty();
        }
        ParseResult parseResult = this.cli.parseWithResult(commandLine);
        if (parseResult.wasSuccessful()) {
            CommandTeamConfig commandTeamConfig;
            String commandClassName = parseResult.getState().getCommand().getType().getName();
            CommandConfig commandConfig = this.commandConfigs.getOrDefault(commandClassName, this.cliConfig.getDefaultCommandConfig());
            if (!commandConfig.getScope().isInScope(issueCommentPayload.getIssue().isPullRequest())) {
                return Optional.empty();
            }
            CommandPermissionConfig commandPermissionConfig = this.commandPermissionConfigs.getOrDefault(commandClassName, this.cliConfig.getDefaultCommandPermissionConfig());
            if (!this.hasPermission(commandPermissionConfig, commandTeamConfig = this.commandTeamConfigs.getOrDefault(commandClassName, this.cliConfig.getDefaultCommandTeamConfig()), issueCommentPayload.getRepository(), issueCommentPayload.getSender())) {
                if (commandConfig.getReactionStrategy().reactionOnError()) {
                    Reactions.createReaction(issueCommentPayload, ReactionContent.MINUS_ONE);
                }
                return Optional.empty();
            }
            GHReaction ackReaction = commandConfig.getReactionStrategy().reactionOnProgress() ? Reactions.createReaction(issueCommentPayload, ReactionContent.ROCKET) : null;
            return Optional.of(new CommandExecutionContext<Object>(firstLine, parseResult.getCommand(), commandConfig, ackReaction));
        }
        CommandConfig bestCommandConfig = this.getBestCommandConfigInErrorState(parseResult);
        if (bestCommandConfig.getReactionStrategy().reactionOnError()) {
            Reactions.createReaction(issueCommentPayload, ReactionContent.CONFUSED);
        }
        this.handleParseError(issueCommentPayload, firstLine, parseResult, null);
        return Optional.empty();
    }

    private boolean matches(String cli) {
        for (String alias : this.cliConfig.getAliases()) {
            if (!alias.equals(cli)) continue;
            return true;
        }
        return false;
    }

    private boolean hasPermission(CommandPermissionConfig commandPermissionConfig, CommandTeamConfig commandTeamConfig, GHRepository repository, GHUser user) {
        try {
            if (commandPermissionConfig.getPermission() != null) {
                if (user == null) {
                    return false;
                }
                if (!repository.hasPermission(user, commandPermissionConfig.getPermission())) {
                    return false;
                }
            }
            if (!commandTeamConfig.getTeams().isEmpty()) {
                if (user == null) {
                    return false;
                }
                List matchingTeams = repository.getTeams().stream().filter(t -> commandTeamConfig.getTeams().contains(t.getSlug())).collect(Collectors.toList());
                for (GHTeam matchingTeam : matchingTeams) {
                    if (!matchingTeam.hasMember(user)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        catch (IOException e) {
            throw new CommandExecutionException("Unable to check the permissions for the command", e);
        }
    }

    private CommandConfig getBestCommandConfigInErrorState(ParseResult<C> parseResult) {
        if (parseResult.getState().getCommand() == null) {
            return this.cliConfig.getDefaultCommandConfig();
        }
        return this.commandConfigs.getOrDefault(parseResult.getState().getCommand().getType().getName(), this.cliConfig.getDefaultCommandConfig());
    }

    private void handleParseError(GHEventPayload.IssueComment issueCommentPayload, String command, ParseResult<C> parseResult, String error) {
        if (!this.cliConfig.getParseErrorStrategy().addMessage()) {
            return;
        }
        StringBuilder message = new StringBuilder();
        message.append(String.format(this.cliConfig.getParseErrorMessage(), command));
        if (this.cliConfig.getParseErrorStrategy().includeErrors()) {
            message.append("\n\nErrors:\n");
            if (error != null) {
                message.append("\n- " + error);
            }
            if (parseResult != null) {
                for (ParseException parseError : parseResult.getErrors()) {
                    message.append("\n- " + parseError.getMessage());
                }
            }
        }
        if (error == null && this.cliConfig.getParseErrorStrategy().includeHelp()) {
            try {
                ByteArrayOutputStream helpOs = new ByteArrayOutputStream();
                if (parseResult != null && parseResult.getState().getCommand() != null) {
                    Help.help((CommandMetadata)parseResult.getState().getCommand(), (OutputStream)helpOs);
                } else {
                    Help.help((GlobalMetadata)this.cli.getMetadata(), Collections.emptyList(), (OutputStream)helpOs);
                }
                String help = helpOs.toString(StandardCharsets.UTF_8);
                if (!help.isBlank()) {
                    message.append("\n\nHelp:\n\n").append("```\n" + help.trim() + "\n```");
                }
            }
            catch (IOException e) {
                LOGGER.warn((Object)("Error trying to generate help for command `" + command + "` in " + issueCommentPayload.getRepository().getFullName() + "#" + issueCommentPayload.getIssue().getNumber()), (Throwable)e);
            }
        }
        try {
            issueCommentPayload.getIssue().comment(message.toString());
        }
        catch (Exception e) {
            LOGGER.warn((Object)("Error trying to add command parse error comment for command `" + command + "` in " + issueCommentPayload.getRepository().getFullName() + "#" + issueCommentPayload.getIssue().getNumber()), (Throwable)e);
        }
    }

    protected void handleExecutionError(GHEventPayload.IssueComment issueCommentPayload, CommandExecutionContext<C> commandExecutionContext) {
        CommandConfig commandConfig = commandExecutionContext.getCommandConfig();
        String commandLine = commandExecutionContext.getCommandLine();
        if (!commandConfig.getExecutionErrorStrategy().addMessage()) {
            return;
        }
        try {
            issueCommentPayload.getIssue().comment(String.format(commandConfig.getExecutionErrorMessage(), commandLine));
        }
        catch (Exception e) {
            LOGGER.warn((Object)("Error trying to add command execution error comment for command `" + commandLine + "` in " + issueCommentPayload.getRepository().getFullName() + "#" + issueCommentPayload.getIssue().getNumber()), (Throwable)e);
        }
    }

    public static class CommandExecutionContext<C> {
        private final String commandLine;
        private final C command;
        private final GHReaction ackReaction;
        private final CommandConfig commandConfig;

        public CommandExecutionContext(String commandLine, C command, CommandConfig commandConfig, GHReaction ackReaction) {
            this.commandLine = commandLine;
            this.command = command;
            this.commandConfig = commandConfig;
            this.ackReaction = ackReaction;
        }

        public String getCommandLine() {
            return this.commandLine;
        }

        public C getCommand() {
            return this.command;
        }

        public CommandConfig getCommandConfig() {
            return this.commandConfig;
        }

        public GHReaction getAckReaction() {
            return this.ackReaction;
        }
    }
}

