/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.deployment;

import io.quarkiverse.githubapp.GitHubEvent;
import io.quarkiverse.githubapp.deployment.DispatchingConfiguration;
import io.quarkiverse.githubapp.deployment.EventDefinition;
import io.quarkiverse.githubapp.deployment.GitHubAppDotNames;
import io.quarkiverse.githubapp.deployment.VetoUserDefinedEventListeningClassesAnnotationsTransformer;
import io.quarkiverse.githubapp.runtime.ConfigFileReader;
import io.quarkiverse.githubapp.runtime.GitHubAppRecorder;
import io.quarkiverse.githubapp.runtime.Multiplexer;
import io.quarkiverse.githubapp.runtime.Routes;
import io.quarkiverse.githubapp.runtime.UtilsProducer;
import io.quarkiverse.githubapp.runtime.error.DefaultErrorHandler;
import io.quarkiverse.githubapp.runtime.error.ErrorHandlerBridgeFunction;
import io.quarkiverse.githubapp.runtime.github.GitHubService;
import io.quarkiverse.githubapp.runtime.github.PayloadHelper;
import io.quarkiverse.githubapp.runtime.signing.JwtTokenCreator;
import io.quarkiverse.githubapp.runtime.signing.PayloadSignatureChecker;
import io.quarkiverse.githubapp.runtime.smee.SmeeIoForwarder;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.util.WebJarUtil;
import io.quarkus.gizmo.AnnotatedElement;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.util.HashUtil;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.devmode.NotFoundPageDisplayableEndpointBuildItem;
import io.vertx.core.Handler;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.event.Event;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.kohsuke.github.GHEventPayload;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;

class GitHubAppProcessor {
    private static final Logger LOG = Logger.getLogger(GitHubAppProcessor.class);
    private static final String FEATURE = "github-app";
    private static final String EVENT_EMITTER_FIELD = "eventEmitter";
    private static final String GITHUB_SERVICE_FIELD = "gitHubService";
    private static final MethodDescriptor EVENT_SELECT = MethodDescriptor.ofMethod(Event.class, (String)"select", Event.class, (Class[])new Class[]{Annotation[].class});
    private static final MethodDescriptor EVENT_FIRE_ASYNC = MethodDescriptor.ofMethod(Event.class, (String)"fireAsync", CompletionStage.class, (Class[])new Class[]{Object.class});
    private static final MethodDescriptor COMPLETION_STAGE_EXCEPTIONALLY = MethodDescriptor.ofMethod(CompletionStage.class, (String)"exceptionally", CompletionStage.class, (Class[])new Class[]{Function.class});
    private static final MethodDescriptor COMPLETION_STAGE_TO_COMPLETABLE_FUTURE = MethodDescriptor.ofMethod(CompletionStage.class, (String)"toCompletableFuture", CompletableFuture.class, (Class[])new Class[0]);
    private static final MethodDescriptor COMPLETABLE_FUTURE_JOIN = MethodDescriptor.ofMethod(CompletableFuture.class, (String)"join", Object.class, (Class[])new Class[0]);
    private static final String QUARKIVERSE_GITHUB_APP_GROUP_ID = "io.quarkiverse.githubapp";
    private static final String QUARKIVERSE_GITHUB_APP_ARTIFACT_ID = "quarkus-github-app-deployment";
    private static final String REPLAY_UI_RESOURCES_PREFIX = "META-INF/resources/replay-ui/";
    private static final String REPLAY_UI_PATH = "/replay";

    GitHubAppProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    void registerForReflection(CombinedIndexBuildItem combinedIndex, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchies) {
        for (AnnotationInstance configFileAnnotationInstance : combinedIndex.getIndex().getAnnotations(GitHubAppDotNames.CONFIG_FILE)) {
            MethodParameterInfo methodParameter = configFileAnnotationInstance.target().asMethodParameter();
            short parameterPosition = methodParameter.position();
            Type parameterType = (Type)methodParameter.method().parameters().get(parameterPosition);
            reflectiveHierarchies.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(parameterType).index(combinedIndex.getIndex()).source(GitHubAppProcessor.class.getSimpleName() + " > " + methodParameter.method().declaringClass() + "#" + methodParameter.method()).build());
        }
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{"com.github.benmanes.caffeine.cache.SSMSA", "com.github.benmanes.caffeine.cache.PSWMS"}));
    }

    @BuildStep
    void additionalBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem.Builder().addBeanClasses(new Class[]{JwtTokenCreator.class, PayloadSignatureChecker.class, GitHubService.class, SmeeIoForwarder.class, Routes.class, UtilsProducer.class, DefaultErrorHandler.class}).setUnremovable().setDefaultScope(DotNames.SINGLETON).build());
    }

    @BuildStep
    void generateClasses(CombinedIndexBuildItem combinedIndex, LaunchModeBuildItem launchMode, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformer) {
        Collection<EventDefinition> allEventDefinitions = GitHubAppProcessor.getAllEventDefinitions(combinedIndex.getIndex());
        annotationsTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem((AnnotationsTransformer)new VetoUserDefinedEventListeningClassesAnnotationsTransformer(allEventDefinitions.stream().map(d -> d.getAnnotation()).collect(Collectors.toSet()))));
        String[] subscriberAnnotations = (String[])allEventDefinitions.stream().map(d -> d.getAnnotation().toString()).toArray(String[]::new);
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(subscriberAnnotations));
        DispatchingConfiguration dispatchingConfiguration = GitHubAppProcessor.getDispatchingConfiguration(combinedIndex.getIndex(), allEventDefinitions);
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClasses, true);
        GitHubAppProcessor.generateAnnotationLiterals((ClassOutput)classOutput, dispatchingConfiguration);
        GeneratedBeanGizmoAdaptor beanClassOutput = new GeneratedBeanGizmoAdaptor(generatedBeans);
        GitHubAppProcessor.generateDispatcher((ClassOutput)beanClassOutput, combinedIndex, launchMode, dispatchingConfiguration, reflectiveClasses);
        GitHubAppProcessor.generateMultiplexers((ClassOutput)beanClassOutput, dispatchingConfiguration, reflectiveClasses);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void replayUi(GitHubAppRecorder recorder, LaunchModeBuildItem launchMode, LiveReloadBuildItem liveReloadBuildItem, CurateOutcomeBuildItem curateOutcomeBuildItem, HttpRootPathBuildItem httpRootPathBuildItem, BuildProducer<RouteBuildItem> routes, BuildProducer<NotFoundPageDisplayableEndpointBuildItem> displayableEndpoints, ShutdownContextBuildItem shutdownContext) throws IOException {
        if (launchMode.getLaunchMode() != LaunchMode.DEVELOPMENT) {
            return;
        }
        AppArtifact githubAppArtifact = WebJarUtil.getAppArtifact((CurateOutcomeBuildItem)curateOutcomeBuildItem, (String)QUARKIVERSE_GITHUB_APP_GROUP_ID, (String)QUARKIVERSE_GITHUB_APP_ARTIFACT_ID);
        Path deploymentPath = WebJarUtil.copyResourcesForDevOrTest((LiveReloadBuildItem)liveReloadBuildItem, (CurateOutcomeBuildItem)curateOutcomeBuildItem, (LaunchModeBuildItem)launchMode, (AppArtifact)githubAppArtifact, (String)REPLAY_UI_RESOURCES_PREFIX);
        Handler handler = recorder.replayUiHandler(deploymentPath.toAbsolutePath().toString(), REPLAY_UI_PATH, (ShutdownContext)shutdownContext);
        routes.produce((BuildItem)httpRootPathBuildItem.routeBuilder().route(REPLAY_UI_PATH).handler(handler).build());
        routes.produce((BuildItem)httpRootPathBuildItem.routeBuilder().route("/replay/*").handler(handler).build());
        displayableEndpoints.produce((BuildItem)new NotFoundPageDisplayableEndpointBuildItem("/replay/"));
    }

    private static Collection<EventDefinition> getAllEventDefinitions(IndexView index) {
        ArrayList<EventDefinition> mainEventDefinitions = new ArrayList<EventDefinition>();
        ArrayList<EventDefinition> allEventDefinitions = new ArrayList<EventDefinition>();
        for (AnnotationInstance eventInstance : index.getAnnotations(GitHubAppDotNames.EVENT)) {
            if (eventInstance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            mainEventDefinitions.add(new EventDefinition(eventInstance.target().asClass().name(), eventInstance.value("name").asString(), null, eventInstance.value("payload").asClass().name()));
        }
        allEventDefinitions.addAll(mainEventDefinitions);
        for (EventDefinition mainEventDefinition : mainEventDefinitions) {
            for (AnnotationInstance eventInstance : index.getAnnotations(mainEventDefinition.getAnnotation())) {
                if (eventInstance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
                AnnotationValue actionValue = eventInstance.value();
                allEventDefinitions.add(new EventDefinition(eventInstance.target().asClass().name(), mainEventDefinition.getEvent(), actionValue != null ? actionValue.asString() : null, mainEventDefinition.getPayloadType()));
            }
        }
        return allEventDefinitions;
    }

    private static DispatchingConfiguration getDispatchingConfiguration(IndexView index, Collection<EventDefinition> allEventDefinitions) {
        DispatchingConfiguration configuration = new DispatchingConfiguration();
        for (EventDefinition eventDefinition : allEventDefinitions) {
            Collection eventSubscriberInstances = index.getAnnotations(eventDefinition.getAnnotation()).stream().filter(ai -> ai.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER).collect(Collectors.toList());
            for (AnnotationInstance eventSubscriberInstance : eventSubscriberInstances) {
                String action = eventDefinition.getAction() != null ? eventDefinition.getAction() : (eventSubscriberInstance.value() != null ? eventSubscriberInstance.value().asString() : "*");
                MethodParameterInfo annotatedParameter = eventSubscriberInstance.target().asMethodParameter();
                MethodInfo methodInfo = annotatedParameter.method();
                DotName annotatedParameterType = ((Type)annotatedParameter.method().parameters().get(annotatedParameter.position())).name();
                if (!eventDefinition.getPayloadType().equals((Object)annotatedParameterType)) {
                    throw new IllegalStateException("Parameter subscribing to a GitHub '" + eventDefinition.getEvent() + "' event should be of type '" + eventDefinition.getPayloadType() + "'. Offending method: " + methodInfo.declaringClass().name() + "#" + methodInfo);
                }
                configuration.getOrCreateEventConfiguration(eventDefinition.getEvent(), eventDefinition.getPayloadType().toString()).addEventAnnotation(action, eventSubscriberInstance);
                configuration.addEventDispatchingMethod(new DispatchingConfiguration.EventDispatchingMethod(eventSubscriberInstance, methodInfo));
            }
        }
        return configuration;
    }

    private static void generateAnnotationLiterals(ClassOutput classOutput, DispatchingConfiguration dispatchingConfiguration) {
        for (DispatchingConfiguration.EventDispatchingConfiguration eventDispatchingConfiguration : dispatchingConfiguration.getEventConfigurations().values()) {
            for (DispatchingConfiguration.EventAnnotationLiteral eventAnnotationLiteral : eventDispatchingConfiguration.getEventAnnotationLiterals()) {
                String literalClassName = GitHubAppProcessor.getLiteralClassName(eventAnnotationLiteral.getName());
                String signature = String.format("Ljavax/enterprise/util/AnnotationLiteral<L%1$s;>;L%1$s;", eventAnnotationLiteral.getName().toString().replace('.', '/'));
                ClassCreator literalClassCreator = ClassCreator.builder().classOutput(classOutput).className(literalClassName).signature(signature).superClass(AnnotationLiteral.class).interfaces(new String[]{eventAnnotationLiteral.getName().toString()}).build();
                Object[] parameterTypes = new Class[eventAnnotationLiteral.getAttributes().size()];
                Arrays.fill(parameterTypes, String.class);
                MethodCreator constructorCreator = literalClassCreator.getMethodCreator("<init>", (Object)"V", parameterTypes);
                constructorCreator.invokeSpecialMethod(MethodDescriptor.ofConstructor(AnnotationLiteral.class, (Class[])new Class[0]), constructorCreator.getThis(), new ResultHandle[0]);
                for (int i = 0; i < eventAnnotationLiteral.getAttributes().size(); ++i) {
                    constructorCreator.writeInstanceField(FieldDescriptor.of((String)literalClassName, (String)eventAnnotationLiteral.getAttributes().get(i), String.class), constructorCreator.getThis(), constructorCreator.getMethodParam(i));
                    constructorCreator.setModifiers(1);
                }
                constructorCreator.returnValue(null);
                for (String attribute : eventAnnotationLiteral.getAttributes()) {
                    literalClassCreator.getFieldCreator(attribute, String.class).setModifiers(2);
                    MethodCreator getterCreator = literalClassCreator.getMethodCreator(attribute, String.class, new Class[0]);
                    getterCreator.setModifiers(1);
                    getterCreator.returnValue(getterCreator.readInstanceField(FieldDescriptor.of((String)literalClassName, (String)attribute, String.class), getterCreator.getThis()));
                }
                literalClassCreator.close();
            }
        }
    }

    private static void generateDispatcher(ClassOutput beanClassOutput, CombinedIndexBuildItem combinedIndex, LaunchModeBuildItem launchMode, DispatchingConfiguration dispatchingConfiguration, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        String dispatcherClassName = GitHubEvent.class.getName() + "DispatcherImpl";
        reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{dispatcherClassName}));
        ClassCreator dispatcherClassCreator = ClassCreator.builder().classOutput(beanClassOutput).className(dispatcherClassName).build();
        dispatcherClassCreator.addAnnotation(Singleton.class);
        FieldCreator eventFieldCreator = dispatcherClassCreator.getFieldCreator(EVENT_EMITTER_FIELD, Event.class);
        eventFieldCreator.addAnnotation(Inject.class);
        eventFieldCreator.setModifiers(4);
        FieldCreator gitHubServiceFieldCreator = dispatcherClassCreator.getFieldCreator(GITHUB_SERVICE_FIELD, GitHubService.class);
        gitHubServiceFieldCreator.addAnnotation(Inject.class);
        gitHubServiceFieldCreator.setModifiers(4);
        MethodCreator dispatchMethodCreator = dispatcherClassCreator.getMethodCreator("dispatch", Void.TYPE, new Class[]{GitHubEvent.class});
        dispatchMethodCreator.setModifiers(1);
        dispatchMethodCreator.getParameterAnnotations(0).addAnnotation(DotNames.OBSERVES.toString());
        ResultHandle gitHubEventRh = dispatchMethodCreator.getMethodParam(0);
        ResultHandle installationIdRh = dispatchMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(GitHubEvent.class, (String)"getInstallationId", Long.class, (Class[])new Class[0]), gitHubEventRh, new ResultHandle[0]);
        ResultHandle dispatchedEventRh = dispatchMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(GitHubEvent.class, (String)"getEvent", String.class, (Class[])new Class[0]), gitHubEventRh, new ResultHandle[0]);
        ResultHandle dispatchedActionRh = dispatchMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(GitHubEvent.class, (String)"getAction", String.class, (Class[])new Class[0]), gitHubEventRh, new ResultHandle[0]);
        ResultHandle dispatchedPayloadRh = dispatchMethodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(GitHubEvent.class, (String)"getPayload", String.class, (Class[])new Class[0]), gitHubEventRh, new ResultHandle[0]);
        TryBlock tryBlock = dispatchMethodCreator.tryBlock();
        ResultHandle gitHubRh = tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(GitHubService.class, (String)"getInstallationClient", GitHub.class, (Class[])new Class[]{Long.class}), tryBlock.readInstanceField(FieldDescriptor.of((String)dispatcherClassCreator.getClassName(), (String)GITHUB_SERVICE_FIELD, GitHubService.class), tryBlock.getThis()), new ResultHandle[]{installationIdRh});
        for (DispatchingConfiguration.EventDispatchingConfiguration eventDispatchingConfiguration : dispatchingConfiguration.getEventConfigurations().values()) {
            ResultHandle eventRh = tryBlock.load(eventDispatchingConfiguration.getEvent());
            String payloadType = eventDispatchingConfiguration.getPayloadType();
            BytecodeCreator eventMatchesCreator = tryBlock.ifTrue(tryBlock.invokeVirtualMethod(MethodDescriptors.OBJECT_EQUALS, eventRh, new ResultHandle[]{dispatchedEventRh})).trueBranch();
            ResultHandle payloadInstanceRh = eventMatchesCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(GitHub.class, (String)"parseEventPayload", GHEventPayload.class, (Class[])new Class[]{Reader.class, Class.class}), gitHubRh, new ResultHandle[]{eventMatchesCreator.newInstance(MethodDescriptor.ofConstructor(StringReader.class, (Class[])new Class[]{String.class}), new ResultHandle[]{dispatchedPayloadRh}), eventMatchesCreator.loadClass(payloadType)});
            for (Map.Entry<String, DispatchingConfiguration.EventAnnotation> eventAnnotationEntry : eventDispatchingConfiguration.getEventAnnotations().entrySet()) {
                String action = eventAnnotationEntry.getKey();
                DispatchingConfiguration.EventAnnotation eventAnnotation = eventAnnotationEntry.getValue();
                Object[] literalParameterTypes = new Class[eventAnnotation.getValues().size()];
                Arrays.fill(literalParameterTypes, String.class);
                ArrayList literalParameters = new ArrayList();
                ResultHandle annotationLiteralRh = eventMatchesCreator.newInstance(MethodDescriptor.ofConstructor((Object)GitHubAppProcessor.getLiteralClassName(eventAnnotation.getName()), (Object[])literalParameterTypes), (ResultHandle[])literalParameters.toArray(ResultHandle[]::new));
                ResultHandle annotationLiteralArrayRh = eventMatchesCreator.newArray(Annotation.class, 1);
                eventMatchesCreator.writeArrayValue(annotationLiteralArrayRh, 0, annotationLiteralRh);
                if ("*".equals(action)) {
                    GitHubAppProcessor.fireAsyncAction(eventMatchesCreator, launchMode.getLaunchMode(), dispatcherClassCreator.getClassName(), gitHubEventRh, payloadInstanceRh, annotationLiteralArrayRh);
                    continue;
                }
                BytecodeCreator actionMatchesCreator = eventMatchesCreator.ifTrue(eventMatchesCreator.invokeVirtualMethod(MethodDescriptors.OBJECT_EQUALS, eventMatchesCreator.load(action), new ResultHandle[]{dispatchedActionRh})).trueBranch();
                GitHubAppProcessor.fireAsyncAction(actionMatchesCreator, launchMode.getLaunchMode(), dispatcherClassCreator.getClassName(), gitHubEventRh, payloadInstanceRh, annotationLiteralArrayRh);
            }
        }
        CatchBlockCreator catchBlockCreator = tryBlock.addCatch(Throwable.class);
        catchBlockCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(ErrorHandlerBridgeFunction.class, (String)"apply", Void.class, (Class[])new Class[]{Throwable.class}), catchBlockCreator.newInstance(MethodDescriptor.ofConstructor(ErrorHandlerBridgeFunction.class, (Class[])new Class[]{GitHubEvent.class}), new ResultHandle[]{gitHubEventRh}), new ResultHandle[]{catchBlockCreator.getCaughtException()});
        dispatchMethodCreator.returnValue(null);
        dispatcherClassCreator.close();
    }

    private static void generateMultiplexers(ClassOutput beanClassOutput, DispatchingConfiguration dispatchingConfiguration, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        for (Map.Entry<DotName, TreeSet<DispatchingConfiguration.EventDispatchingMethod>> eventDispatchingMethodsEntry : dispatchingConfiguration.getMethods().entrySet()) {
            DotName declaringClassName = eventDispatchingMethodsEntry.getKey();
            TreeSet<DispatchingConfiguration.EventDispatchingMethod> eventDispatchingMethods = eventDispatchingMethodsEntry.getValue();
            ClassInfo declaringClass = eventDispatchingMethods.iterator().next().getMethod().declaringClass();
            reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{declaringClassName.toString()}));
            String multiplexerClassName = declaringClassName + "_Multiplexer";
            reflectiveClasses.produce((BuildItem)new ReflectiveClassBuildItem(true, true, new String[]{multiplexerClassName}));
            ClassCreator multiplexerClassCreator = ClassCreator.builder().classOutput(beanClassOutput).className(multiplexerClassName).superClass(declaringClassName.toString()).build();
            multiplexerClassCreator.addAnnotation(Multiplexer.class);
            if (!BuiltinScope.isDeclaredOn((ClassInfo)declaringClass)) {
                multiplexerClassCreator.addAnnotation(Singleton.class);
            }
            for (AnnotationInstance classAnnotation : declaringClass.classAnnotations()) {
                multiplexerClassCreator.addAnnotation(classAnnotation);
            }
            for (MethodInfo originalConstructor : declaringClass.constructors()) {
                MethodCreator constructorCreator = multiplexerClassCreator.getMethodCreator(MethodDescriptor.ofConstructor((String)multiplexerClassName, (String[])((String[])originalConstructor.parameters().stream().map(t -> t.name().toString()).toArray(String[]::new))));
                List originalMethodAnnotations = originalConstructor.annotations().stream().filter(ai -> ai.target().kind() == AnnotationTarget.Kind.METHOD).collect(Collectors.toList());
                for (AnnotationInstance originalMethodAnnotation : originalMethodAnnotations) {
                    constructorCreator.addAnnotation(originalMethodAnnotation);
                }
                Map<Short, List<AnnotationInstance>> originalConstructorParameterAnnotationMapping = originalConstructor.annotations().stream().filter(ai -> ai.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER).collect(Collectors.groupingBy(ai -> ai.target().asMethodParameter().position()));
                ArrayList<ResultHandle> parametersRh = new ArrayList<ResultHandle>();
                for (short i = 0; i < originalConstructor.parameters().size(); i = (short)(i + 1)) {
                    parametersRh.add(constructorCreator.getMethodParam((int)i));
                    AnnotatedElement parameterAnnotations = constructorCreator.getParameterAnnotations((int)i);
                    List originalConstructorParameterAnnotations = originalConstructorParameterAnnotationMapping.getOrDefault(i, Collections.emptyList());
                    for (AnnotationInstance originalConstructorParameterAnnotation : originalConstructorParameterAnnotations) {
                        parameterAnnotations.addAnnotation(originalConstructorParameterAnnotation);
                    }
                }
                constructorCreator.invokeSpecialMethod(MethodDescriptor.of((MethodInfo)originalConstructor), constructorCreator.getThis(), (ResultHandle[])parametersRh.toArray(ResultHandle[]::new));
                constructorCreator.returnValue(null);
            }
            for (DispatchingConfiguration.EventDispatchingMethod eventDispatchingMethod : eventDispatchingMethods) {
                List parameterAnnotations;
                short i;
                AnnotationInstance eventSubscriberInstance = eventDispatchingMethod.getEventSubscriberInstance();
                MethodInfo originalMethod = eventDispatchingMethod.getMethod();
                Map<Short, List<AnnotationInstance>> originalMethodParameterAnnotationMapping = originalMethod.annotations().stream().filter(ai -> ai.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER).collect(Collectors.groupingBy(ai -> ai.target().asMethodParameter().position()));
                if (originalMethod.hasAnnotation(DotNames.OBSERVES) || originalMethod.hasAnnotation(DotNames.OBSERVES_ASYNC)) {
                    LOG.warn((Object)("Methods listening to GitHub events may not be annotated with @Observes or @ObservesAsync. Offending method: " + originalMethod.declaringClass().name() + "#" + originalMethod));
                }
                ArrayList<String> parameterTypes = new ArrayList<String>();
                List originalMethodParameterTypes = originalMethod.parameters();
                short j = 0;
                HashMap<Short, Short> parameterMapping = new HashMap<Short, Short>();
                for (short i2 = 0; i2 < originalMethodParameterTypes.size(); i2 = (short)(i2 + 1)) {
                    List originalMethodAnnotations = originalMethodParameterAnnotationMapping.getOrDefault(i2, Collections.emptyList());
                    if (originalMethodAnnotations.stream().anyMatch(ai -> GitHubAppDotNames.CONFIG_FILE.equals((Object)ai.name()))) continue;
                    parameterTypes.add(((Type)originalMethodParameterTypes.get(i2)).name().toString());
                    parameterMapping.put(i2, j);
                    j = (short)(j + 1);
                }
                if (originalMethod.hasAnnotation(GitHubAppDotNames.CONFIG_FILE)) {
                    parameterTypes.add(ConfigFileReader.class.getName());
                }
                MethodCreator methodCreator = multiplexerClassCreator.getMethodCreator(originalMethod.name() + "_" + HashUtil.sha1((String)eventSubscriberInstance.toString()), (Object)originalMethod.returnType().name().toString(), parameterTypes.toArray());
                ResultHandle[] parameterValues = new ResultHandle[originalMethod.parameters().size()];
                short payloadParameterPosition = 0;
                for (i = 0; i < originalMethodParameterTypes.size(); i = (short)(i + 1)) {
                    parameterAnnotations = originalMethodParameterAnnotationMapping.getOrDefault(i, Collections.emptyList());
                    if (!parameterAnnotations.stream().anyMatch(ai -> ai.name().equals((Object)eventSubscriberInstance.name()))) continue;
                    payloadParameterPosition = i;
                    break;
                }
                for (i = 0; i < originalMethodParameterTypes.size(); i = (short)(i + 1)) {
                    Short generatedParameterIndex;
                    parameterAnnotations = originalMethodParameterAnnotationMapping.getOrDefault(i, Collections.emptyList());
                    if (parameterAnnotations.isEmpty() || (generatedParameterIndex = (Short)parameterMapping.get(i)) == null) continue;
                    AnnotatedElement generatedParameterAnnotations = methodCreator.getParameterAnnotations((int)generatedParameterIndex.shortValue());
                    if (parameterAnnotations.stream().anyMatch(ai -> ai.name().equals((Object)eventSubscriberInstance.name()))) {
                        generatedParameterAnnotations.addAnnotation(DotNames.OBSERVES_ASYNC.toString());
                        generatedParameterAnnotations.addAnnotation(eventSubscriberInstance);
                        continue;
                    }
                    for (AnnotationInstance annotationInstance : parameterAnnotations) {
                        generatedParameterAnnotations.addAnnotation(annotationInstance);
                    }
                }
                for (i = 0; i < originalMethodParameterTypes.size(); i = (short)(i + 1)) {
                    parameterAnnotations = originalMethodParameterAnnotationMapping.getOrDefault(i, Collections.emptyList());
                    if (parameterAnnotations.stream().anyMatch(ai -> ai.name().equals((Object)eventSubscriberInstance.name()))) {
                        parameterValues[i] = methodCreator.getMethodParam((int)((Short)parameterMapping.get(i)).shortValue());
                        continue;
                    }
                    if (parameterAnnotations.stream().anyMatch(ai -> ai.name().equals((Object)GitHubAppDotNames.CONFIG_FILE))) {
                        AnnotationInstance configFileAnnotationInstance = parameterAnnotations.stream().filter(ai -> ai.name().equals((Object)GitHubAppDotNames.CONFIG_FILE)).findFirst().get();
                        String configObjectType = ((Type)originalMethodParameterTypes.get(i)).name().toString();
                        boolean isOptional = false;
                        if (Optional.class.getName().equals(configObjectType)) {
                            if (((Type)originalMethodParameterTypes.get(i)).kind() != Type.Kind.PARAMETERIZED_TYPE) {
                                throw new IllegalStateException("Optional is used but not parameterized for method " + originalMethod.declaringClass().name() + "#" + originalMethod);
                            }
                            isOptional = true;
                            configObjectType = ((Type)((Type)originalMethodParameterTypes.get(i)).asParameterizedType().arguments().get(0)).name().toString();
                        }
                        ResultHandle configFileReaderRh = methodCreator.getMethodParam(parameterTypes.size() - 1);
                        ResultHandle ghRepositoryRh = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(PayloadHelper.class, (String)"getRepository", GHRepository.class, (Class[])new Class[]{GHEventPayload.class}), new ResultHandle[]{methodCreator.getMethodParam((int)((Short)parameterMapping.get(payloadParameterPosition)).shortValue())});
                        ResultHandle configObject = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(ConfigFileReader.class, (String)"getConfigObject", Object.class, (Class[])new Class[]{GHRepository.class, String.class, Class.class}), configFileReaderRh, new ResultHandle[]{ghRepositoryRh, methodCreator.load(configFileAnnotationInstance.value().asString()), methodCreator.loadClass(configObjectType)});
                        configObject = methodCreator.checkCast(configObject, configObjectType);
                        if (isOptional) {
                            configObject = methodCreator.invokeStaticMethod(MethodDescriptor.ofMethod(Optional.class, (String)"ofNullable", Optional.class, (Class[])new Class[]{Object.class}), new ResultHandle[]{configObject});
                        }
                        parameterValues[i] = configObject;
                        continue;
                    }
                    parameterValues[i] = methodCreator.getMethodParam((int)((Short)parameterMapping.get(i)).shortValue());
                }
                ResultHandle returnValue = methodCreator.invokeVirtualMethod(originalMethod, methodCreator.getThis(), parameterValues);
                methodCreator.returnValue(returnValue);
            }
            multiplexerClassCreator.close();
        }
    }

    private static ResultHandle fireAsyncAction(BytecodeCreator bytecodeCreator, LaunchMode launchMode, String className, ResultHandle gitHubEventRh, ResultHandle payloadInstanceRh, ResultHandle annotationLiteralArrayRh) {
        ResultHandle cdiEventRh = bytecodeCreator.invokeInterfaceMethod(EVENT_SELECT, bytecodeCreator.readInstanceField(FieldDescriptor.of((String)className, (String)EVENT_EMITTER_FIELD, Event.class), bytecodeCreator.getThis()), new ResultHandle[]{annotationLiteralArrayRh});
        ResultHandle fireAsyncCompletionStageRH = bytecodeCreator.invokeInterfaceMethod(EVENT_FIRE_ASYNC, cdiEventRh, new ResultHandle[]{payloadInstanceRh});
        ResultHandle exceptionallyRH = bytecodeCreator.invokeInterfaceMethod(COMPLETION_STAGE_EXCEPTIONALLY, fireAsyncCompletionStageRH, new ResultHandle[]{bytecodeCreator.newInstance(MethodDescriptor.ofConstructor(ErrorHandlerBridgeFunction.class, (Class[])new Class[]{GitHubEvent.class, GHEventPayload.class}), new ResultHandle[]{gitHubEventRh, payloadInstanceRh})});
        if (LaunchMode.TEST.equals((Object)launchMode)) {
            ResultHandle toFutureRH = bytecodeCreator.invokeInterfaceMethod(COMPLETION_STAGE_TO_COMPLETABLE_FUTURE, exceptionallyRH, new ResultHandle[0]);
            return bytecodeCreator.invokeVirtualMethod(COMPLETABLE_FUTURE_JOIN, toFutureRH, new ResultHandle[0]);
        }
        return exceptionallyRH;
    }

    private static String getLiteralClassName(DotName annotationName) {
        return annotationName + "_AnnotationLiteral";
    }

    private static void systemOutPrintln(BytecodeCreator bytecodeCreator, ResultHandle resultHandle) {
        bytecodeCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(PrintStream.class, (String)"println", Void.TYPE, (Class[])new Class[]{String.class}), bytecodeCreator.readStaticField(FieldDescriptor.of(System.class, (String)"out", PrintStream.class)), new ResultHandle[]{bytecodeCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(Object.class, (String)"toString", String.class, (Class[])new Class[0]), resultHandle, new ResultHandle[0])});
    }
}

