/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.deployment;

import com.github.benmanes.caffeine.cache.CacheLoader;
import io.quarkiverse.githubapp.ConfigFile;
import io.quarkiverse.githubapp.GitHubEvent;
import io.quarkiverse.githubapp.TokenGitHubClients;
import io.quarkiverse.githubapp.deployment.AdditionalEventDispatchingClassesIndexBuildItem;
import io.quarkiverse.githubapp.deployment.DispatchingConfiguration;
import io.quarkiverse.githubapp.deployment.EventDefinition;
import io.quarkiverse.githubapp.deployment.GitHubAppBuildTimeConfig;
import io.quarkiverse.githubapp.deployment.GitHubAppDotNames;
import io.quarkiverse.githubapp.deployment.GitHubAppOpenTelemetryMetricsIntegrationEnabledBuildItem;
import io.quarkiverse.githubapp.deployment.GitHubAppOpenTelemetryTracesIntegrationEnabledBuildItem;
import io.quarkiverse.githubapp.deployment.VetoUserDefinedEventListeningClassesAnnotationsTransformer;
import io.quarkiverse.githubapp.error.ErrorHandler;
import io.quarkiverse.githubapp.runtime.GitHubAppRecorder;
import io.quarkiverse.githubapp.runtime.MultiplexedEvent;
import io.quarkiverse.githubapp.runtime.Multiplexer;
import io.quarkiverse.githubapp.runtime.RequestScopeCachingGitHubConfigFileProvider;
import io.quarkiverse.githubapp.runtime.Routes;
import io.quarkiverse.githubapp.runtime.UtilsProducer;
import io.quarkiverse.githubapp.runtime.config.CheckedConfigProvider;
import io.quarkiverse.githubapp.runtime.error.DefaultErrorHandler;
import io.quarkiverse.githubapp.runtime.error.ErrorHandlerBridgeFunction;
import io.quarkiverse.githubapp.runtime.github.DefaultJavaHttpClientFactory;
import io.quarkiverse.githubapp.runtime.github.GitHubConfigFileProviderImpl;
import io.quarkiverse.githubapp.runtime.github.GitHubFileDownloader;
import io.quarkiverse.githubapp.runtime.github.GitHubService;
import io.quarkiverse.githubapp.runtime.github.PayloadHelper;
import io.quarkiverse.githubapp.runtime.replay.ReplayEvent;
import io.quarkiverse.githubapp.runtime.replay.ReplayEventsRoute;
import io.quarkiverse.githubapp.runtime.signing.JwtTokenCreator;
import io.quarkiverse.githubapp.runtime.signing.PayloadSignatureChecker;
import io.quarkiverse.githubapp.runtime.smee.SmeeIoForwarder;
import io.quarkiverse.githubapp.runtime.telemetry.noop.NoopTelemetryMetricsReporter;
import io.quarkiverse.githubapp.runtime.telemetry.noop.NoopTelemetryTracesReporter;
import io.quarkiverse.githubapp.telemetry.TelemetryMetricsReporter;
import io.quarkiverse.githubapp.telemetry.TelemetryScopeWrapper;
import io.quarkiverse.githubapp.telemetry.TelemetrySpanWrapper;
import io.quarkiverse.githubapp.telemetry.TelemetryTracesReporter;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.MethodDescriptors;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AdditionalIndexedClassesBuildItem;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.gizmo.AnnotatedElement;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.SignatureBuilder;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.gizmo.Type;
import io.quarkus.maven.dependency.GACT;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.util.HashUtil;
import io.quarkus.vertx.http.deployment.HttpRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.deployment.webjar.WebJarBuildItem;
import io.quarkus.vertx.http.deployment.webjar.WebJarResultsBuildItem;
import io.smallrye.graphql.client.dynamic.api.DynamicGraphQLClient;
import io.vertx.core.Handler;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationTransformation;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;
import org.kohsuke.github.GHEventPayload;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

class GitHubAppProcessor {
    private static final Logger LOG = Logger.getLogger(GitHubAppProcessor.class);
    private static final String FEATURE = "github-app";
    private static final String EVENT_EMITTER_FIELD = "eventEmitter";
    private static final String GITHUB_SERVICE_FIELD = "gitHubService";
    private static final MethodDescriptor EVENT_SELECT = MethodDescriptor.ofMethod(Event.class, (String)"select", Event.class, (Class[])new Class[]{Annotation[].class});
    private static final MethodDescriptor EVENT_FIRE_ASYNC = MethodDescriptor.ofMethod(Event.class, (String)"fireAsync", CompletionStage.class, (Class[])new Class[]{Object.class});
    private static final MethodDescriptor COMPLETION_STAGE_TO_COMPLETABLE_FUTURE = MethodDescriptor.ofMethod(CompletionStage.class, (String)"toCompletableFuture", CompletableFuture.class, (Class[])new Class[0]);
    private static final MethodDescriptor COMPLETABLE_FUTURE_JOIN = MethodDescriptor.ofMethod(CompletableFuture.class, (String)"join", Object.class, (Class[])new Class[0]);
    private static final String ARRAY_INSTANCE_FIELD_NAME = "ARRAY_INSTANCE";
    private static final DotName WITH_BRIDGE_METHODS = DotName.createSimple((String)"com.infradna.tool.bridge_method_injector.WithBridgeMethods");
    private static final GACT QUARKIVERSE_GITHUB_APP_GACT = new GACT("io.quarkiverse.githubapp", "quarkus-github-app-ui", null, "jar");
    private static final String REPLAY_UI_RESOURCES_PREFIX = "META-INF/resources/replay-ui/";
    private static final String REPLAY_UI_PATH = "replay";

    GitHubAppProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    AdditionalIndexedClassesBuildItem additionalIndexedClasses() {
        return new AdditionalIndexedClassesBuildItem(new String[]{GitHubEvent.class.getName(), ReplayEvent.class.getName(), ConfigFile.class.getName()});
    }

    @BuildStep
    void registerForReflection(CombinedIndexBuildItem combinedIndex, List<AdditionalEventDispatchingClassesIndexBuildItem> additionalEventDispatchingIndexes, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchies) {
        ArrayList<IndexView> indexes = new ArrayList<IndexView>();
        indexes.add(combinedIndex.getIndex());
        additionalEventDispatchingIndexes.forEach(i -> indexes.add(i.getIndex()));
        CompositeIndex index = CompositeIndex.create(indexes);
        for (AnnotationInstance configFileAnnotationInstance : index.getAnnotations(GitHubAppDotNames.CONFIG_FILE)) {
            MethodParameterInfo methodParameter = configFileAnnotationInstance.target().asMethodParameter();
            short parameterPosition = methodParameter.position();
            org.jboss.jandex.Type parameterType = (org.jboss.jandex.Type)methodParameter.method().parameterTypes().get(parameterPosition);
            reflectiveHierarchies.produce((BuildItem)ReflectiveHierarchyBuildItem.builder((org.jboss.jandex.Type)parameterType).index((IndexView)index).source(GitHubAppProcessor.class.getSimpleName() + " > " + String.valueOf(methodParameter.method().declaringClass()) + "#" + String.valueOf(methodParameter.method())).build());
        }
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"com.github.benmanes.caffeine.cache.SSMSA", "com.github.benmanes.caffeine.cache.PSWMS"}).methods(true).fields(true).build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{CacheLoader.class}).methods(true).build());
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{GitHubService.class.getName() + "$CreateInstallationToken"}).methods(true).build());
    }

    @BuildStep
    void additionalBeans(CombinedIndexBuildItem index, Capabilities capabilities, GitHubAppBuildTimeConfig gitHubAppBuildTimeConfig, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<GitHubAppOpenTelemetryTracesIntegrationEnabledBuildItem> openTelemetryTracesIntegrationEnabled, BuildProducer<GitHubAppOpenTelemetryMetricsIntegrationEnabledBuildItem> openTelemetryMetricsIntegrationEnabled) {
        AdditionalBeanBuildItem.Builder additionalBeanBuildItemBuilder = new AdditionalBeanBuildItem.Builder().addBeanClasses(new Class[]{Routes.class, UtilsProducer.class, RequestScopeCachingGitHubConfigFileProvider.class, Multiplexer.class, SmeeIoForwarder.class, PayloadSignatureChecker.class, JwtTokenCreator.class, GitHubService.class, DefaultErrorHandler.class, GitHubFileDownloader.class, GitHubConfigFileProviderImpl.class, CheckedConfigProvider.class, TokenGitHubClients.class}).setUnremovable();
        for (ClassInfo errorHandler : index.getIndex().getAllKnownImplementations(GitHubAppDotNames.ERROR_HANDLER)) {
            additionalBeanBuildItemBuilder.addBeanClass(errorHandler.name().toString());
        }
        if (capabilities.isPresent("io.quarkus.opentelemetry.tracer") && gitHubAppBuildTimeConfig.telemetry().tracesEnabled().orElse(true).booleanValue()) {
            openTelemetryTracesIntegrationEnabled.produce((BuildItem)new GitHubAppOpenTelemetryTracesIntegrationEnabledBuildItem());
            additionalBeanBuildItemBuilder.addBeanClass(GitHubAppDotNames.OPENTELEMETRY_TRACES_REPORTER.toString());
            if (QuarkusClassLoader.isClassPresentAtRuntime((String)GitHubAppDotNames.JAVA_HTTP_CLIENT_TELEMETRY.toString())) {
                additionalBeanBuildItemBuilder.addBeanClass(GitHubAppDotNames.OPENTELEMETRY_JAVA_HTTP_CLIENT_FACTORY.toString());
            } else {
                additionalBeanBuildItemBuilder.addBeanClass(DefaultJavaHttpClientFactory.class);
            }
        } else {
            additionalBeanBuildItemBuilder.addBeanClass(NoopTelemetryTracesReporter.class);
            additionalBeanBuildItemBuilder.addBeanClass(DefaultJavaHttpClientFactory.class);
        }
        if (capabilities.isPresent("io.quarkus.opentelemetry.metrics") && gitHubAppBuildTimeConfig.telemetry().metricsEnabled().orElse(true).booleanValue()) {
            openTelemetryMetricsIntegrationEnabled.produce((BuildItem)new GitHubAppOpenTelemetryMetricsIntegrationEnabledBuildItem());
            additionalBeanBuildItemBuilder.addBeanClass(GitHubAppDotNames.OPENTELEMETRY_METRICS_REPORTER.toString());
        } else {
            additionalBeanBuildItemBuilder.addBeanClass(NoopTelemetryMetricsReporter.class);
        }
        additionalBeans.produce((BuildItem)additionalBeanBuildItemBuilder.build());
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void additionalBeansDevMode(CombinedIndexBuildItem index, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        AdditionalBeanBuildItem.Builder additionalBeanBuildItemBuilder = new AdditionalBeanBuildItem.Builder().addBeanClasses(new Class[]{ReplayEventsRoute.class}).setUnremovable();
        additionalBeans.produce((BuildItem)additionalBeanBuildItemBuilder.build());
    }

    @BuildStep
    void removeCompatibilityBridgeMethodsFromGitHubApi(CombinedIndexBuildItem combinedIndex, BuildProducer<BytecodeTransformerBuildItem> bytecodeTransformers) {
        HashMap<String, Set> bridgeMethodsByClassName = new HashMap<String, Set>();
        for (AnnotationInstance annotationInstance : combinedIndex.getIndex().getAnnotations(WITH_BRIDGE_METHODS)) {
            if (annotationInstance.target().kind() != AnnotationTarget.Kind.METHOD) continue;
            String className = annotationInstance.target().asMethod().declaringClass().name().toString();
            bridgeMethodsByClassName.computeIfAbsent(className, cn -> new HashSet()).add(annotationInstance.target().asMethod().name());
        }
        for (Map.Entry entry : bridgeMethodsByClassName.entrySet()) {
            bytecodeTransformers.produce((BuildItem)new BytecodeTransformerBuildItem.Builder().setClassToTransform((String)entry.getKey()).setVisitorFunction((ignored, visitor) -> new RemoveBridgeMethodsClassVisitor((ClassVisitor)visitor, (String)bridgeMethodsByClassNameEntry.getKey(), (Set)bridgeMethodsByClassNameEntry.getValue())).build());
        }
    }

    @BuildStep
    void generateClasses(CombinedIndexBuildItem combinedIndex, LaunchModeBuildItem launchMode, List<AdditionalEventDispatchingClassesIndexBuildItem> additionalEventDispatchingIndexes, Optional<GitHubAppOpenTelemetryTracesIntegrationEnabledBuildItem> openTelemetryTracesIntegrationEnabled, Optional<GitHubAppOpenTelemetryMetricsIntegrationEnabledBuildItem> openTelemetryMetricsIntegrationEnabled, BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformer) {
        ArrayList<IndexView> indexes = new ArrayList<IndexView>();
        indexes.add(combinedIndex.getIndex());
        additionalEventDispatchingIndexes.forEach(i -> indexes.add(i.getIndex()));
        CompositeIndex index = CompositeIndex.create(indexes);
        Collection<EventDefinition> allEventDefinitions = GitHubAppProcessor.getAllEventDefinitions((IndexView)index);
        annotationsTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem((AnnotationTransformation)new VetoUserDefinedEventListeningClassesAnnotationsTransformer(allEventDefinitions.stream().map(EventDefinition::getAnnotation).collect(Collectors.toSet()))));
        String[] subscriberAnnotations = (String[])allEventDefinitions.stream().map(d -> d.getAnnotation().toString()).toArray(String[]::new);
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(subscriberAnnotations));
        DispatchingConfiguration dispatchingConfiguration = GitHubAppProcessor.getDispatchingConfiguration((IndexView)index, allEventDefinitions);
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClasses, true);
        GitHubAppProcessor.generateAnnotationLiterals((ClassOutput)classOutput, dispatchingConfiguration);
        GeneratedBeanGizmoAdaptor beanClassOutput = new GeneratedBeanGizmoAdaptor(generatedBeans);
        GitHubAppProcessor.generateDispatcher((ClassOutput)beanClassOutput, launchMode, dispatchingConfiguration, reflectiveClasses);
        GitHubAppProcessor.generateMultiplexers((ClassOutput)beanClassOutput, (IndexView)index, dispatchingConfiguration, openTelemetryTracesIntegrationEnabled.isPresent(), openTelemetryMetricsIntegrationEnabled.isPresent(), reflectiveClasses);
    }

    @BuildStep
    void replayUiDeployment(LaunchModeBuildItem launchMode, BuildProducer<WebJarBuildItem> webJars) throws IOException {
        if (launchMode.getLaunchMode() != LaunchMode.DEVELOPMENT) {
            return;
        }
        webJars.produce((BuildItem)WebJarBuildItem.builder().artifactKey(QUARKIVERSE_GITHUB_APP_GACT).root(REPLAY_UI_RESOURCES_PREFIX).build());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void replayUi(GitHubAppRecorder recorder, LaunchModeBuildItem launchMode, WebJarResultsBuildItem webJarResults, HttpRootPathBuildItem httpRootPath, ShutdownContextBuildItem shutdownContext, BuildProducer<RouteBuildItem> routes) throws IOException {
        if (launchMode.getLaunchMode() != LaunchMode.DEVELOPMENT) {
            return;
        }
        WebJarResultsBuildItem.WebJarResult webJarResult = webJarResults.byArtifactKey(QUARKIVERSE_GITHUB_APP_GACT);
        if (webJarResult == null) {
            return;
        }
        String replayUiPath = httpRootPath.resolvePath(REPLAY_UI_PATH);
        Handler handler = recorder.replayUiHandler(webJarResult.getFinalDestination(), replayUiPath, webJarResult.getWebRootConfigurations(), (ShutdownContext)shutdownContext);
        routes.produce((BuildItem)httpRootPath.routeBuilder().route(REPLAY_UI_PATH).handler(handler).displayOnNotFoundPage("Replay UI").build());
        routes.produce((BuildItem)httpRootPath.routeBuilder().route("replay/*").handler(handler).build());
    }

    private static Collection<EventDefinition> getAllEventDefinitions(IndexView index) {
        ArrayList<EventDefinition> mainEventDefinitions = new ArrayList<EventDefinition>();
        ArrayList<EventDefinition> allEventDefinitions = new ArrayList<EventDefinition>();
        for (AnnotationInstance eventInstance : index.getAnnotations(GitHubAppDotNames.EVENT)) {
            if (eventInstance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            mainEventDefinitions.add(new EventDefinition(eventInstance.target().asClass().name(), eventInstance.value("name").asString(), null, eventInstance.value("payload").asClass().name()));
        }
        allEventDefinitions.addAll(mainEventDefinitions);
        for (EventDefinition mainEventDefinition : mainEventDefinitions) {
            for (AnnotationInstance eventInstance : index.getAnnotations(mainEventDefinition.getAnnotation())) {
                if (eventInstance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
                AnnotationValue actionValue = eventInstance.value();
                allEventDefinitions.add(new EventDefinition(eventInstance.target().asClass().name(), mainEventDefinition.getEvent(), actionValue != null ? actionValue.asString() : null, mainEventDefinition.getPayloadType()));
            }
        }
        return allEventDefinitions;
    }

    private static DispatchingConfiguration getDispatchingConfiguration(IndexView index, Collection<EventDefinition> allEventDefinitions) {
        DispatchingConfiguration configuration = new DispatchingConfiguration();
        for (EventDefinition eventDefinition : allEventDefinitions) {
            List<AnnotationInstance> eventSubscriberInstances = index.getAnnotations(eventDefinition.getAnnotation()).stream().filter(ai -> ai.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER).filter(ai -> !Modifier.isInterface(ai.target().asMethodParameter().method().declaringClass().flags())).toList();
            for (AnnotationInstance eventSubscriberInstance : eventSubscriberInstances) {
                String action = eventDefinition.getAction() != null ? eventDefinition.getAction() : (eventSubscriberInstance.value() != null ? eventSubscriberInstance.value().asString() : "*");
                MethodParameterInfo annotatedParameter = eventSubscriberInstance.target().asMethodParameter();
                MethodInfo methodInfo = annotatedParameter.method();
                DotName annotatedParameterType = ((org.jboss.jandex.Type)annotatedParameter.method().parameterTypes().get(annotatedParameter.position())).name();
                if (!eventDefinition.getPayloadType().equals((Object)annotatedParameterType) && !GitHubAppDotNames.GITHUB_EVENT.equals((Object)annotatedParameterType)) {
                    throw new IllegalStateException("Parameter subscribing to a GitHub '" + eventDefinition.getEvent() + "' event must be of type '" + String.valueOf(eventDefinition.getPayloadType()) + "' or '" + String.valueOf(GitHubAppDotNames.GITHUB_EVENT) + "'. Offending method: " + String.valueOf(methodInfo.declaringClass().name()) + "#" + String.valueOf(methodInfo));
                }
                configuration.getOrCreateEventConfiguration(eventDefinition.getEvent(), eventDefinition.getPayloadType().toString()).addEventAnnotation(action, eventSubscriberInstance, eventSubscriberInstance.valuesWithDefaults(index));
                configuration.addEventDispatchingMethod(new DispatchingConfiguration.EventDispatchingMethod(eventSubscriberInstance, methodInfo));
            }
        }
        List<AnnotationInstance> rawEventSubscriberInstances = index.getAnnotations(GitHubAppDotNames.RAW_EVENT).stream().filter(ai -> ai.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER).filter(ai -> !Modifier.isInterface(ai.target().asMethodParameter().method().declaringClass().flags())).toList();
        for (AnnotationInstance rawEventSubscriberInstance : rawEventSubscriberInstances) {
            String event = rawEventSubscriberInstance.valueWithDefault(index, "event").asString();
            String action = rawEventSubscriberInstance.valueWithDefault(index, "action").asString();
            MethodParameterInfo annotatedParameter = rawEventSubscriberInstance.target().asMethodParameter();
            MethodInfo methodInfo = annotatedParameter.method();
            DotName annotatedParameterType = ((org.jboss.jandex.Type)annotatedParameter.method().parameterTypes().get(annotatedParameter.position())).name();
            if (!GitHubAppDotNames.GITHUB_EVENT.equals((Object)annotatedParameterType)) {
                throw new IllegalStateException("Parameter subscribing to a GitHub raw event must be of type '" + String.valueOf(GitHubAppDotNames.GITHUB_EVENT) + "'. Offending method: " + String.valueOf(methodInfo.declaringClass().name()) + "#" + String.valueOf(methodInfo));
            }
            configuration.getOrCreateEventConfiguration(event, null).addEventAnnotation(action, rawEventSubscriberInstance, rawEventSubscriberInstance.valuesWithDefaults(index));
            configuration.addEventDispatchingMethod(new DispatchingConfiguration.EventDispatchingMethod(rawEventSubscriberInstance, methodInfo));
        }
        return configuration;
    }

    private static void generateAnnotationLiterals(ClassOutput classOutput, DispatchingConfiguration dispatchingConfiguration) {
        for (DispatchingConfiguration.EventDispatchingConfiguration eventDispatchingConfiguration : dispatchingConfiguration.getEventConfigurations().values()) {
            for (DispatchingConfiguration.EventAnnotationLiteral eventAnnotationLiteral : eventDispatchingConfiguration.getEventAnnotationLiterals()) {
                String literalClassName = GitHubAppProcessor.getLiteralClassName(eventAnnotationLiteral.getName());
                String signature = SignatureBuilder.forClass().setSuperClass(Type.parameterizedType((Type.ClassType)Type.classType(AnnotationLiteral.class), (Type[])new Type[]{Type.classType((DotName)eventAnnotationLiteral.getName())})).addInterface(Type.classType((DotName)eventAnnotationLiteral.getName())).build();
                ClassCreator literalClassCreator = ClassCreator.builder().classOutput(classOutput).className(literalClassName).signature(signature).superClass(AnnotationLiteral.class).interfaces(new String[]{eventAnnotationLiteral.getName().toString()}).build();
                Object[] parameterTypes = new Class[eventAnnotationLiteral.getAttributes().size()];
                Arrays.fill(parameterTypes, String.class);
                MethodCreator constructorCreator = literalClassCreator.getMethodCreator("<init>", (Object)"V", parameterTypes);
                constructorCreator.invokeSpecialMethod(MethodDescriptor.ofConstructor(AnnotationLiteral.class, (Class[])new Class[0]), constructorCreator.getThis(), new ResultHandle[0]);
                for (int i = 0; i < eventAnnotationLiteral.getAttributes().size(); ++i) {
                    constructorCreator.writeInstanceField(FieldDescriptor.of((String)literalClassName, (String)eventAnnotationLiteral.getAttributes().get(i), String.class), constructorCreator.getThis(), constructorCreator.getMethodParam(i));
                    constructorCreator.setModifiers(1);
                }
                constructorCreator.returnValue(null);
                for (String attribute : eventAnnotationLiteral.getAttributes()) {
                    literalClassCreator.getFieldCreator(attribute, String.class).setModifiers(2);
                    MethodCreator getterCreator = literalClassCreator.getMethodCreator(attribute, String.class, new Class[0]);
                    getterCreator.setModifiers(1);
                    getterCreator.returnValue(getterCreator.readInstanceField(FieldDescriptor.of((String)literalClassName, (String)attribute, String.class), getterCreator.getThis()));
                }
                if (eventAnnotationLiteral.getAttributes().isEmpty()) {
                    FieldCreator arrayInstanceFieldCreator = literalClassCreator.getFieldCreator(ARRAY_INSTANCE_FIELD_NAME, "[L" + literalClassName + ";");
                    arrayInstanceFieldCreator.setModifiers(25);
                    MethodCreator clinit = literalClassCreator.getMethodCreator("<clinit>", Void.TYPE, new Class[0]);
                    clinit.setModifiers(8);
                    ResultHandle singletonInstance = clinit.newArray(literalClassName, 1);
                    clinit.writeArrayValue(singletonInstance, clinit.load(0), clinit.newInstance(constructorCreator.getMethodDescriptor(), new ResultHandle[0]));
                    clinit.writeStaticField(arrayInstanceFieldCreator.getFieldDescriptor(), singletonInstance);
                    clinit.returnVoid();
                }
                literalClassCreator.close();
            }
        }
    }

    private static void generateDispatcher(ClassOutput beanClassOutput, LaunchModeBuildItem launchMode, DispatchingConfiguration dispatchingConfiguration, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        String dispatcherClassName = GitHubEvent.class.getName() + "DispatcherImpl";
        reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{dispatcherClassName}).methods(true).fields(true).build());
        ClassCreator dispatcherClassCreator = ClassCreator.builder().classOutput(beanClassOutput).className(dispatcherClassName).build();
        dispatcherClassCreator.addAnnotation(Singleton.class);
        FieldCreator eventFieldCreator = dispatcherClassCreator.getFieldCreator(EVENT_EMITTER_FIELD, Event.class);
        eventFieldCreator.addAnnotation(Inject.class);
        eventFieldCreator.setModifiers(4);
        eventFieldCreator.setSignature(SignatureBuilder.forField().setType((Type)Type.parameterizedType((Type.ClassType)Type.classType(Event.class), (Type[])new Type[]{Type.classType(MultiplexedEvent.class)})).build());
        FieldCreator gitHubServiceFieldCreator = dispatcherClassCreator.getFieldCreator(GITHUB_SERVICE_FIELD, GitHubService.class);
        gitHubServiceFieldCreator.addAnnotation(Inject.class);
        gitHubServiceFieldCreator.setModifiers(4);
        MethodCreator dispatchMethodCreator = dispatcherClassCreator.getMethodCreator("dispatch", Void.TYPE, new Class[]{GitHubEvent.class});
        dispatchMethodCreator.setModifiers(1);
        dispatchMethodCreator.getParameterAnnotations(0).addAnnotation(DotNames.OBSERVES.toString());
        ResultHandle gitHubEventRh = dispatchMethodCreator.getMethodParam(0);
        ResultHandle installationIdRh = dispatchMethodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(GitHubEvent.class, (String)"getInstallationId", Long.class, (Class[])new Class[0]), gitHubEventRh, new ResultHandle[0]);
        ResultHandle dispatchedEventRh = dispatchMethodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(GitHubEvent.class, (String)"getEvent", String.class, (Class[])new Class[0]), gitHubEventRh, new ResultHandle[0]);
        ResultHandle dispatchedActionRh = dispatchMethodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(GitHubEvent.class, (String)"getAction", String.class, (Class[])new Class[0]), gitHubEventRh, new ResultHandle[0]);
        ResultHandle dispatchedPayloadRh = dispatchMethodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(GitHubEvent.class, (String)"getPayload", String.class, (Class[])new Class[0]), gitHubEventRh, new ResultHandle[0]);
        TryBlock tryBlock = dispatchMethodCreator.tryBlock();
        AssignableResultHandle gitHubRh = tryBlock.createVariable(GitHub.class);
        AssignableResultHandle gitHubGraphQLClientRh = tryBlock.createVariable(DynamicGraphQLClient.class);
        BranchResult testInstallationId = tryBlock.ifNotNull(installationIdRh);
        BytecodeCreator installationIdSet = testInstallationId.trueBranch();
        installationIdSet.assign(gitHubRh, installationIdSet.invokeVirtualMethod(MethodDescriptor.ofMethod(GitHubService.class, (String)"getInstallationClient", GitHub.class, (Class[])new Class[]{Long.TYPE}), installationIdSet.readInstanceField(FieldDescriptor.of((String)dispatcherClassCreator.getClassName(), (String)GITHUB_SERVICE_FIELD, GitHubService.class), installationIdSet.getThis()), new ResultHandle[]{installationIdRh}));
        if (dispatchingConfiguration.requiresGraphQLClient()) {
            installationIdSet.assign(gitHubGraphQLClientRh, installationIdSet.invokeVirtualMethod(MethodDescriptor.ofMethod(GitHubService.class, (String)"getInstallationGraphQLClient", DynamicGraphQLClient.class, (Class[])new Class[]{Long.TYPE}), installationIdSet.readInstanceField(FieldDescriptor.of((String)dispatcherClassCreator.getClassName(), (String)GITHUB_SERVICE_FIELD, GitHubService.class), installationIdSet.getThis()), new ResultHandle[]{installationIdRh}));
        } else {
            installationIdSet.assign(gitHubGraphQLClientRh, installationIdSet.loadNull());
        }
        BytecodeCreator installationIdNull = testInstallationId.falseBranch();
        installationIdNull.assign(gitHubRh, installationIdNull.invokeVirtualMethod(MethodDescriptor.ofMethod(GitHubService.class, (String)"getTokenOrApplicationClient", GitHub.class, (Class[])new Class[0]), installationIdNull.readInstanceField(FieldDescriptor.of((String)dispatcherClassCreator.getClassName(), (String)GITHUB_SERVICE_FIELD, GitHubService.class), installationIdNull.getThis()), new ResultHandle[0]));
        if (dispatchingConfiguration.requiresGraphQLClient()) {
            installationIdNull.assign(gitHubGraphQLClientRh, installationIdNull.invokeVirtualMethod(MethodDescriptor.ofMethod(GitHubService.class, (String)"getTokenGraphQLClientOrNull", DynamicGraphQLClient.class, (Class[])new Class[0]), installationIdNull.readInstanceField(FieldDescriptor.of((String)dispatcherClassCreator.getClassName(), (String)GITHUB_SERVICE_FIELD, GitHubService.class), installationIdNull.getThis()), new ResultHandle[0]));
        } else {
            installationIdNull.assign(gitHubGraphQLClientRh, installationIdNull.loadNull());
        }
        for (DispatchingConfiguration.EventDispatchingConfiguration eventDispatchingConfiguration : dispatchingConfiguration.getEventConfigurations().values()) {
            ResultHandle eventRh = tryBlock.load(eventDispatchingConfiguration.getEvent());
            String payloadType = eventDispatchingConfiguration.getPayloadType();
            Object eventMatchesCreator = "*".equals(eventDispatchingConfiguration.getEvent()) ? tryBlock : tryBlock.ifTrue(tryBlock.invokeVirtualMethod(MethodDescriptors.OBJECT_EQUALS, eventRh, new ResultHandle[]{dispatchedEventRh})).trueBranch();
            ResultHandle payloadInstanceRh = payloadType != null ? eventMatchesCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(GitHub.class, (String)"parseEventPayload", GHEventPayload.class, (Class[])new Class[]{Reader.class, Class.class}), (ResultHandle)gitHubRh, new ResultHandle[]{eventMatchesCreator.newInstance(MethodDescriptor.ofConstructor(StringReader.class, (Class[])new Class[]{String.class}), new ResultHandle[]{dispatchedPayloadRh}), eventMatchesCreator.loadClass(payloadType)}) : eventMatchesCreator.loadNull();
            ResultHandle multiplexedEventRh = eventMatchesCreator.newInstance(MethodDescriptor.ofConstructor(MultiplexedEvent.class, (Class[])new Class[]{GitHubEvent.class, GHEventPayload.class, GitHub.class, DynamicGraphQLClient.class}), new ResultHandle[]{gitHubEventRh, payloadInstanceRh, gitHubRh, gitHubGraphQLClientRh});
            for (Map.Entry<String, Set<DispatchingConfiguration.EventAnnotation>> eventAnnotationsEntry : eventDispatchingConfiguration.getEventAnnotations().entrySet()) {
                String action = eventAnnotationsEntry.getKey();
                for (DispatchingConfiguration.EventAnnotation eventAnnotation : eventAnnotationsEntry.getValue()) {
                    ResultHandle annotationLiteralArrayRh;
                    String literalClassName = GitHubAppProcessor.getLiteralClassName(eventAnnotation.getName());
                    if (eventAnnotation.getValues().isEmpty()) {
                        annotationLiteralArrayRh = eventMatchesCreator.readStaticField(FieldDescriptor.of((String)literalClassName, (String)ARRAY_INSTANCE_FIELD_NAME, (String)("[L" + literalClassName + ";")));
                    } else {
                        Object[] literalParameterTypes = new Class[eventAnnotation.getValues().size()];
                        Arrays.fill(literalParameterTypes, String.class);
                        ArrayList<ResultHandle> literalParameters = new ArrayList<ResultHandle>(eventAnnotation.getValues().size());
                        for (AnnotationValue eventAnnotationValue : eventAnnotation.getValues()) {
                            literalParameters.add(eventMatchesCreator.load(eventAnnotationValue.asString()));
                        }
                        ResultHandle annotationLiteralRh = eventMatchesCreator.newInstance(MethodDescriptor.ofConstructor((Object)literalClassName, (Object[])literalParameterTypes), (ResultHandle[])literalParameters.toArray(ResultHandle[]::new));
                        annotationLiteralArrayRh = eventMatchesCreator.newArray(Annotation.class, 1);
                        eventMatchesCreator.writeArrayValue(annotationLiteralArrayRh, 0, annotationLiteralRh);
                    }
                    if ("*".equals(action)) {
                        GitHubAppProcessor.fireAsyncAction((BytecodeCreator)eventMatchesCreator, launchMode.getLaunchMode(), dispatcherClassCreator.getClassName(), gitHubEventRh, multiplexedEventRh, annotationLiteralArrayRh);
                        continue;
                    }
                    BytecodeCreator actionMatchesCreator = eventMatchesCreator.ifTrue(eventMatchesCreator.invokeVirtualMethod(MethodDescriptors.OBJECT_EQUALS, eventMatchesCreator.load(action), new ResultHandle[]{dispatchedActionRh})).trueBranch();
                    GitHubAppProcessor.fireAsyncAction(actionMatchesCreator, launchMode.getLaunchMode(), dispatcherClassCreator.getClassName(), gitHubEventRh, multiplexedEventRh, annotationLiteralArrayRh);
                }
            }
        }
        CatchBlockCreator catchBlockCreator = tryBlock.addCatch(Throwable.class);
        catchBlockCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(ErrorHandlerBridgeFunction.class, (String)"apply", Void.class, (Class[])new Class[]{GitHubEvent.class, Throwable.class}), catchBlockCreator.readStaticField(FieldDescriptor.of(ErrorHandlerBridgeFunction.class, (String)"INSTANCE", ErrorHandlerBridgeFunction.class)), new ResultHandle[]{gitHubEventRh, catchBlockCreator.getCaughtException()});
        dispatchMethodCreator.returnValue(null);
        dispatcherClassCreator.close();
    }

    private static void generateMultiplexers(ClassOutput beanClassOutput, IndexView index, DispatchingConfiguration dispatchingConfiguration, boolean openTelemetryTracesIntegrationEnabled, boolean openTelemetryMetricsIntegrationEnabled, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        for (Map.Entry<DotName, TreeSet<DispatchingConfiguration.EventDispatchingMethod>> eventDispatchingMethodsEntry : dispatchingConfiguration.getMethods().entrySet()) {
            FieldDescriptor telemetryMetricsReporterFieldDescriptor;
            FieldDescriptor telemetryTracesReporterFieldDescriptor;
            DotName declaringClassName = eventDispatchingMethodsEntry.getKey();
            TreeSet<DispatchingConfiguration.EventDispatchingMethod> eventDispatchingMethods = eventDispatchingMethodsEntry.getValue();
            ClassInfo declaringClass = eventDispatchingMethods.iterator().next().getMethod().declaringClass();
            reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{declaringClassName.toString()}).methods(true).fields(true).build());
            String multiplexerClassName = String.valueOf(declaringClassName) + "_Multiplexer";
            reflectiveClasses.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{multiplexerClassName}).methods(true).fields(true).build());
            ClassCreator multiplexerClassCreator = ClassCreator.builder().classOutput(beanClassOutput).className(multiplexerClassName).superClass(declaringClassName.toString()).build();
            multiplexerClassCreator.addAnnotation(Multiplexer.class);
            if (!BuiltinScope.isDeclaredOn((ClassInfo)declaringClass)) {
                multiplexerClassCreator.addAnnotation(Singleton.class);
            }
            for (AnnotationInstance classAnnotation : declaringClass.declaredAnnotations()) {
                multiplexerClassCreator.addAnnotation(classAnnotation);
            }
            if (openTelemetryTracesIntegrationEnabled) {
                telemetryTracesReporterFieldDescriptor = FieldDescriptor.of((String)multiplexerClassName, (String)"telemetryTracesReporter", TelemetryTracesReporter.class);
                FieldCreator telemetryTracesReporterFieldCreator = multiplexerClassCreator.getFieldCreator(telemetryTracesReporterFieldDescriptor);
                telemetryTracesReporterFieldCreator.addAnnotation(Inject.class);
                telemetryTracesReporterFieldCreator.setModifiers(4);
            } else {
                telemetryTracesReporterFieldDescriptor = null;
            }
            if (openTelemetryMetricsIntegrationEnabled) {
                telemetryMetricsReporterFieldDescriptor = FieldDescriptor.of((String)multiplexerClassName, (String)"telemetryMetricsReporter", TelemetryMetricsReporter.class);
                FieldCreator telemetryMetricsReporterFieldCreator = multiplexerClassCreator.getFieldCreator(telemetryMetricsReporterFieldDescriptor);
                telemetryMetricsReporterFieldCreator.addAnnotation(Inject.class);
                telemetryMetricsReporterFieldCreator.setModifiers(4);
            } else {
                telemetryMetricsReporterFieldDescriptor = null;
            }
            FieldDescriptor errorHandlerFieldDescriptor = FieldDescriptor.of((String)multiplexerClassName, (String)"errorHandler", ErrorHandler.class);
            FieldCreator errorHandlerFieldCreator = multiplexerClassCreator.getFieldCreator(errorHandlerFieldDescriptor);
            errorHandlerFieldCreator.addAnnotation(Inject.class);
            errorHandlerFieldCreator.setModifiers(4);
            for (MethodInfo originalConstructor : declaringClass.constructors()) {
                MethodCreator constructorCreator = multiplexerClassCreator.getMethodCreator(MethodDescriptor.ofConstructor((String)multiplexerClassName, (String[])((String[])originalConstructor.parameterTypes().stream().map(t -> t.name().toString()).toArray(String[]::new))));
                List<AnnotationInstance> originalMethodAnnotations = originalConstructor.annotations().stream().filter(ai -> ai.target().kind() == AnnotationTarget.Kind.METHOD).toList();
                for (AnnotationInstance originalMethodAnnotation : originalMethodAnnotations) {
                    constructorCreator.addAnnotation(originalMethodAnnotation);
                }
                Map<Short, List<AnnotationInstance>> originalConstructorParameterAnnotationMapping = originalConstructor.annotations().stream().filter(ai -> ai.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER).collect(Collectors.groupingBy(ai -> ai.target().asMethodParameter().position()));
                ArrayList<ResultHandle> parametersRh = new ArrayList<ResultHandle>();
                for (short i = 0; i < originalConstructor.parameterTypes().size(); i = (short)(i + 1)) {
                    parametersRh.add(constructorCreator.getMethodParam((int)i));
                    AnnotatedElement parameterAnnotations = constructorCreator.getParameterAnnotations((int)i);
                    List originalConstructorParameterAnnotations = originalConstructorParameterAnnotationMapping.getOrDefault(i, Collections.emptyList());
                    for (AnnotationInstance originalConstructorParameterAnnotation : originalConstructorParameterAnnotations) {
                        parameterAnnotations.addAnnotation(originalConstructorParameterAnnotation);
                    }
                }
                constructorCreator.invokeSpecialMethod(MethodDescriptor.of((MethodInfo)originalConstructor), constructorCreator.getThis(), (ResultHandle[])parametersRh.toArray(ResultHandle[]::new));
                constructorCreator.returnValue(null);
            }
            for (DispatchingConfiguration.EventDispatchingMethod eventDispatchingMethod : eventDispatchingMethods) {
                ResultHandle telemetryScopeWrapperRh;
                ResultHandle telemetrySpanWrapperRh;
                AnnotationInstance eventSubscriberInstance = eventDispatchingMethod.getEventSubscriberInstance();
                MethodInfo originalMethod = eventDispatchingMethod.getMethod();
                Map<Short, List<AnnotationInstance>> originalMethodParameterAnnotationMapping = originalMethod.annotations().stream().filter(ai -> ai.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER).collect(Collectors.groupingBy(ai -> ai.target().asMethodParameter().position()));
                if (originalMethod.hasAnnotation(DotNames.OBSERVES) || originalMethod.hasAnnotation(DotNames.OBSERVES_ASYNC)) {
                    LOG.warn((Object)("Methods listening to GitHub events may not be annotated with @Observes or @ObservesAsync. Offending method: " + String.valueOf(originalMethod.declaringClass().name()) + "#" + String.valueOf(originalMethod)));
                }
                ArrayList<String> parameterTypes = new ArrayList<String>();
                List originalMethodParameterTypes = originalMethod.parameterTypes();
                short payloadParameterPosition = -1;
                boolean isPayloadGitHubEvent = false;
                for (short i = 0; i < originalMethodParameterTypes.size(); i = (short)((short)(i + 1))) {
                    List parameterAnnotations = originalMethodParameterAnnotationMapping.getOrDefault(i, Collections.emptyList());
                    if (!parameterAnnotations.stream().anyMatch(ai -> ai.name().equals((Object)eventSubscriberInstance.name()))) continue;
                    payloadParameterPosition = i;
                    isPayloadGitHubEvent = GitHubAppDotNames.GITHUB_EVENT.equals((Object)((org.jboss.jandex.Type)originalMethodParameterTypes.get(payloadParameterPosition)).name());
                    break;
                }
                if (payloadParameterPosition == -1) {
                    throw new IllegalStateException("Unable to find the payload parameter position. Offending method: " + String.valueOf(originalMethod.declaringClass().name()) + "#" + String.valueOf(originalMethod));
                }
                short j = 0;
                HashMap<Short, Short> parameterMapping = new HashMap<Short, Short>();
                for (short i = 0; i < originalMethodParameterTypes.size(); i = (short)(i + 1)) {
                    List originalMethodAnnotations = originalMethodParameterAnnotationMapping.getOrDefault(i, Collections.emptyList());
                    if (originalMethodAnnotations.stream().anyMatch(ai -> GitHubAppDotNames.CONFIG_FILE.equals((Object)ai.name())) || GitHubAppDotNames.GITHUB.equals((Object)((org.jboss.jandex.Type)originalMethodParameterTypes.get(i)).name()) || GitHubAppDotNames.GITHUB_EVENT.equals((Object)((org.jboss.jandex.Type)originalMethodParameterTypes.get(i)).name()) && i != payloadParameterPosition || GitHubAppDotNames.DYNAMIC_GRAPHQL_CLIENT.equals((Object)((org.jboss.jandex.Type)originalMethodParameterTypes.get(i)).name())) continue;
                    String parameterType = i == payloadParameterPosition ? MultiplexedEvent.class.getName() : ((org.jboss.jandex.Type)originalMethodParameterTypes.get(i)).name().toString();
                    parameterTypes.add(parameterType);
                    parameterMapping.put(i, j);
                    j = (short)(j + 1);
                }
                if (originalMethod.hasAnnotation(GitHubAppDotNames.CONFIG_FILE)) {
                    parameterTypes.add(RequestScopeCachingGitHubConfigFileProvider.class.getName());
                }
                MethodCreator methodCreator = multiplexerClassCreator.getMethodCreator(originalMethod.name() + "_" + HashUtil.sha1((String)eventSubscriberInstance.toString()), (Object)originalMethod.returnType().name().toString(), parameterTypes.toArray());
                for (org.jboss.jandex.Type exceptionType : originalMethod.exceptions()) {
                    methodCreator.addException(exceptionType.name().toString());
                }
                ResultHandle[] parameterValues = new ResultHandle[originalMethod.parameterTypes().size()];
                for (short i = 0; i < originalMethodParameterTypes.size(); i = (short)(i + 1)) {
                    Short generatedParameterIndex;
                    List parameterAnnotations = originalMethodParameterAnnotationMapping.getOrDefault(i, Collections.emptyList());
                    if (parameterAnnotations.isEmpty() || (generatedParameterIndex = (Short)parameterMapping.get(i)) == null) continue;
                    AnnotatedElement generatedParameterAnnotations = methodCreator.getParameterAnnotations((int)generatedParameterIndex.shortValue());
                    if (parameterAnnotations.stream().anyMatch(ai -> ai.name().equals((Object)eventSubscriberInstance.name()))) {
                        generatedParameterAnnotations.addAnnotation(DotNames.OBSERVES_ASYNC.toString());
                        generatedParameterAnnotations.addAnnotation(eventSubscriberInstance);
                        continue;
                    }
                    for (AnnotationInstance annotationInstance : parameterAnnotations) {
                        generatedParameterAnnotations.addAnnotation(annotationInstance);
                    }
                }
                ResultHandle multiplexedEventRh = methodCreator.getMethodParam((int)((Short)parameterMapping.get(payloadParameterPosition)).shortValue());
                ResultHandle gitHubEventRh = methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(MultiplexedEvent.class, (String)"getGitHubEvent", GitHubEvent.class, (Class[])new Class[0]), multiplexedEventRh, new ResultHandle[0]);
                ResultHandle payloadRh = !isPayloadGitHubEvent ? methodCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(MultiplexedEvent.class, (String)"getPayload", GHEventPayload.class, (Class[])new Class[0]), multiplexedEventRh, new ResultHandle[0]) : methodCreator.loadNull();
                if (openTelemetryTracesIntegrationEnabled) {
                    telemetrySpanWrapperRh = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(TelemetryTracesReporter.class, (String)"createGitHubEventListeningMethodSpan", TelemetrySpanWrapper.class, (Class[])new Class[]{GitHubEvent.class, String.class, String.class, String.class}), methodCreator.readInstanceField(telemetryTracesReporterFieldDescriptor, methodCreator.getThis()), new ResultHandle[]{gitHubEventRh, methodCreator.load(declaringClassName.toString()), methodCreator.load(originalMethod.name()), methodCreator.load(originalMethod.toString())});
                    telemetryScopeWrapperRh = methodCreator.invokeInterfaceMethod(MethodDescriptor.ofMethod(TelemetryTracesReporter.class, (String)"makeCurrent", TelemetryScopeWrapper.class, (Class[])new Class[]{TelemetrySpanWrapper.class}), methodCreator.readInstanceField(telemetryTracesReporterFieldDescriptor, methodCreator.getThis()), new ResultHandle[]{telemetrySpanWrapperRh});
                } else {
                    telemetrySpanWrapperRh = null;
                    telemetryScopeWrapperRh = null;
                }
                TryBlock tryBlock = methodCreator.tryBlock();
                for (short originalMethodParameterIndex = 0; originalMethodParameterIndex < originalMethodParameterTypes.size(); originalMethodParameterIndex = (short)(originalMethodParameterIndex + 1)) {
                    List parameterAnnotations = originalMethodParameterAnnotationMapping.getOrDefault(originalMethodParameterIndex, Collections.emptyList());
                    Short multiplexerMethodParameterIndex = (Short)parameterMapping.get(originalMethodParameterIndex);
                    if (originalMethodParameterIndex == payloadParameterPosition && !isPayloadGitHubEvent) {
                        parameterValues[originalMethodParameterIndex] = payloadRh;
                        continue;
                    }
                    if (GitHubAppDotNames.GITHUB.equals((Object)((org.jboss.jandex.Type)originalMethodParameterTypes.get(originalMethodParameterIndex)).name())) {
                        parameterValues[originalMethodParameterIndex] = tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(MultiplexedEvent.class, (String)"getGitHub", GitHub.class, (Class[])new Class[0]), multiplexedEventRh, new ResultHandle[0]);
                        continue;
                    }
                    if (GitHubAppDotNames.GITHUB_EVENT.equals((Object)((org.jboss.jandex.Type)originalMethodParameterTypes.get(originalMethodParameterIndex)).name())) {
                        parameterValues[originalMethodParameterIndex] = gitHubEventRh;
                        continue;
                    }
                    if (GitHubAppDotNames.DYNAMIC_GRAPHQL_CLIENT.equals((Object)((org.jboss.jandex.Type)originalMethodParameterTypes.get(originalMethodParameterIndex)).name())) {
                        parameterValues[originalMethodParameterIndex] = tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(MultiplexedEvent.class, (String)"getGitHubGraphQLClient", DynamicGraphQLClient.class, (Class[])new Class[0]), multiplexedEventRh, new ResultHandle[0]);
                        continue;
                    }
                    if (parameterAnnotations.stream().anyMatch(ai -> ai.name().equals((Object)GitHubAppDotNames.CONFIG_FILE))) {
                        AnnotationInstance configFileAnnotationInstance = parameterAnnotations.stream().filter(ai -> ai.name().equals((Object)GitHubAppDotNames.CONFIG_FILE)).findFirst().get();
                        String configObjectType = ((org.jboss.jandex.Type)originalMethodParameterTypes.get(originalMethodParameterIndex)).name().toString();
                        boolean isOptional = false;
                        if (Optional.class.getName().equals(configObjectType)) {
                            if (((org.jboss.jandex.Type)originalMethodParameterTypes.get(originalMethodParameterIndex)).kind() != Type.Kind.PARAMETERIZED_TYPE) {
                                throw new IllegalStateException("Optional is used but not parameterized for method " + String.valueOf(originalMethod.declaringClass().name()) + "#" + String.valueOf(originalMethod));
                            }
                            isOptional = true;
                            configObjectType = ((org.jboss.jandex.Type)((org.jboss.jandex.Type)originalMethodParameterTypes.get(originalMethodParameterIndex)).asParameterizedType().arguments().get(0)).name().toString();
                        }
                        ResultHandle configFileReaderRh = tryBlock.getMethodParam(parameterTypes.size() - 1);
                        ResultHandle ghRepositoryRh = !isPayloadGitHubEvent ? tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod(PayloadHelper.class, (String)"getRepository", GHRepository.class, (Class[])new Class[]{GHEventPayload.class}), new ResultHandle[]{payloadRh}) : tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod(GitHub.class, (String)"getRepository", GHRepository.class, (Class[])new Class[]{String.class}), new ResultHandle[]{tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(GitHubEvent.class, (String)"getRepositoryOrThrow", String.class, (Class[])new Class[0]), gitHubEventRh, new ResultHandle[0])});
                        ResultHandle configObject = tryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(RequestScopeCachingGitHubConfigFileProvider.class, (String)"getConfigObject", Object.class, (Class[])new Class[]{GHRepository.class, String.class, ConfigFile.Source.class, Class.class}), configFileReaderRh, new ResultHandle[]{ghRepositoryRh, tryBlock.load(configFileAnnotationInstance.value().asString()), tryBlock.load((Enum)ConfigFile.Source.valueOf((String)configFileAnnotationInstance.valueWithDefault(index, "source").asEnum())), tryBlock.loadClass(configObjectType)});
                        configObject = tryBlock.checkCast(configObject, configObjectType);
                        if (isOptional) {
                            configObject = tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod(Optional.class, (String)"ofNullable", Optional.class, (Class[])new Class[]{Object.class}), new ResultHandle[]{configObject});
                        }
                        parameterValues[originalMethodParameterIndex] = configObject;
                        continue;
                    }
                    parameterValues[originalMethodParameterIndex] = tryBlock.getMethodParam((int)multiplexerMethodParameterIndex.shortValue());
                }
                ResultHandle returnValue = tryBlock.invokeVirtualMethod(originalMethod, tryBlock.getThis(), parameterValues);
                if (openTelemetryTracesIntegrationEnabled) {
                    tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(TelemetryTracesReporter.class, (String)"reportSuccess", Void.TYPE, (Class[])new Class[]{GitHubEvent.class, TelemetrySpanWrapper.class}), tryBlock.readInstanceField(telemetryTracesReporterFieldDescriptor, tryBlock.getThis()), new ResultHandle[]{gitHubEventRh, telemetrySpanWrapperRh});
                    tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(AutoCloseable.class, (String)"close", Void.TYPE, (Class[])new Class[0]), telemetryScopeWrapperRh, new ResultHandle[0]);
                    tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(TelemetryTracesReporter.class, (String)"endSpan", Void.TYPE, (Class[])new Class[]{TelemetrySpanWrapper.class}), tryBlock.readInstanceField(telemetryTracesReporterFieldDescriptor, tryBlock.getThis()), new ResultHandle[]{telemetrySpanWrapperRh});
                }
                if (openTelemetryMetricsIntegrationEnabled) {
                    tryBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(TelemetryMetricsReporter.class, (String)"incrementGitHubEventMethodSuccess", Void.TYPE, (Class[])new Class[]{GitHubEvent.class, String.class, String.class, String.class}), tryBlock.readInstanceField(telemetryMetricsReporterFieldDescriptor, tryBlock.getThis()), new ResultHandle[]{gitHubEventRh, tryBlock.load(declaringClassName.toString()), tryBlock.load(originalMethod.name()), tryBlock.load(originalMethod.toString())});
                }
                tryBlock.returnValue(returnValue);
                CatchBlockCreator catchBlock = tryBlock.addCatch(Throwable.class);
                catchBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(ErrorHandler.class, (String)"handleError", Void.TYPE, (Class[])new Class[]{GitHubEvent.class, GHEventPayload.class, Throwable.class}), catchBlock.readInstanceField(errorHandlerFieldDescriptor, catchBlock.getThis()), new ResultHandle[]{gitHubEventRh, payloadRh, catchBlock.getCaughtException()});
                if (openTelemetryTracesIntegrationEnabled) {
                    catchBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(TelemetryTracesReporter.class, (String)"reportException", Void.TYPE, (Class[])new Class[]{GitHubEvent.class, TelemetrySpanWrapper.class, Throwable.class}), catchBlock.readInstanceField(telemetryTracesReporterFieldDescriptor, catchBlock.getThis()), new ResultHandle[]{gitHubEventRh, telemetrySpanWrapperRh, catchBlock.getCaughtException()});
                    catchBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(AutoCloseable.class, (String)"close", Void.TYPE, (Class[])new Class[0]), telemetryScopeWrapperRh, new ResultHandle[0]);
                    catchBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(TelemetryTracesReporter.class, (String)"endSpan", Void.TYPE, (Class[])new Class[]{TelemetrySpanWrapper.class}), catchBlock.readInstanceField(telemetryTracesReporterFieldDescriptor, catchBlock.getThis()), new ResultHandle[]{telemetrySpanWrapperRh});
                }
                if (openTelemetryMetricsIntegrationEnabled) {
                    catchBlock.invokeInterfaceMethod(MethodDescriptor.ofMethod(TelemetryMetricsReporter.class, (String)"incrementGitHubEventMethodError", Void.TYPE, (Class[])new Class[]{GitHubEvent.class, String.class, String.class, String.class, Throwable.class}), catchBlock.readInstanceField(telemetryMetricsReporterFieldDescriptor, catchBlock.getThis()), new ResultHandle[]{gitHubEventRh, catchBlock.load(declaringClassName.toString()), catchBlock.load(originalMethod.name()), catchBlock.load(originalMethod.toString()), catchBlock.getCaughtException()});
                }
                catchBlock.returnValue(null);
            }
            multiplexerClassCreator.close();
        }
    }

    private static ResultHandle fireAsyncAction(BytecodeCreator bytecodeCreator, LaunchMode launchMode, String className, ResultHandle gitHubEventRh, ResultHandle multiplexedEventRh, ResultHandle annotationLiteralArrayRh) {
        ResultHandle cdiEventRh = bytecodeCreator.invokeInterfaceMethod(EVENT_SELECT, bytecodeCreator.readInstanceField(FieldDescriptor.of((String)className, (String)EVENT_EMITTER_FIELD, Event.class), bytecodeCreator.getThis()), new ResultHandle[]{annotationLiteralArrayRh});
        ResultHandle fireAsyncCompletionStageRH = bytecodeCreator.invokeInterfaceMethod(EVENT_FIRE_ASYNC, cdiEventRh, new ResultHandle[]{multiplexedEventRh});
        if (LaunchMode.TEST.equals((Object)launchMode)) {
            ResultHandle toFutureRH = bytecodeCreator.invokeInterfaceMethod(COMPLETION_STAGE_TO_COMPLETABLE_FUTURE, fireAsyncCompletionStageRH, new ResultHandle[0]);
            return bytecodeCreator.invokeVirtualMethod(COMPLETABLE_FUTURE_JOIN, toFutureRH, new ResultHandle[0]);
        }
        return fireAsyncCompletionStageRH;
    }

    private static String getLiteralClassName(DotName annotationName) {
        return String.valueOf(annotationName) + "_AnnotationLiteral";
    }

    private static void systemOutPrintln(BytecodeCreator bytecodeCreator, ResultHandle resultHandle) {
        bytecodeCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(PrintStream.class, (String)"println", Void.TYPE, (Class[])new Class[]{String.class}), bytecodeCreator.readStaticField(FieldDescriptor.of(System.class, (String)"out", PrintStream.class)), new ResultHandle[]{bytecodeCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(Object.class, (String)"toString", String.class, (Class[])new Class[0]), resultHandle, new ResultHandle[0])});
    }

    private static class RemoveBridgeMethodsClassVisitor
    extends ClassVisitor {
        private static final Logger LOG = Logger.getLogger(RemoveBridgeMethodsClassVisitor.class);
        private final String className;
        private final Set<String> methodsWithBridges;

        public RemoveBridgeMethodsClassVisitor(ClassVisitor visitor, String className, Set<String> methodsWithBridges) {
            super(589824, visitor);
            this.className = className;
            this.methodsWithBridges = methodsWithBridges;
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            if (this.methodsWithBridges.contains(name) && (access & 0x40) != 0 && (access & 0x1000) != 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debugf("Class %1$s - Removing method %2$s %3$s(%4$s)", new Object[]{this.className, org.objectweb.asm.Type.getReturnType((String)descriptor), name, Arrays.toString(org.objectweb.asm.Type.getArgumentTypes((String)descriptor))});
                }
                return null;
            }
            return super.visitMethod(access, name, descriptor, signature, exceptions);
        }
    }
}

