/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.deployment;

import io.quarkiverse.githubapp.deployment.GitHubAppDotNames;
import io.quarkus.arc.processor.DotNames;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationTransformation;
import org.jboss.jandex.DotName;

class VetoUserDefinedEventListeningClassesAnnotationsTransformer
implements AnnotationTransformation {
    private final Set<DotName> eventDefinitionAnnotations;

    VetoUserDefinedEventListeningClassesAnnotationsTransformer(Set<DotName> eventDefinitionAnnotations) {
        this.eventDefinitionAnnotations = eventDefinitionAnnotations;
    }

    public boolean supports(AnnotationTarget.Kind kind) {
        return AnnotationTarget.Kind.CLASS.equals((Object)kind);
    }

    public void apply(AnnotationTransformation.TransformationContext transformationContext) {
        if (transformationContext.hasAnnotation(GitHubAppDotNames.MULTIPLEXER)) {
            return;
        }
        if (this.isEventListeningClass(transformationContext)) {
            transformationContext.add(AnnotationInstance.builder((DotName)DotNames.VETOED).build());
        }
    }

    public boolean isEventListeningClass(AnnotationTransformation.TransformationContext transformationContext) {
        if (transformationContext.hasAnnotation(GitHubAppDotNames.RAW_EVENT)) {
            return true;
        }
        for (DotName eventDefiningAnnotation : this.eventDefinitionAnnotations) {
            if (!transformationContext.hasAnnotation(eventDefiningAnnotation)) continue;
            return true;
        }
        return false;
    }
}

