/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.deployment;

import io.quarkiverse.githubapp.deployment.GitHubAppDotNames;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

class DispatchingConfiguration {
    private final Map<String, EventDispatchingConfiguration> eventConfigurations = new TreeMap<String, EventDispatchingConfiguration>();
    private final Map<DotName, TreeSet<EventDispatchingMethod>> methods = new TreeMap<DotName, TreeSet<EventDispatchingMethod>>();

    DispatchingConfiguration() {
    }

    public Map<String, EventDispatchingConfiguration> getEventConfigurations() {
        return this.eventConfigurations;
    }

    public EventDispatchingConfiguration getOrCreateEventConfiguration(String event, String payloadType) {
        EventDispatchingConfiguration eventDispatchingConfiguration = this.eventConfigurations.computeIfAbsent(event, et -> new EventDispatchingConfiguration(event));
        if (eventDispatchingConfiguration.getPayloadType() == null && payloadType != null && !GitHubAppDotNames.GITHUB_EVENT.toString().equals(payloadType)) {
            eventDispatchingConfiguration.setPayloadType(payloadType);
        }
        return eventDispatchingConfiguration;
    }

    public Map<DotName, TreeSet<EventDispatchingMethod>> getMethods() {
        return this.methods;
    }

    public void addEventDispatchingMethod(EventDispatchingMethod eventDispatchingMethod) {
        this.methods.computeIfAbsent(eventDispatchingMethod.getMethod().declaringClass().name(), k -> new TreeSet()).add(eventDispatchingMethod);
    }

    public boolean requiresGraphQLClient() {
        for (EventDispatchingMethod eventDispatchingMethod : this.methods.values().stream().flatMap(Collection::stream).collect(Collectors.toList())) {
            if (!eventDispatchingMethod.requiresGraphQLClient()) continue;
            return true;
        }
        return false;
    }

    static class EventDispatchingConfiguration {
        private final String event;
        private String payloadType;
        private final TreeMap<String, Set<EventAnnotation>> eventAnnotations = new TreeMap();

        EventDispatchingConfiguration(String event) {
            this.event = event;
        }

        public String getEvent() {
            return this.event;
        }

        public void setPayloadType(String payloadType) {
            this.payloadType = payloadType;
        }

        public String getPayloadType() {
            return this.payloadType;
        }

        public TreeMap<String, Set<EventAnnotation>> getEventAnnotations() {
            return this.eventAnnotations;
        }

        public Set<EventAnnotationLiteral> getEventAnnotationLiterals() {
            HashSet<EventAnnotationLiteral> literals = new HashSet<EventAnnotationLiteral>();
            for (Set<EventAnnotation> eventAnnotations : this.eventAnnotations.values()) {
                for (EventAnnotation eventAnnotation : eventAnnotations) {
                    literals.add(new EventAnnotationLiteral(eventAnnotation.getName(), eventAnnotation.getValues().stream().map(av -> av.name()).collect(Collectors.toList())));
                }
            }
            return literals;
        }

        public EventDispatchingConfiguration addEventAnnotation(String action, AnnotationInstance annotationInstance, List<AnnotationValue> values) {
            this.eventAnnotations.computeIfAbsent(action, a -> new TreeSet()).add(new EventAnnotation(annotationInstance.name(), values));
            return this;
        }
    }

    static class EventDispatchingMethod
    implements Comparable<EventDispatchingMethod> {
        private final AnnotationInstance eventSubscriberInstance;
        private final MethodInfo method;

        EventDispatchingMethod(AnnotationInstance eventSubscriberInstance, MethodInfo method) {
            this.eventSubscriberInstance = eventSubscriberInstance;
            this.method = method;
        }

        public AnnotationInstance getEventSubscriberInstance() {
            return this.eventSubscriberInstance;
        }

        public MethodInfo getMethod() {
            return this.method;
        }

        public boolean requiresGraphQLClient() {
            return this.method.parameterTypes().stream().map(t -> t.name()).anyMatch(n -> GitHubAppDotNames.DYNAMIC_GRAPHQL_CLIENT.equals(n));
        }

        @Override
        public int compareTo(EventDispatchingMethod other) {
            int classNameCompareTo = this.method.declaringClass().name().compareTo(other.method.declaringClass().name());
            if (classNameCompareTo != 0) {
                return classNameCompareTo;
            }
            int methodNameComparator = this.method.toString().compareTo(other.method.toString());
            if (methodNameComparator != 0) {
                return methodNameComparator;
            }
            return this.eventSubscriberInstance.toString(false).compareTo(other.eventSubscriberInstance.toString(false));
        }
    }

    static class EventAnnotationLiteral {
        private final DotName name;
        private final List<String> attributes;

        EventAnnotationLiteral(DotName name, List<String> attributes) {
            this.name = name;
            this.attributes = attributes;
        }

        public DotName getName() {
            return this.name;
        }

        public List<String> getAttributes() {
            return this.attributes;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EventAnnotationLiteral other = (EventAnnotationLiteral)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.attributes, other.attributes);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.attributes);
        }
    }

    static class EventAnnotation
    implements Comparable<EventAnnotation> {
        private final DotName name;
        private final List<AnnotationValue> values;

        EventAnnotation(DotName name, List<AnnotationValue> values) {
            this.name = name;
            this.values = values;
        }

        public DotName getName() {
            return this.name;
        }

        public boolean isRawEvent() {
            return GitHubAppDotNames.RAW_EVENT.equals((Object)this.name);
        }

        public List<AnnotationValue> getValues() {
            return this.values;
        }

        @Override
        public int compareTo(EventAnnotation other) {
            int nameCompareTo = this.name.compareTo(other.name);
            if (nameCompareTo != 0) {
                return nameCompareTo;
            }
            int valuesLengthCompare = Integer.compare(this.values.size(), other.values.size());
            if (valuesLengthCompare != 0) {
                return valuesLengthCompare;
            }
            for (int i = 0; i < this.values.size(); ++i) {
                int valueCompare = this.values.get(i).asString().compareTo(other.values.get(i).asString());
                if (valueCompare == 0) continue;
                return valueCompare;
            }
            return 0;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.values);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EventAnnotation other = (EventAnnotation)o;
            return Objects.equals(this.name, other.name) && Objects.equals(this.values, other.values);
        }
    }
}

