/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.testing.internal;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.listeners.InvocationListener;
import org.mockito.listeners.MethodInvocationReport;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

final class DefaultableMocking<M> {
    private final M mock;
    private final StubDetectingInvocationListener listener;

    static <M> DefaultableMocking<M> create(Class<M> clazz, Object id) {
        StubDetectingInvocationListener listener = new StubDetectingInvocationListener();
        Object mock = Mockito.mock(clazz, (MockSettings)Mockito.withSettings().name(clazz.getSimpleName() + "#" + id).withoutAnnotations().invocationListeners(new InvocationListener[]{listener}));
        return new DefaultableMocking<Object>(mock, listener);
    }

    private DefaultableMocking(M mock, StubDetectingInvocationListener listener) {
        this.mock = mock;
        this.listener = listener;
    }

    M mock() {
        return this.mock;
    }

    Object callMock(InvocationOnMock invocation) throws Throwable {
        return this.call(this.mock, invocation);
    }

    Object callMockOrDefault(InvocationOnMock invocation, Answer<?> defaultAnswer) throws Throwable {
        Object result = this.callMock(invocation);
        if (this.listener.lastInvocationWasMocked) {
            return result;
        }
        this.call(Mockito.verify(this.mock, (VerificationMode)Mockito.atLeastOnce()), invocation);
        return defaultAnswer.answer(invocation);
    }

    Object call(Object self, InvocationOnMock invocation) throws Throwable {
        Object[] argumentsForJava = this.unexpandArguments(invocation);
        return invocation.getMethod().invoke(self, argumentsForJava);
    }

    private Object[] unexpandArguments(InvocationOnMock invocation) {
        Method method = invocation.getMethod();
        Parameter[] parameters = method.getParameters();
        Object[] unexpandedArguments = new Object[parameters.length];
        Object[] argumentsWithExpandedVarArgs = invocation.getArguments();
        for (int i = 0; i < unexpandedArguments.length; ++i) {
            if (parameters[i].isVarArgs()) {
                int varArgSize = argumentsWithExpandedVarArgs.length - parameters.length + 1;
                Object varArgs = Array.newInstance(parameters[i].getType().getComponentType(), varArgSize);
                if (varArgSize > 0) {
                    System.arraycopy(argumentsWithExpandedVarArgs, i, varArgs, 0, varArgSize);
                }
                unexpandedArguments[i] = varArgs;
                continue;
            }
            unexpandedArguments[i] = argumentsWithExpandedVarArgs[i];
        }
        return unexpandedArguments;
    }

    private static class StubDetectingInvocationListener
    implements InvocationListener {
        private boolean lastInvocationWasMocked = false;

        private StubDetectingInvocationListener() {
        }

        public void reportInvocation(MethodInvocationReport methodInvocationReport) {
            this.lastInvocationWasMocked = methodInvocationReport.getLocationOfStubbing() != null;
        }
    }
}

