/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.testing.internal;

import io.quarkiverse.githubapp.runtime.github.GitHubFileDownloader;
import io.quarkiverse.githubapp.runtime.github.GitHubService;
import io.quarkiverse.githubapp.testing.dsl.GitHubMockContext;
import io.quarkiverse.githubapp.testing.dsl.GitHubMockSetupContext;
import io.quarkiverse.githubapp.testing.dsl.GitHubMockVerificationContext;
import io.quarkiverse.githubapp.testing.internal.CallRealMethodAndSpyGHObjectResults;
import io.quarkiverse.githubapp.testing.internal.DefaultableMocking;
import io.quarkiverse.githubapp.testing.internal.GitHubAppTestingContext;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public final class GitHubMockContextImpl
implements GitHubMockContext,
GitHubMockSetupContext,
GitHubMockVerificationContext {
    final GitHubService service;
    final GitHubFileDownloader fileDownloader;
    private final List<MockMap<?, ?>> allMockMaps = new ArrayList();
    private final MockMap<Long, GitHub> clients = new MockMap(GitHub.class);
    private final MockMap<String, GHRepository> repositories = new MockMap(GHRepository.class);
    private final Map<Class<?>, MockMap<Long, ? extends GHObject>> nonRepositoryGHObjectMockMaps = new LinkedHashMap();

    GitHubMockContextImpl() {
        this.fileDownloader = (GitHubFileDownloader)Mockito.mock(GitHubFileDownloader.class);
        this.service = (GitHubService)Mockito.mock(GitHubService.class);
    }

    @Override
    public GitHub client(long id) {
        return this.clients.getOrCreate(id, newClient -> {
            try {
                Mockito.when((Object)newClient.getRepository((String)ArgumentMatchers.any())).thenAnswer(invocation -> this.repository((String)invocation.getArgument(0, String.class)));
                Mockito.when((Object)newClient.parseEventPayload((Reader)ArgumentMatchers.any(), (Class)ArgumentMatchers.any())).thenAnswer(invocation -> {
                    Object original = invocation.callRealMethod();
                    return Mockito.mock(original.getClass(), (MockSettings)Mockito.withSettings().spiedInstance(original).withoutAnnotations().defaultAnswer((Answer)new CallRealMethodAndSpyGHObjectResults(this)));
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).mock();
    }

    @Override
    public <T> void configFileFromClasspath(String pathInRepository, String pathInClassPath) throws IOException {
        this.configFileFromString(pathInRepository, GitHubAppTestingContext.get().getFromClasspath(pathInClassPath));
    }

    @Override
    public <T> void configFileFromString(String pathInRepository, String configFile) {
        Mockito.when((Object)this.fileDownloader.getFileContent((GHRepository)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)GitHubMockContextImpl.getGitHubFilePath(pathInRepository)))).thenReturn(Optional.of(configFile));
    }

    @Override
    public GHRepository repository(String id) {
        return this.repositories.getOrCreate(id).mock();
    }

    @Override
    public GHIssue issue(long id) {
        return this.nonRepositoryMockMap(GHIssue.class).getOrCreate(id).mock();
    }

    @Override
    public GHPullRequest pullRequest(long id) {
        return this.nonRepositoryMockMap(GHPullRequest.class).getOrCreate(id).mock();
    }

    @Override
    public Object[] ghObjects() {
        ArrayList<GHObject> result = new ArrayList<GHObject>();
        for (MockMap<?, ?> mockMap : this.allMockMaps) {
            if (!GHObject.class.isAssignableFrom(mockMap.clazz)) continue;
            for (DefaultableMocking mocking : mockMap.map.values()) {
                result.add((GHObject)mocking.mock());
            }
        }
        return result.toArray();
    }

    void init() {
        this.reset();
        Mockito.when((Object)this.service.getInstallationClient((Long)ArgumentMatchers.any())).thenAnswer(invocation -> this.client((Long)invocation.getArgument(0, Long.class)));
    }

    void reset() {
        Mockito.reset((Object[])new GitHubService[]{this.service});
        Mockito.reset((Object[])new GitHubFileDownloader[]{this.fileDownloader});
        for (MockMap<?, ?> mockMap : this.allMockMaps) {
            mockMap.map.clear();
        }
    }

    private static String getGitHubFilePath(String path) {
        if (path.startsWith("/")) {
            return path.substring(1);
        }
        return ".github/" + path;
    }

    DefaultableMocking<? extends GHObject> ghObjectMocking(GHObject original) {
        Class<?> type = original.getClass();
        if (GHRepository.class.equals(type)) {
            return this.repositories.getOrCreate(((GHRepository)original).getName());
        }
        return this.nonRepositoryMockMap(type).getOrCreate(original.getId());
    }

    <T extends GHObject> MockMap<Long, T> nonRepositoryMockMap(Class<T> type) {
        if (GHRepository.class.equals(type)) {
            throw new IllegalArgumentException("Type must not be GHRepository -- there is a bug in the testing helper.");
        }
        return this.nonRepositoryGHObjectMockMaps.computeIfAbsent(type, clazz -> new MockMap(type));
    }

    private final class MockMap<ID, T> {
        private final Class<T> clazz;
        private final Map<ID, DefaultableMocking<T>> map = new LinkedHashMap<ID, DefaultableMocking<T>>();

        private MockMap(Class<T> clazz) {
            this.clazz = clazz;
            GitHubMockContextImpl.this.allMockMaps.add(this);
        }

        private DefaultableMocking<T> getOrCreate(ID id) {
            return this.map.computeIfAbsent(id, this::create);
        }

        private DefaultableMocking<T> getOrCreate(ID id, Consumer<T> consumerIfCreated) {
            return this.map.computeIfAbsent(id, theId -> {
                DefaultableMocking<T> result = this.create(theId);
                consumerIfCreated.accept(result.mock());
                return result;
            });
        }

        private DefaultableMocking<T> create(Object id) {
            return DefaultableMocking.create(this.clazz, id);
        }
    }
}

