/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.testing.internal;

import io.quarkiverse.githubapp.runtime.github.GitHubFileDownloader;
import io.quarkiverse.githubapp.runtime.github.GitHubService;
import io.quarkiverse.githubapp.testing.internal.GitHubAppTestingContext;
import io.quarkiverse.githubapp.testing.internal.GitHubMockContextImpl;
import io.quarkus.test.junit.QuarkusMock;
import io.quarkus.test.junit.callback.QuarkusTestAfterConstructCallback;
import io.quarkus.test.junit.callback.QuarkusTestAfterEachCallback;
import io.quarkus.test.junit.callback.QuarkusTestBeforeEachCallback;
import io.quarkus.test.junit.callback.QuarkusTestMethodContext;
import java.lang.annotation.Annotation;
import java.util.Map;

public final class GitHubAppTestingCallback
implements QuarkusTestAfterConstructCallback,
QuarkusTestBeforeEachCallback,
QuarkusTestAfterEachCallback {
    private static final String ENABLED_KEY = "quarkiverse-github-app-testing.enabled";

    public static void enable(Map<String, String> systemProperties) {
        systemProperties.put(ENABLED_KEY, "true");
    }

    static boolean isEnabled() {
        return Boolean.getBoolean(ENABLED_KEY);
    }

    public void afterConstruct(Object testInstance) {
        if (!GitHubAppTestingCallback.isEnabled()) {
            GitHubAppTestingContext.reset();
            return;
        }
        GitHubAppTestingContext.set(testInstance);
        GitHubMockContextImpl mocks = GitHubAppTestingContext.get().mocks;
        QuarkusMock.installMockForType((Object)mocks.service, GitHubService.class, (Annotation[])new Annotation[0]);
        QuarkusMock.installMockForType((Object)mocks.fileDownloader, GitHubFileDownloader.class, (Annotation[])new Annotation[0]);
    }

    public void beforeEach(QuarkusTestMethodContext context) {
        if (!GitHubAppTestingCallback.isEnabled()) {
            return;
        }
        GitHubAppTestingContext.get().mocks.init();
    }

    public void afterEach(QuarkusTestMethodContext context) {
        if (!GitHubAppTestingCallback.isEnabled()) {
            return;
        }
        GitHubAppTestingContext.get().mocks.reset();
    }
}

