/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.githubapp.testing.internal;

import com.google.common.base.Charsets;
import io.quarkiverse.githubapp.testing.internal.GitHubMockContextImpl;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;

public final class GitHubAppTestingContext {
    private static GitHubAppTestingContext instance;
    public final Object testInstance;
    public final GitHubMockContextImpl mocks;

    public static void set(Object testInstance) {
        instance = new GitHubAppTestingContext(testInstance, new GitHubMockContextImpl());
    }

    public static GitHubAppTestingContext get() {
        return instance;
    }

    public static void reset() {
        instance = null;
    }

    private GitHubAppTestingContext(Object testInstance, GitHubMockContextImpl mocks) {
        this.testInstance = testInstance;
        this.mocks = mocks;
    }

    String getFromClasspath(String path) throws IOException {
        try (InputStream stream = this.testInstance.getClass().getResourceAsStream(path);){
            if (stream == null) {
                throw new IllegalArgumentException("No such file in classpath: '" + path + "'");
            }
            String string = IOUtils.toString((InputStream)stream, (Charset)Charsets.UTF_8);
            return string;
        }
    }
}

